/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MDecoder_H
#define	JT6MDecoder_H

#include <wx/string.h>

#include "common/Correlation.h"

class CJT6MDecoder {

    public:
	CJT6MDecoder(const wxString& fileName);
	~CJT6MDecoder();

	void run();

    private:
	wxString      m_fileName;
	double*       m_audioSamples;
	CCorrelation* m_correlations;
	int           m_samplesCount;

	void   storeCorrelations(double* bin, int samplesCount);
	void   findCorrelation(int& syncBin, int& offset) const;
	void   correlate(int syncBin, int& offset, double& quality) const;
	void   decode(int syncBin, int timeOffset) const;

	int    getCorrelationsIndex(int bin, int offset) const;
};

#endif
