/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common/NCO.h"

#include "FSK441Lookups.h"
#include "FSK441Send.h"
#include "FSK441Defs.h"

#include "fsk441gui/FSK441App.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/log.h>

CFSK441Send::CFSK441Send(CSoundDev* soundDev, CPTTPort* pttPort) :
CSend(soundDev, pttPort)
{
	wxASSERT(soundDev != NULL);
	wxASSERT(pttPort != NULL);
}

CFSK441Send::~CFSK441Send()
{
}

void CFSK441Send::run()
{
	::wxLogInfo(wxT("%ld: Starting FSK441Send"), GetId());

	CFSK441Lookups lookups;
	CNCO nco(FSK441_SAMPLE_RATE);

	getPTTPort()->open();
	getPTTPort()->keyTX();

	getSoundDev()->openWrite();

	unsigned int charPos = 0;

	while (!isStopped() && !getEndTime()) {
		int t1, t2, t3;
		bool ret = lookups.lookupChar(getMessage().GetChar(charPos), t1, t2, t3);

		charPos = (charPos + 1) % getMessage().Length();

		if (!ret)
			lookups.lookupChar(wxT(" "), t1, t2, t3);

		double freq, out[FSK441_SYMBOL_LENGTH];

		freq = double(t1 + 2) * double(FSK441_SAMPLE_RATE) / double(FSK441_SYMBOL_LENGTH);
		nco.generate(freq, out, FSK441_SYMBOL_LENGTH);
		getSoundDev()->write(out, FSK441_SYMBOL_LENGTH, FSK441_SEND_VOLUME);

		freq = double(t2 + 2) * double(FSK441_SAMPLE_RATE) / double(FSK441_SYMBOL_LENGTH);
		nco.generate(freq, out, FSK441_SYMBOL_LENGTH);
		getSoundDev()->write(out, FSK441_SYMBOL_LENGTH, FSK441_SEND_VOLUME);

		freq = double(t3 + 2) * double(FSK441_SAMPLE_RATE) / double(FSK441_SYMBOL_LENGTH);
		nco.generate(freq, out, FSK441_SYMBOL_LENGTH);
		getSoundDev()->write(out, FSK441_SYMBOL_LENGTH, FSK441_SEND_VOLUME);
	}

	getSoundDev()->close();

	getPTTPort()->unkeyTX();
	getPTTPort()->close();

	::wxLogInfo(wxT("%ld: FSK441Send ending"), GetId());
}

bool CFSK441Send::getEndTime() const
{
	wxDateTime now = wxDateTime::UNow();

	if (now.GetSecond() != 29 && now.GetSecond() != 59)
		return false;

	return (now.GetMillisecond() > 700);
}

void CFSK441Send::error(const wxString& text)
{
	::wxLogError(wxT("%ld: %s"), GetId(), text.c_str());

	::wxGetApp().error(text);
}
