/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	SoundPreferences_H
#define	SoundPreferences_H

#include <wx/wx.h>

class CSoundPreferences : public wxPanel {

    public:
	CSoundPreferences(wxWindow* parent, int id, const wxString& fileName, int bits);
	virtual ~CSoundPreferences();

	virtual void onBits(const wxCommandEvent& event);

	virtual bool isValid() const;

	virtual wxString getFileName() const;
	virtual int      getBits() const;

    private:
	wxTextCtrl* m_fileName;
	int         m_bits;

	DECLARE_EVENT_TABLE()
};

#endif
