/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "SoundPreferences.h"

const int BORDER_SIZE = 5;

enum {
	Button_Bits_8 = 100,
	Button_Bits_16
};

BEGIN_EVENT_TABLE(CSoundPreferences, wxPanel)
	EVT_RADIOBUTTON(Button_Bits_8, CSoundPreferences::onBits)
	EVT_RADIOBUTTON(Button_Bits_16, CSoundPreferences::onBits)
END_EVENT_TABLE()

CSoundPreferences::CSoundPreferences(wxWindow* parent, int id, const wxString& fileName, int bits) :
wxPanel(parent, id),
m_fileName(NULL),
m_bits(bits)
{
	wxBoxSizer* sizer = new wxBoxSizer(wxVERTICAL);

	wxBoxSizer* fileNameSizer = new wxBoxSizer(wxHORIZONTAL);

	wxStaticText* label = new wxStaticText(this, -1, wxT("Device"));
	fileNameSizer->Add(label, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_RIGHT, BORDER_SIZE);

	m_fileName = new wxTextCtrl(this, -1, fileName);
	fileNameSizer->Add(m_fileName, 0, wxALL | wxALIGN_CENTRE_VERTICAL | wxALIGN_LEFT, BORDER_SIZE);

	sizer->Add(fileNameSizer, 0, wxALL, BORDER_SIZE);

	wxStaticBoxSizer* bitsBox = new wxStaticBoxSizer(new wxStaticBox(this, -1, wxT("Bits")), wxVERTICAL);

	wxRadioButton* bits8 = new wxRadioButton(this, Button_Bits_8, wxT("8 bit"));
	if (m_bits == 8) bits8->SetValue(true);
	bitsBox->Add(bits8, 0, wxALL, BORDER_SIZE);

	wxRadioButton* bits16 = new wxRadioButton(this, Button_Bits_16, wxT("16 bit"));
	if (m_bits == 16) bits16->SetValue(true);
	bitsBox->Add(bits16, 0, wxALL, BORDER_SIZE);

	sizer->Add(bitsBox, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CSoundPreferences::~CSoundPreferences()
{
}

void CSoundPreferences::onBits(const wxCommandEvent& event)
{
	switch (event.GetId()) {
		case Button_Bits_8:
			m_bits = 8;
			break;
		case Button_Bits_16:
			m_bits = 16;
			break;
	}
}

bool CSoundPreferences::isValid() const
{
	return !m_fileName->GetValue().IsEmpty();
}

int CSoundPreferences::getBits() const
{
	return m_bits;
}

wxString CSoundPreferences::getFileName() const
{
	return m_fileName->GetValue();
}
