/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "ClockPanel.h"

BEGIN_EVENT_TABLE(CClockPanel, wxPanel)
	EVT_PAINT(CClockPanel::onPaint)
END_EVENT_TABLE()

CClockPanel::CClockPanel(wxWindow* parent, int id, const wxPoint& pos, const wxSize& size) :
wxPanel(parent, id, pos, size),
wxTimer(),
m_bitmap(NULL),
m_width(0),
m_height(0)
{
	m_width  = size.GetWidth();
	m_height = size.GetHeight();

	m_bitmap = new wxBitmap(m_width, m_height);

	wxMemoryDC dc;
	dc.SelectObject(*m_bitmap);

	dc.BeginDrawing();
	dc.SetBackground(*wxBLACK_BRUSH);
	dc.Clear();
	dc.EndDrawing();

	Start(250);
}


CClockPanel::~CClockPanel()
{
	delete m_bitmap;
}

void CClockPanel::onPaint(const wxPaintEvent& event)
{
	wxPaintDC dc(this);

	dc.BeginDrawing();
	dc.DrawBitmap(*m_bitmap, 0, 0, false);
	dc.EndDrawing();
}

void CClockPanel::Notify()
{
	wxDateTime now = wxDateTime::Now();

	static int lastSecs = 0;

	if (now.GetSecond() == lastSecs)
		return;

	lastSecs = now.GetSecond();

	wxString strDate = now.Format(wxT("%d %B %Y"), wxDateTime::UTC);
	wxString strTime = now.Format(wxT("%H:%M:%S"), wxDateTime::UTC);

	wxMemoryDC mDC;
	mDC.SelectObject(*m_bitmap);
	mDC.BeginDrawing();

	mDC.SetBackground(*wxBLACK_BRUSH);
	mDC.Clear(),

	mDC.SetTextForeground(*wxWHITE);

	wxFont font1(14, wxDEFAULT, wxNORMAL, wxNORMAL);
	mDC.SetFont(font1);

	wxCoord width1, height1;
	mDC.GetTextExtent(strDate, &width1, &height1);

	int x = m_width / 2 - width1 / 2;
	int y = 2;
	mDC.DrawText(strDate, x, y);

	wxFont font2(26, wxDEFAULT, wxNORMAL, wxNORMAL);
	mDC.SetFont(font2);

	wxCoord width2, height2;
	mDC.GetTextExtent(strTime, &width2, &height2);

	x = m_width / 2 - width2 / 2;
	y = m_height / 2;
	mDC.DrawText(strTime, x, y);

	mDC.EndDrawing();
	mDC.SelectObject(wxNullBitmap);

	wxClientDC cDC(this);
	cDC.BeginDrawing();
	cDC.DrawBitmap(*m_bitmap, 0, 0, false);
	cDC.EndDrawing();
}
