/*
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef Hilbert_H
#define	Hilbert_H

#include <complex>
using namespace std;

class CHilbert {

    public:
	CHilbert(double f1, double f2);
	virtual ~CHilbert();

	virtual void transform(complex<double>* input, complex<double>* output, int length);
	virtual void transform(double* input, complex<double>* output, int length);

    private:
	double* m_iFilter;
	double* m_qFilter;
	double* m_iBuffer;
	double* m_qBuffer;
	int     m_ptr;

	double sinc(double x) const;
	double cosc(double x) const;
	double hamming(double x) const;
	double mac(double* a, int n1, double* b, int n2) const;
};

#endif
