/*

	linuxinfo.c

	Copyright (C) 1998-2000
	All Rights Reserved.

	Alex Buell <alex.buell@tahallah.demon.co.uk>

	Advanced Buell Software Engineering Ltd
	Hampshire, GU31 5DG
	United Kingdom

	Version	Author	Date		Comments
 	----------------------------------------------------------------------
	1.0.0	AIB	199803??	Initial development
	1.0.2	AIB	199803??	Renamed from sysinfo to linuxinfo
					to avoid infringement with a
					commercial product
	1.0.5	AIB	199803??	Added new MHz field for 2.2.x kernels
	1.0.6	AIB	19980306	Added option for testing
	1.1.3	AIB	1999????	If MHz field not detected, does not
					print it
	1.1.4	AIB	1999????	Added -v for versioning
	1.1.6	AIB	20000405	Updates & changes to linuxinfo
	1.1.7	AIB	20000406	Changed to file descriptors
	
	Modelled on Vince Weaver's Linux_logo 2.10
	
	Prints out a line of information about your system.
	Supports Linux on Intel, Sparc, Alpha, m68k and others.	

*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

#include "linuxinfo.h"

int main(int argc, char *argv[])
{
	char ordinals[10][10] = { "Unknown", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine" };

	struct os_stat os;
	struct hw_stat hw;
	struct lib_stat lib;

	int cpuinfo_fd;

	if (argc > 1)
	{
		if (strcmp(argv[1], "-v") == 0)
		{
			printf("%s %s\n", argv[0], VERSION);
			return -1;
		}
		cpuinfo_fd = open(argv[1], O_RDONLY);
	}
	else
		cpuinfo_fd = open(CPUINFO_FILE, O_RDONLY);

	GetOperatingSystemInfo(&os);
	GetHardwareInfo(cpuinfo_fd, &hw);
	GetSystemLibcInfo(&lib);

	printf("%s %s %s %s\n", os.os_name, os.os_hostname, os.os_version, os.os_revision);

	if (strncmp(hw.hw_megahertz, "?", strlen("?")) == 0)
		printf("%s %s processor%s, %s total bogomips, %sM RAM\n", ordinals[hw.hw_processors], \
			hw.hw_cpuinfo, (hw.hw_processors > 1) ? "s" : "", hw.hw_bogomips, hw.hw_memory);
	else
	{
		printf("%s %s %sMHz processor%s, %s total bogomips, %sM RAM\n", ordinals[hw.hw_processors], \
			hw.hw_cpuinfo, hw.hw_megahertz, (hw.hw_processors > 1) ? "s" : "", hw.hw_bogomips, hw.hw_memory);
	}
	printf("System library %s\n", lib.lib_version);

	close(cpuinfo_fd);
	return 0;
}
