#include <string.h>
#include "report.h"

void reports_add_header(SSTRINGS &report, const char *type, const char *string)
{
	SSTRING *header = new SSTRING();
	header->setfromf("#####:%s:%s:#####", type, string);
	report.add(new SSTRING());
	report.add(new SSTRING());
	report.add(header);
	report.add(new SSTRING());
}

void reports_add_string(SSTRINGS &report, const char *str)
{
	report.add(new SSTRING(str));
}

void reports_add_command(SSTRINGS &report, const char *command)
{
	POPEN pop(command,0);
	if (pop.isok()){
		static char buf[1024];
		reports_add_header(report, "command", command);
		while (pop.wait(20) > 0){
			while (pop.readout(buf,sizeof(buf))!=-1){
				if (buf[strlen(buf)-1] == '\n') {
					buf[strlen(buf)-1] = 0;
				}
				report.add (new SSTRING(buf));
			}
		}
	}
}

void reports_add_file(SSTRINGS &report, const char *filename)
{
	static char buffer[1024];
	FILE *file = fopen(filename, "r");
	if (file != NULL) {
		SSTRING *str = NULL;
		reports_add_header(report, "file", filename);
		for (;;) {
			int rsize = fread(buffer, 1, 1024, file);
			if (rsize <= 0) break;
			int pos = 0;
			while (pos < rsize) {
				int lastpos = pos;
				while (buffer[pos] != '\n' && pos < rsize) pos++;
				if (str != NULL) {
					SSTRING tmp;
					tmp.setfrom(buffer+lastpos,pos-lastpos);
					str->append(tmp.get());
				} else {
					str = new SSTRING();
					str->setfrom(buffer+lastpos,pos-lastpos);
				}
				if (pos != rsize) {
					report.add(str);
					str = NULL;
				}
				pos++;
			}
		}
		if (str != NULL) {
			report.add(str);
		}
		fclose(file);
	}
}
