#include <Python.h>
#include "../pythonmod.h"

static PyObject *ErrorObject;
static PyObject *NilObject;

static PyObject *
LCHelpFile_getpath(LCHelpFileObject *self, PyObject *args)
{
	if (!PyArg_ParseTuple(args,""))
		return NULL;
	return PyString_FromString(self->helpfile->getpath());
}

static struct PyMethodDef LCHelpFile_methods[] = {
	{"getpath", (binaryfunc) LCHelpFile_getpath, 1},
	{NULL, NULL}
};

static void
LCHelpFile_dealloc(LCHelpFileObject *self)
{
	delete self->helpfile;
	PyMem_DEL(self);
}

static PyObject *
LCHelpFile_getattr(LCHelpFileObject *self, char *name)
{
	return Py_FindMethod(LCHelpFile_methods, (PyObject*) self, name);
}

PyTypeObject LCHelpFile_Type = {
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"LCHelpFile",
	sizeof(LCHelpFileObject),
	0,
	(destructor) LCHelpFile_dealloc,
	(printfunc) 0,
	(getattrfunc) LCHelpFile_getattr,
	(setattrfunc) 0,
	(cmpfunc) 0,
	(reprfunc) 0,
	0,
	0,
	0,
	(hashfunc) 0,
	(ternaryfunc) 0,
	(reprfunc) 0
};

PyObject *
LCHelpFile_New(const char *subdir, const char *filename)
{
	LCHelpFileObject *self;
	self = PyObject_NEW(LCHelpFileObject, &LCHelpFile_Type);
	if (self == NULL)
		return NULL;
	self->helpfile = new HELP_FILE(subdir,filename);
	self->owner = 1;
	return (PyObject*) self;
}

PyObject *
LCHelpFile_FromHelp(HELP_FILE *helpfile)
{
	LCHelpFileObject *self;
	self = PyObject_NEW(LCHelpFileObject, &LCHelpFile_Type);
	if (self == NULL)
		return NULL;
	self->helpfile = helpfile;
	self->owner = 0;
	return (PyObject*) self;
}

PyObject *
LCHelpFile_FromHelpDealloc(HELP_FILE *helpfile)
{
	LCHelpFileObject *self;
	self = PyObject_NEW(LCHelpFileObject, &LCHelpFile_Type);
	if (self == NULL)
		return NULL;
	self->helpfile = helpfile;
	self->owner = 1;
	return (PyObject*) self;
}

static PyObject *
lchelpfile_LCHelpFile(PyObject *self, PyObject *args)
{
	char *subdir=NULL, *filename=NULL;
	if (!PyArg_ParseTuple(args, "|ss", &subdir, &filename))
		return NULL;
	return LCHelpFile_New(subdir, filename);
}

static struct PyMethodDef lchelpfile_methods[] = {
	{"LCHelpFile", lchelpfile_LCHelpFile, 1},
	{NULL,NULL}
};

extern "C" void
initlchelpfile()
{
	PyObject *m, *d;
	m = Py_InitModule("lchelpfile", lchelpfile_methods);
	d = PyModule_GetDict(m);
	ErrorObject = Py_BuildValue("s", "dialog.error");
	PyDict_SetItemString(d, "error", ErrorObject);
	NilObject = LCHelpFile_FromHelp(&help_nil);
	PyDict_SetItemString(d, "help_nil", NilObject);
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module lchelpfile");
}
