/* this part manages the specific printer properties (opens props window, etc)
   deals with the config files inside the spool directory */

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "printer.h"
#include "printer.m"
// #include <translat.h>

#include "deez_parser.h"
// #include <sys/stat.h>

// #include <modapi.h>

#include "printer_cfile.h"
#include "printer_smbncp-specific.h"
#include "printer_fi.h"




/*
     qual filtro,
     descrio do filtro,

     resoluo (300x300),
     papel(a4),
     prof.cores(default),
     enviar EOF apos job,
     corrigir efeito escada (CRLF),
     impresso veloz(sem filtro PS),
     pginas impressas/pg(1, 2, 4, 8),
     margens dir/esq (18),
     margens topo/baixo (18),
     opes extras p/o GS
     */

/* filed popup menus with printerdb data, according the printer selected */
/* processing:
 0-none
 1-{300} {300} {}            to  300x300
 2-{blabla0} {blablabla..}   to  blabla0, blablabla..
 */
/* initial_data will be kept original unless it can't be found in the
   list.. in such case the first item will be transfered to initial_data.
   this is to avoid the annoying LC warnings: "you must select an item from the list" */
void populate_fieldlist(char *printer_id, char *field_identificator, FIELD_LIST *field_thing, int processing, SSTRING *adjust_data)
{
    char *generated_list;
    char *readpoint;
    char my_desc[500];
    char my_retcod[500];
    char first_item[500];
    int  initial_data_is_ok;

    initial_data_is_ok=0; // not ok, unless said otherwise
    first_item[0]='\0';
    generated_list=return_filter_propertylist(printer_id, field_identificator);
    readpoint=generated_list;
    if((!*readpoint)&&(!adjust_data))
        field_thing->addopt("", MSG_U(M_NOTAVAIL, "(not available)"), "");

    while(*readpoint){
        switch(processing){
        case 0:
            strcpy(my_desc, readpoint);
            strcpy(my_retcod, readpoint);
            break;
        case 1:
            {
                char xres[20],
                     yres[20],
                     commentres[100];

                gimme_string_element(readpoint, 0, xres);
                gimme_string_element(readpoint, 1, yres);
                gimme_string_element(readpoint, 2, commentres);
                sprintf(my_retcod, "%sx%s", xres, yres);
                if(*commentres){
                    sprintf(my_desc, "%s (%s)", my_retcod, commentres);
                } else {
                    sprintf(my_desc, "%s", my_retcod);
                }
            }
            break;
        case 2:
            {
                gimme_string_element(readpoint, 0, my_retcod);
                gimme_string_element(readpoint, 1, my_desc);
            }
            break;

        }
        if(!strcmp("NAxNA", my_desc))
            strcpy(my_desc, MSG_U(M_NOTAVAIL2, "(not available)"));
        if(adjust_data){
            if(!first_item[0])
                strcpy(first_item, my_retcod);
            if(!strcmp(my_retcod, adjust_data->get())){
                initial_data_is_ok=1;
            }
        }else{
            field_thing->addopt(my_retcod, my_desc, "");
        }
        readpoint+=strlen(readpoint)+1;
    }

    if(adjust_data){
        if(!initial_data_is_ok)
            adjust_data->setfrom(first_item);
    }

    free(generated_list);
}

void populate_fieldlist(char *printer_id, char *field_identificator, FIELD_LIST *field_thing, int processing)
{
    populate_fieldlist(printer_id, field_identificator, field_thing, processing, NULL);
}

void adjust_fieldlist_data(char *printer_id, char *field_identificator, int processing, SSTRING &adjust_data)
{
    populate_fieldlist(printer_id, field_identificator, (FIELD_LIST *)NULL, processing, &adjust_data);
}

/* dialog to change the type (Direct, local, smb, et.) of printer */
int change_printer_type(int which_printer, int setto)
{
	int ret = false;
	DIALOG changetype_dialog;
	char type_printr;
	MENU_STATUS my_button;
	char   dotconfig_fullpath[500];

	/* builds .config full path for this queue */
    	sprintf(dotconfig_fullpath, "%s/%s", my_printcap[which_printer].sd, DOTCONFIG_FILENAME);

	/* get the printer type that is already set */
	type_printr=return_printer_type(which_printer);

	if (-1 == setto ) {
		changetype_dialog.newf_title("", (const char*)MSG_R(M_NEWPRTATTACHEDAS));
		changetype_dialog.newf_radio("", type_printr, PRT_LOCAL, (const char*)MSG_R(M_NEWPRTLOCAL));
		changetype_dialog.newf_radio("", type_printr, PRT_REMOTE, (const char*)MSG_R(M_NEWPRTREMOTE));
		changetype_dialog.newf_radio("", type_printr, PRT_SMBWIN, (const char*)MSG_R(M_NEWPRTSMBWIN));
        	changetype_dialog.newf_radio("", type_printr, PRT_NETWARE, (const char*)MSG_R(M_NEWPRTNETW));
        	changetype_dialog.newf_radio("", type_printr, PRT_DIRECT, (const char*)MSG_R(M_NEWPRTDIRECT));
		my_button=changetype_dialog.edit(MSG_U(M_CHANGETYPETT, "Change Printer Type"), MSG_U(M_CHANGETYPETX, "Select a new printer type\n"), help_nil);
	}
	else {
		my_button=MENU_ACCEPT;
		type_printr=setto;
	}
	if (my_button == MENU_ACCEPT){
		ret=true;
            	switch(type_printr){
            		case PRT_LOCAL:
				// if the printer is local, no .config data needed
				dc_var.port[0]=0;
				dc_var.printerip[0]=0;
				dc_var.workgroup[0]=0;
				dc_var.share[0]=0;
				dc_var.hostname[0]=0;
				dc_var.printername[0]=0;
				dc_var.hostip[0]=0;
				dc_var.user[0]=0;
				dc_var.password[0]=0;
				dc_var.server[0]=0;
				dc_var.queue[0]=0;
				my_printcap[which_printer].rm[0]=0;
				if (!strlen(my_printcap[which_printer].lp)) strcpy(my_printcap[which_printer].lp,DEFAULT_PRTDEVICE);
               			break;
            		case PRT_REMOTE:
				// if the printer is remote, no .config data needed
				dc_var.port[0]=0;
				dc_var.printerip[0]=0;
				dc_var.workgroup[0]=0;
				dc_var.share[0]=0;
				dc_var.hostname[0]=0;
				dc_var.printername[0]=0;
				dc_var.hostip[0]=0;
				dc_var.user[0]=0;
				dc_var.password[0]=0;
				dc_var.server[0]=0;
				dc_var.queue[0]=0;
				my_printcap[which_printer].lp[0]=0;
				if (!strlen(my_printcap[which_printer].rm)) strcpy(my_printcap[which_printer].rm,DEFAULT_PRINTERNAME);
                		break;
            		case PRT_SMBWIN:
				// if the printer is smbwin, no DIRECT or SNC info
				dc_var.port[0]=0;
				dc_var.printerip[0]=0;
				//dc_var.workgroup[0]=0;
				//dc_var.share[0]=0;
				//dc_var.hostname[0]=0;
				//dc_var.printername[0]=0;
				//dc_var.hostip[0]=0;
				//dc_var.user[0]=0;
				//dc_var.password[0]=0;
				dc_var.server[0]=0;
				dc_var.queue[0]=0;
				my_printcap[which_printer].rm[0]=0;
				strcpy(my_printcap[which_printer].lp,DEFAULT_PRTSMBDEVICE);
				if (!dc_var.hostname[0]) strcpy(dc_var.hostname, "my_hostname");
				if (!dc_var.printername[0]) strcpy(dc_var.printername, "my_printername");
				if (!dc_var.workgroup[0]) strcpy(dc_var.workgroup, "my_workgroup");
				sprintf(dc_var.share,"\\\\%s\\%s", dc_var.hostname, dc_var.printername);
                		break;
            		case PRT_NETWARE:
				// if the printer is netware, no DIRECT or SMB info
				dc_var.port[0]=0;
				dc_var.printerip[0]=0;
				dc_var.workgroup[0]=0;
				dc_var.share[0]=0;
				dc_var.hostname[0]=0;
				dc_var.printername[0]=0;
				dc_var.hostip[0]=0;
				//dc_var.user[0]=0;
				//dc_var.password[0]=0;
				//dc_var.server[0]=0;
				//dc_var.queue[0]=0;
				my_printcap[which_printer].rm[0]=0;
				strcpy(my_printcap[which_printer].lp,DEFAULT_PRTSMBDEVICE);
				if (!dc_var.user[0]) strcpy(dc_var.user, "my_user");
				if (!dc_var.password[0]) strcpy(dc_var.password, "my_password");
				if (!dc_var.server[0]) strcpy(dc_var.server, "my_server");
				if (!dc_var.queue[0]) strcpy(dc_var.queue, "my_queue");
                		break;
            		case PRT_DIRECT:
				// if the printer is netware, no SMB or SNC info
				//dc_var.port[0]=0;
				//dc_var.printerip[0]=0;
				dc_var.workgroup[0]=0;
				dc_var.hostname[0]=0;
				dc_var.hostip[0]=0;
				dc_var.user[0]=0;
				dc_var.password[0]=0;
				dc_var.server[0]=0;
				dc_var.queue[0]=0;
				my_printcap[which_printer].rm[0]=0;
				strcpy(my_printcap[which_printer].lp,DEFAULT_PRTSMBDEVICE);
				if (!dc_var.port[0]) strcpy(dc_var.port, "my_port");
				if (!dc_var.printerip[0]) strcpy(dc_var.printerip, "my_printerip");
                		break;
            	}
		//save dotconfig file with adjusted values
		save_dotconfig_data(dotconfig_fullpath);
		//Load the "secondary config files"
		//These values automatically adjust the printer type according to the dotconfig
		load_initialise_secondary_configfiles(which_printer);
		//Save adjusted config files
		load_to_gui_variables();
		(void)save_all_printers_data();
		save_all_the_filters_stuff(which_printer);
	}
    return ret;
}

/* this dialog is never called, except by the virtual registry */
/*It removes a named printer*/
void remove_printer_window(void)
{
	DIALOG changetype_dialog;
	char ptr_name[TYPICAL_STRING_SIZE];
	MENU_STATUS my_button;
	int loop;
       	int whichone = -1;
	int tmp = false;

	/* set the string to nothing.  If a "get" it will remain nothing */
	ptr_name[0]=0;

	changetype_dialog.newf_title("", "invisible dialog");
	// the following dialog is only accessed by the vregistry //
	changetype_dialog.newf_str(MSG_U(M_DELETENAME, "Printer Name"), ptr_name, TYPICAL_STRING_SIZE -1);
	my_button=changetype_dialog.edit("invisible dialog", "", help_nil, tmp,MENUBUT_QUIT|MENUBUT_ACCEPT| MENUBUT_OK);
	if (my_button == MENU_ACCEPT) {
		if (ptr_name[0]) {
			for (loop=0; loop < total_printer_entries; loop++) {
				if (general_printer_index[loop].exists) {
					if (strcmp(ptr_name,general_printer_index[loop].devname) == 0) {
						whichone=loop;
					}
				}
			}
			if (whichone == -1) {
				if (isdigit(ptr_name[0])) {
					whichone=atoi(ptr_name);
				}
			}
			
			if (whichone >=0) {
				remove_printer(whichone);
				(void)save_all_printers_data();
			}
		}
	}
}
/* This dialog is only called by the virtual registry */
/* It allows you to change the printer name and spool directory */
int printer_change_printer_name_or_spooldir(int which_printer)
{
	int ret = false;
	int tmp = false;
	DIALOG change_name_dir_dialog;
	char printr_name[TYPICAL_STRING_SIZE];
	char spooldir[TYPICAL_STRING_SIZE];
	MENU_STATUS my_button;

	change_name_dir_dialog.newf_title("", "invisible dialog");
	strcpy(printr_name,general_printer_index[which_printer].devname);
	strcpy(spooldir,my_printcap[which_printer].sd);
	// the following dialog is currently only accessed by the vregistry //
	change_name_dir_dialog.newf_str(MSG_U(M_CHANGEPNAME, "Printer Name"), printr_name, 30);
	change_name_dir_dialog.newf_str(MSG_U(M_CHANGESDIR, "Spool Directory"), spooldir, TYPICAL_STRING_SIZE -1);
	my_button=change_name_dir_dialog.edit("invisible dialog", "", help_nil, tmp,MENUBUT_QUIT|MENUBUT_ACCEPT| MENUBUT_OK);
	if (my_button == MENU_ACCEPT) {
    		if(!printr_name[0]){
        		informational_window((const char*)P_MSG_R(M_PRTNAMEUNDEFINEDTT),
                             (const char*)P_MSG_R(M_PRTNAMEUNDEFINEDTX));
        		return(0);
    		}
    		if(!spooldir[0]){
        		informational_window((const char*)P_MSG_R(M_SPOOLDIRUNDEFTT),
                             	(const char*)P_MSG_R(M_SPOOLDIRUNDEFTX));
        		return(0);
    		}
    		if(invalid_string_provided(spooldir, NULL, " !@#$%^&*()=+?|\\<>,[]{}~`'\0")){
        		informational_window((const char*)P_MSG_R(M_INVALIDCHSPOOLTT),
                             (const char*)P_MSG_R(M_INVALIDCHSPOOLTX));
        		return(0);
    		}
    		if(invalid_string_provided(printr_name, NULL, " !@#$%^&*()=+/?\\<>,[]{}~`'\0")){
        		informational_window((const char*)P_MSG_R(M_PRTNAMEINVALIDTT),
                             (const char*)P_MSG_R(M_PRTNAMEINVALIDTX));
		}
		if(spooldir[0]!='/') {
			//if there is no path, we will prepend the default
			char tmpstr[TYPICAL_STRING_SIZE];
			sprintf(tmpstr,"%s/%s",DEFAULT_VARSPOOLLPD_DIR,spooldir);
			strcpy(spooldir,tmpstr);
		}
		if (strcmp(printr_name,general_printer_index[which_printer].devname)!=0) {
			//The printer name has changed
			strcpy(my_printcap[which_printer].printer_name,printr_name);
			strcpy(general_printer_index[which_printer].devname,printr_name);
			ret=true;
		}
		if (strcmp(spooldir,my_printcap[which_printer].sd)!=0) {
			//The spool directory has changed
			if (rename(my_printcap[which_printer].sd,spooldir)){
				//rename failed for some reason
				char tmpstr[100];
				sprintf(tmpstr,"%s:\n %s",MSG_U(M_SPOOL_CHANGE_FAILED,"There was a problem changing the spool directory"),spooldir);
				informational_window("ERROR",tmpstr);
				return (0);
			} else {
				strcpy(my_printcap[which_printer].sd,spooldir);
				ret=true;
				//rename succeeded
			}
				
		}
	}
    if (ret) { save_all_printers_data(); }
    return ret;
}


/* this dialog is never called, except by the virtual registry */
int printer_change_printer_type(int which_printer)
{
	int ret = false;
	int tmp = false;
	DIALOG changetype_dialog;
	char type_printr[TYPICAL_STRING_SIZE];
	char tmp_ptr;
	char old_ptr;
	MENU_STATUS my_button;
	char   dotconfig_fullpath[500];
	     
		     

	tmp_ptr = return_printer_type(which_printer);
	old_ptr = tmp_ptr;
	/* builds .config full path for this queue */
	sprintf(dotconfig_fullpath, "%s/%s", my_printcap[which_printer].sd, DOTCONFIG_FILENAME);
	switch (tmp_ptr) {
            case PRT_LOCAL:
                strcpy(type_printr, (const char*)MSG_R(M_TYPELOCAL));
                break;
            case PRT_REMOTE:
                strcpy(type_printr, (const char*)MSG_R(M_TYPEREMOTE));
                break;
            case PRT_SMBWIN:
                strcpy(type_printr, (const char*)MSG_R(M_TYPESMBWIN));
                break;
            case PRT_NETWARE:
                strcpy(type_printr, (const char*)MSG_R(M_TYPENETW));
                break;
            case PRT_DIRECT:
                strcpy(type_printr, (const char*)MSG_R(M_TYPEDIRECT));
                break;
	}
	changetype_dialog.newf_title("", "invisible dialog");
	// the following dialog is only accessed by the vregistry //
	changetype_dialog.newf_str(MSG_U(M_CHANGETYPE_REG, "Printer Type"), type_printr, TYPICAL_STRING_SIZE -1);
	my_button=changetype_dialog.edit("invisible dialog", "", help_nil, tmp,MENUBUT_QUIT|MENUBUT_ACCEPT| MENUBUT_OK);
	if (my_button == MENU_ACCEPT) {
                if (strcmp(type_printr, MSG_R(M_TYPELOCAL))==0) tmp_ptr=PRT_LOCAL;
                if (strcmp(type_printr, MSG_R(M_TYPEREMOTE))==0) tmp_ptr=PRT_REMOTE;
                if (strcmp(type_printr, MSG_R(M_TYPESMBWIN))==0) tmp_ptr=PRT_SMBWIN;
                if (strcmp(type_printr, MSG_R(M_TYPENETW))==0) tmp_ptr=PRT_NETWARE;
                if (strcmp(type_printr, MSG_R(M_TYPEDIRECT))==0) tmp_ptr=PRT_DIRECT;
		// If the printer has changed
		if (tmp_ptr != old_ptr) {
			/* load seconday configfiles */
			load_initialise_secondary_configfiles(which_printer);
			/* load .config, if present */
			load_dotconfig_data(dotconfig_fullpath);
			//change printer and save it
			change_printer_type(which_printer,tmp_ptr);

		}
	}
	
    return ret;
}

/* opens a window listing all the printer filters available
 if filter selected, returns true and writes the filtername
 if filter wasn't selected, returns false */
/* the name returned is the printerdb 'Description' field */
int select_printer_filter(char *output_printer_filter, char vreg_only_flag)
{
    int ret = false;
    char *whole_list;
    SSTRING newprinter;
    FIELD_LIST *fieldlist=NULL;
    MENU_STATUS my_button=MENU_OK;
    int nof=0;

	*output_printer_filter='\0';

    if((whole_list=return_filters_list())){
	    DIALOG_RECORDS dia_filter_list;
        dia_filter_list.newf_head("", MSG_U(M_FILTERNAME, "filter name"));

		int my_selection = 0;
	    char *steppy=whole_list;
	    
		int count = 0;
	if (vreg_only_flag) {
		newprinter.setfrom(f_printername);
		fieldlist=dia_filter_list.newf_list((const char*)MSG_U(M_VREG_CHANGEFILTER,"Filter Name"),newprinter);
	}
        while(*steppy){
	    if (strcmp(steppy,f_printername)==0) my_selection = count;
	    if (vreg_only_flag) {
	    	fieldlist->addopt(steppy,steppy,steppy);
	    } else {
            	dia_filter_list.new_menuitem(steppy, "");
	    }
            steppy+=strlen(steppy)+1;
			count ++;
        }

	if (vreg_only_flag) {
	    my_button = dia_filter_list.edit(
			(const char*)P_MSG_R(M_PRTFILTERSLIST)
			, "", help_nil, nof);
	} else {
	    my_button = dia_filter_list.editmenu(
			MSG_U(M_PRTFILTERSLIST, "Printer filters' List")
			, "", help_nil, my_selection, MENUBUT_QUIT);
	}
	    
		if (my_button == MENU_OK || my_button == MENU_ACCEPT){
			if (vreg_only_flag)
			{
				strcpy(output_printer_filter,newprinter.get());
				ret = true;
			}
			else {
	        		steppy=whole_list;
		    		int  my_counter=my_selection+1;
	        		while(my_counter--){
	            			if(!my_counter)
	                			strcpy(output_printer_filter, steppy);
	            			steppy+=strlen(steppy)+1;
	        		}
				ret = true;
			}
		}
        free(whole_list);
    }
    return ret;
}

/* this was originally meant to be a stand-alone window */
/* if *overrider_printer, remake part of configuration
   (because new printer was selected) */
/* returns pressed button */
void editfilter_window(int which_printer, DIALOG &filterwindow, char *overrider_printer)
{
//    DIALOG filterwindow;
//    MENU_STATUS        my_button;

    FIELD_LIST *pop_resolution;
    FIELD_LIST *pop_papersize;
    FIELD_LIST *pop_colordepth;
    FIELD_LIST *pop_printedpages;

    filterwindow.newf_title(MSG_U(M_FILTOPTS, "Filter options"), 1, "", MSG_R(M_FILTOPTS));
    filterwindow.newf_info(MSG_U(M_FILTCURRSELECTED, "Filter currently selected:"), f_printername);

    /* load gui variables */
    load_to_gui_variables();

    /* if new filter was selected, change some config things.. */
    if(*overrider_printer)
        new_filter_so_reset_some_things(overrider_printer);

    /* if printer could not be located, the loaded values aren't in list.. so select in the list the empty one (otherwise there will be annoying requesters from linuxconf) */
    if(!*f_printername){
        f_resolution.setfrom("");
        f_colordepth.setfrom("");
    }

//    filterwindow.newf_info("Filter description:", f_filterdescription);

    adjust_fieldlist_data(f_printername, "Resolution: ", 1, f_resolution);
    pop_resolution=filterwindow.newf_list(MSG_U(M_FLRESOLUTION, "Resolution:"), f_resolution);
    populate_fieldlist(f_printername, "Resolution: ", pop_resolution, 1);
    pop_papersize=filterwindow.newf_list(MSG_U(M_FLPAPERSIZE, "Paper size:"), f_papersize); {
        pop_papersize->addopt("11x17", MSG_U(M_PAPERTYPE1117, "11x17"), "");
        pop_papersize->addopt("a0", MSG_U(M_PAPERTYPEA0, "A0"), "");
        pop_papersize->addopt("a1", MSG_U(M_PAPERTYPEA1, "A1"), "");
        pop_papersize->addopt("a2", MSG_U(M_PAPERTYPEA2, "A2"), "");
        pop_papersize->addopt("a3", MSG_U(M_PAPERTYPEA3, "A3"), "");
        pop_papersize->addopt("a4", MSG_U(M_PAPERTYPEA4, "A4"), "");
        pop_papersize->addopt("a5", MSG_U(M_PAPERTYPEA5, "A5"), "");
        pop_papersize->addopt("a6", MSG_U(M_PAPERTYPEA6, "A6"), "");
        pop_papersize->addopt("a7", MSG_U(M_PAPERTYPEA7, "A7"), "");
        pop_papersize->addopt("a8", MSG_U(M_PAPERTYPEA8, "A8"), "");
        pop_papersize->addopt("a9", MSG_U(M_PAPERTYPEA9, "A9"), "");
        pop_papersize->addopt("a10", MSG_U(M_PAPERTYPEA10, "A10"), "");
        pop_papersize->addopt("archA", MSG_U(M_PAPERTYPEARA, "archA"), "");
        pop_papersize->addopt("archB", MSG_U(M_PAPERTYPEARB, "archB"), "");
        pop_papersize->addopt("archC", MSG_U(M_PAPERTYPEARC, "archC"), "");
        pop_papersize->addopt("archD", MSG_U(M_PAPERTYPEARD, "archD"), "");
        pop_papersize->addopt("archE", MSG_U(M_PAPERTYPEARE, "archE"), "");
        pop_papersize->addopt("b0", MSG_U(M_PAPERTYPEB0, "B0"), "");
        pop_papersize->addopt("b1", MSG_U(M_PAPERTYPEB1, "B1"), "");
        pop_papersize->addopt("b2", MSG_U(M_PAPERTYPEB2, "B2"), "");
        pop_papersize->addopt("b3", MSG_U(M_PAPERTYPEB3, "B3"), "");
        pop_papersize->addopt("b4", MSG_U(M_PAPERTYPEB4, "B4"), "");
        pop_papersize->addopt("b5", MSG_U(M_PAPERTYPEB5, "B5"), "");
        pop_papersize->addopt("flsa", MSG_U(M_PAPERTYPEFLSA, "flsa"), "");
        pop_papersize->addopt("flse", MSG_U(M_PAPERTYPEFLSE, "flse"), "");
        pop_papersize->addopt("halfletter", MSG_U(M_PAPERTYPEHLET, "halfletter"), "");
        pop_papersize->addopt("ledger", MSG_U(M_PAPERTYPELEDG, "ledger"), "");
        pop_papersize->addopt("legal", MSG_U(M_PAPERTYPELEGAL, "legal"), "");
        pop_papersize->addopt("letter", MSG_U(M_PAPERTYPELETTER, "letter"), "");
        pop_papersize->addopt("note", MSG_U(M_PAPERTYPENOTE, "note"), "");
    }
    adjust_fieldlist_data(f_printername, "BitsPerPixel: ", 2, f_colordepth);
    pop_colordepth=filterwindow.newf_list(MSG_U(M_FLCOLORDEPTH, "Color depth:"), f_colordepth);
    populate_fieldlist(f_printername, "BitsPerPixel: ", pop_colordepth, 2);
    pop_printedpages=filterwindow.newf_list(MSG_U(M_FLPRINTEDPAGES, "Printed pages:"), f_printedpages);{
        pop_printedpages->addopt("1");
        pop_printedpages->addopt("2");
        pop_printedpages->addopt("4");
        pop_printedpages->addopt("8");
    }

    filterwindow.setbutinfo(MENU_USR1, MSG_U(M_SELECTFILTER, "Select filter..."), MSG_R(M_SELECTFILTER));

    filterwindow.newf_chk("", f_sendeof, MSG_U(M_SENDEOF, "Send EOF"));
    filterwindow.newf_chk("", f_correctcrlf, MSG_U(M_FIXCRLF, "Fix ladder effect (CR+LF)"));
    /* only enable this if printer is *NOT* PPA */
    if(strcmp(ps_gsdevice, "ppa"))
        filterwindow.newf_chk("", f_fastascii, MSG_U(M_FASTASCII, "Fast ASCII output"));

    filterwindow.newf_num(MSG_U(M_HORIZMARGINS, "Horizontal margins:"), f_horizmargins);
    filterwindow.newf_num(MSG_U(M_VERTMARGINS, "Vertical margins:"), f_vertmargins);
    filterwindow.newf_str(MSG_U(M_GSEXTOPTIONS, "GS extra options:"), f_extragsopt, TYPICAL_STRING_SIZE-1);
}



/* edit properties of the given printer */
/* returns true if this printer was changed (or deleted) */
int editprinter_window(int which_printer)
{
    MENU_STATUS    my_button;
    int    my_selection;

    char   maxfilsiz[TYPICAL_STRING_SIZE];
    char   supheaders;
    char   dev_selected;
    char   custom_dev[TYPICAL_STRING_SIZE];

    char   overrider_printer[500]; /* if not empty, means this printer should be used instead */
    char   dotconfig_fullpath[500];

    int    my_printer_type;

    DIALOG dia_editptr;

    /* builds .config full path for this queue */
    sprintf(dotconfig_fullpath, "%s/%s", my_printcap[which_printer].sd, DOTCONFIG_FILENAME);
    *overrider_printer='\0';
    my_button=MENU_USR1;


    /* load seconday configfiles */
    load_initialise_secondary_configfiles(which_printer);
    /* load .config, if present */
    load_dotconfig_data(dotconfig_fullpath);

    /* loop if it exits for filter_selection window, because it needs to return control to this window */
    while((my_button==MENU_USR1)||(my_button==MENU_USR2)||(my_button==MENU_USR3))
    {
    {
//        DIALOG dia_editptr;
#define myprt my_printcap[which_printer]

        dia_editptr.remove_all();

        /* determines printer type */
        my_printer_type=return_printer_type(which_printer);

        dia_editptr.newf_info(MSG_U(M_PRINTERNAME, "Printer name:"), general_printer_index[which_printer].devname);
        {
            char tempz[TYPICAL_STRING_SIZE];

            switch(my_printer_type){
            case PRT_LOCAL:
                strcpy(tempz, MSG_U(M_TYPELOCAL, "local"));
                break;
            case PRT_REMOTE:
                strcpy(tempz, MSG_U(M_TYPEREMOTE, "remote"));
                break;
            case PRT_SMBWIN:
                strcpy(tempz, MSG_U(M_TYPESMBWIN, "SMB/Windows"));
                break;
            case PRT_NETWARE:
                strcpy(tempz, MSG_U(M_TYPENETW, "Netware"));
                break;
            case PRT_DIRECT:
                strcpy(tempz, MSG_U(M_TYPEDIRECT, "Direct"));
                break;
            }
            dia_editptr.newf_info(MSG_U(M_PRINTERTYPE, "Printer type:"), tempz);
        }

        dia_editptr.newf_title(MSG_U(M_GENERALOPTS, "General options"), 1, "", MSG_R(M_GENERALOPTS));

        sprintf(maxfilsiz, "%d", myprt.mx);
        dia_editptr.newf_str(MSG_U(M_MAXFILESIZE, "Maximum file size:"), maxfilsiz, 9);
        if(myprt.sh){
            supheaders=1;
        } else {
            supheaders=0;
        }
        dia_editptr.newf_chk(MSG_U(M_SUPRESSHEADERS, "Supress headers:"), supheaders, MSG_U(M_USUALLYYES, "(usually yes)"));

        dia_editptr.newf_title(MSG_U(M_PRINTERTYPESPECIFIC, "Printertype-specific options"), 1, "", MSG_R(M_PRINTERTYPESPECIFIC));

        /* now add the printertype-specific gadgets */
        switch(my_printer_type){
        case PRT_LOCAL:
            if(!overrider_printer[0]){
                dev_selected=3;

                strcpy(custom_dev, myprt.lp);
                if(!strcmp(custom_dev, "/dev/lp0")){
                    dev_selected=0;
                    *custom_dev=0;
                }
                if(!strcmp(custom_dev, "/dev/lp1")){
                    dev_selected=1;
                    *custom_dev=0;
                }
                if(!strcmp(custom_dev, "/dev/lp2")){
                    dev_selected=2;
                    *custom_dev=0;
                }
            }
            dia_editptr.newf_radio(MSG_U(M_LOCALCONNECTEDTO, "Connected to:"), dev_selected, 0, MSG_U(M_LOCALTYPICAL, "/dev/lp0 (typical)"));
            dia_editptr.newf_radio("", dev_selected, 1, "/dev/lp1");
            dia_editptr.newf_radio("", dev_selected, 2, "/dev/lp2");
            dia_editptr.newf_radio("", dev_selected, 3, "custom:");
            dia_editptr.newf_str("", custom_dev, TYPICAL_STRING_SIZE-1);
            break;
        case PRT_REMOTE:
            dia_editptr.newf_str(MSG_U(M_REMOTEMACHINE, "Remote machine:"), myprt.rm, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_REMOTEQUEUE, "Remote queue:"), myprt.rp, TYPICAL_STRING_SIZE-1);
            break;
        case PRT_SMBWIN:
            dia_editptr.newf_str(MSG_U(M_SSMBUSER, "User:"), dc_var.user, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SSMBPASSWD, "Password:"), dc_var.password, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SSMBHOSTNAME, "Hostname:"), dc_var.hostname, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SSMBPRTNAME, "Printername:"), dc_var.printername, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SSMBHOSTIP, "Host IP (optional):"), dc_var.hostip, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SSMBWORKGP, "Workgroup:"), dc_var.workgroup, TYPICAL_STRING_SIZE-1);
            break;
        case PRT_NETWARE:
            dia_editptr.newf_str(MSG_U(M_SNCPUSER, "User:"), dc_var.user, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SNCPPASSWD, "Password:"), dc_var.password, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SNCPSERVER, "Server:"), dc_var.server, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_SNCPQUEUE, "Queue:"), dc_var.queue, TYPICAL_STRING_SIZE-1);
            break;
        case PRT_DIRECT:
            dia_editptr.newf_str(MSG_U(M_DIRECTPRINTERIP, "Printer IP:"), dc_var.printerip, TYPICAL_STRING_SIZE-1);
            dia_editptr.newf_str(MSG_U(M_DIRECTPORT, "Port:"), dc_var.port, TYPICAL_STRING_SIZE-1);
            break;
        }

        /* adds filter properties */
        /* this was originally meant to have its own window */
        editfilter_window(which_printer, dia_editptr, overrider_printer);

        /* adds 'Print test page' button */
        dia_editptr.setbutinfo(MENU_USR2, MSG_U(X_TEST, "Test"), MSG_R(X_TEST));
        /* adds 'change type' button */
        dia_editptr.setbutinfo(MENU_USR3, MSG_U(X_TYPE, "Change type"), MSG_R(X_TYPE));

        /* --- opens window --- */
        my_selection=0;
        my_button=dia_editptr.edit(MSG_U(M_PRINTERPROP, "Printer properties"), "", my_properties_helpfile, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_USR1|MENUBUT_USR2|MENUBUT_USR3);
    }

    /* if the right button was pressed, opens filter selection window */
    if(my_button==MENU_USR1){
        dia_editptr.save(); /* save contents, otherwise window will be restored to saved values on return (annoying for user) */
        select_printer_filter(overrider_printer,false);

        /* saves selected filter to file */
        if(*overrider_printer){
            new_filter_so_reset_some_things(overrider_printer);
            load_to_gui_variables();

//            dia_editptr.reload();
            write_filter_description(which_printer, overrider_printer);
            save_all_the_filters_stuff(which_printer);
            save_dotconfig_data(dotconfig_fullpath);
        }
    }

    /* test filter */
    if(my_button==MENU_USR2){
        /* picks only the first printer name (drop aliases) */
        char devname[TYPICAL_STRING_SIZE];
        char *devname_zeropoint;
        strcpy(devname, general_printer_index[which_printer].devname);
        if((devname_zeropoint=strchr(devname, '|')))
            *devname_zeropoint=0;

        DIALOG my_dialog;
        my_dialog.settype (DIATYPE_POPUP);
        MENU_STATUS my_button2=MENU_NULL;
        int         my_selection2=0;
        SSTRING command_to_send;

        my_dialog.new_menuitem("", MSG_U(X_DOCOMMTEST, "Print ascii test"));
        my_dialog.new_menuitem("", MSG_U(X_DOFILTERTEST, "Print postscript test"));
        my_dialog.new_menuitem("", MSG_U(X_STOPPRINTING, "STOP PRINTING"));

        /* opens dialog.. */
        my_selection2=0;
        my_button2=my_dialog.editmenu(MSG_U(T_PRINTERTEST, "Printer test"), MSG_U(X_PRINTERTESTEXPL, "Select \"Print\" so a testpage will be printed in order\nto check the configuration.\nIf the printer goes out of control,\nselect \"STOP PRINTING\"\n(you may also need to turn off the printer)\n"), help_nil, my_selection2, MENUBUT_QUIT);

        switch(my_button2){
        case MENU_QUIT:
        case MENU_ESCAPE:
            break;
        default:
            switch(my_selection2){
            case 0:
                /* prints test ASCII page */
                /* prints test PS page */
                /* saves the printer data (otherwise it can't be tested) */
                save_all_the_filters_stuff(which_printer);
                save_dotconfig_data(dotconfig_fullpath);
                /* forces lpd restart */
                just_executes_the_proggy("killall lpd");
                just_executes_the_proggy("lpd");
                command_to_send.setfromf("lpc start %s", devname);
                just_executes_the_proggy(command_to_send.get());

                /* sends the test data to printer */
                command_to_send.setfromf(TEST_PRINTER_COMMAND_ASCII, devname);
                just_executes_the_proggy(command_to_send.get());
				xconf_notice (MSG_U(I_DONE,"Done"));
                break;
            case 1:
                /* prints test PS page */
                /* saves the printer data (otherwise it can't be tested) */
                save_all_the_filters_stuff(which_printer);
                save_dotconfig_data(dotconfig_fullpath);
                /* forces lpd restart */
                just_executes_the_proggy("killall lpd");
                just_executes_the_proggy("lpd");
                command_to_send.setfromf("lpc start %s", devname);
                just_executes_the_proggy(command_to_send.get());

                /* sends the test data to printer */
                command_to_send.setfromf(TEST_PRINTER_COMMAND, devname);
                just_executes_the_proggy(command_to_send.get());
				xconf_notice (MSG_R(I_DONE));
                break;
            case 2:
                /* aborts printing, cleans queue and restarts lpd */
                command_to_send.setfromf("lpc abort %s", devname);
                just_executes_the_proggy(command_to_send.get());
                command_to_send.setfromf("lprm -P%s - >/dev/null", devname);
                just_executes_the_proggy(command_to_send.get());
                just_executes_the_proggy("killall lpd");
                just_executes_the_proggy("lpd");
                command_to_send.setfromf("lpc start %s", devname);
                just_executes_the_proggy(command_to_send.get());
				xconf_notice (MSG_R(I_DONE));
                break;
            default:
                break;
            }
            break;
        }
    }
    /* if "change printer type" */
    if(my_button==MENU_USR3){
        /* save contents, otherwise window will be restored to saved values on return */
        dia_editptr.save();
	/* change the printer, promprint the user for the new type */
	change_printer_type(which_printer,-1);
    }

    }


    /* save the filter properties if asked so */
    if(my_button==MENU_ACCEPT){
        save_all_the_filters_stuff(which_printer);
        save_dotconfig_data(dotconfig_fullpath);
    }

    /* converts strings to integer, chars to bools, etc */
    myprt.mx=atoi(maxfilsiz);
    myprt.sh=supheaders;
    /* now converst the printertype-specific things.. */
    switch(my_printer_type){
    case PRT_LOCAL:
        if(dev_selected==0)
            strcpy(myprt.lp, "/dev/lp0");
        if(dev_selected==1)
            strcpy(myprt.lp, "/dev/lp1");
        if(dev_selected==2)
            strcpy(myprt.lp, "/dev/lp2");
        if(dev_selected==3)
            strcpy(myprt.lp, custom_dev);
        break;
    case PRT_REMOTE:
        break;
    case PRT_SMBWIN:
        break;
    case PRT_NETWARE:
        break;
    case PRT_DIRECT:
        break;
    }

    if(my_button==MENU_DEL){
        if(confirm_yesno_window(MSG_U(M_REMOVPRTTITLE, "Removing printer"), MSG_U(M_REMOVPRTTEXT, "Confirm removing this printer?"))){
            remove_printer(which_printer);
            return(1);
        }
    }

    if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE)){
        return(0);
    }
    return(1);
}
