// vim: nowrap

#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of of general Postfix resource control options
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::ressctrlparam_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;

	// bounce_size_limit
	st = data.getvarvariable(V_BOUNCE_SIZE_LIMIT);
	int val_bounceszlim = st->getval();
	dia.newf_num (MSG_U(F_BNCSIZELIMIT,"Bounce size limit"), val_bounceszlim);
	
	// command_time_limit
	st = data.getvarvariable(V_COMMAND_TIME_LIMIT);
	int val_cmdtimlim = st->getval();
	dia.newf_num (MSG_U(F_COMMTIMELIMIT,"Command time limit"), val_cmdtimlim);
	
	// default_process_limit
	st = data.getvarvariable(V_DEFAULT_PROCESS_LIMIT);
	int val_defproclim = st->getval();
	dia.newf_num (MSG_U(F_DEFPROCCLIMIT,"Default process limit"), val_defproclim);
	
	// deliver_lock_attempts
	st = data.getvarvariable(V_DELIVER_LOCK_ATTEMPTS);
	int val_delivlockattmp = st->getval();
	dia.newf_num (MSG_U(F_DELIVLOCKATMPS,"Deliver lock attempts"), val_delivlockattmp);
	
	// deliver_lock_delay
	st = data.getvarvariable(V_DELIVER_LOCK_DELAY);
	int val_dellockdelay = st->getval();
	dia.newf_num (MSG_U(F_DELLOCKDELAY,"Deliver lock delay"), val_dellockdelay);
	
	// duplicate_filter_limit
	st = data.getvarvariable(V_DUPLICATE_FILTER_LIMIT);
	int val_dupfiltlim = st->getval();
	dia.newf_num (MSG_U(F_DUPFILTERLIMIT,"Duplicate filter limit"), val_dupfiltlim);
	
	// fork_attempts
	st = data.getvarvariable(V_FORK_ATTEMPTS);
	int val_forkattempts = st->getval();
	dia.newf_num (MSG_U(F_FORKATTEMPTS,"Fork attempts"), val_forkattempts);
	
	// fork_delay
	st = data.getvarvariable(V_FORK_DELAY);
	int val_forkdelay = st->getval();
	dia.newf_num (MSG_U(F_FORKDELAY,"Fork delay"), val_forkdelay);
	
	// header_size_limit
	st = data.getvarvariable(V_HEADER_SIZE_LIMIT);
	int val_headszlim = st->getval();
	dia.newf_num (MSG_U(F_HEADERSIZELIMIT,"Header size limit"), val_headszlim);
	
	// line_length_limit
	st = data.getvarvariable(V_LINE_LENGTH_LIMIT);
	int val_linelengthlim = st->getval();
	dia.newf_num (MSG_U(F_LINELENGLIMIT,"Line length limit"), val_linelengthlim);
	
	// message_size_limit
	st = data.getvarvariable(V_MESSAGE_SIZE_LIMIT);
	int val_msgsizelim = st->getval();
	dia.newf_num (MSG_U(F_MSGSIZELIMIT,"Message size limit"), val_msgsizelim);
	
	// qmgr_message_active_limit
	st = data.getvarvariable(V_QMGR_MESSAGE_ACTIVE_LIMIT);
	int val_qmgrmsgactlim = st->getval();
	dia.newf_num (MSG_U(F_QMGRMSGACTLIMIT,"qmgr message active limit"), val_qmgrmsgactlim);
	
	// qmgr_message_recipient_limit
	st = data.getvarvariable(V_QMGR_MESSAGE_RECIPIENT_LIMIT);
	int val_qmgrmsgrcplim = st->getval();
	dia.newf_num (MSG_U(F_QMGRMSGRECLIMIT,"qmgr message recipient limit"), val_qmgrmsgrcplim);
	
	// queue_minfree
	st = data.getvarvariable(V_QUEUE_MINFREE);
	int val_queueminfree = st->getval();
	dia.newf_num (MSG_U(F_QUEUEMINFREE,"Queue minfree"), val_queueminfree);
	
	// stale_lock_time
	st = data.getvarvariable(V_STALE_LOCK_TIME);
	int val_stalelocktim = st->getval();
	dia.newf_num (MSG_U(F_STALELOCKTIME,"Stale lock time"), val_stalelocktim);
	
	// transport_retry_time
	st = data.getvarvariable(V_TRANSPORT_RETRY_TIME);
	int val_transprettime = st->getval();
	dia.newf_num (MSG_U(F_TRANSRETTIME,"Transport retry time"), val_transprettime);

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));

	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_RESSCTRLPARAM,"Configure general parameters")
			,MSG_U(I_RESSCTRLPARAM,"Here you can configure options that control address rewriting")
			,help_postfix_ressctrlparam
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
			
			// bounce_size_limit
			data.getvarvariable(V_BOUNCE_SIZE_LIMIT)->setfrom(val_bounceszlim);

			// command_time_limit
			data.getvarvariable(V_COMMAND_TIME_LIMIT)->setfrom(val_cmdtimlim);

			// default_process_limit
			data.getvarvariable(V_DEFAULT_PROCESS_LIMIT)->setfrom(val_defproclim);
			
			// deliver_lock_attempts
			data.getvarvariable(V_DELIVER_LOCK_ATTEMPTS)->setfrom(val_delivlockattmp);
	
			// deliver_lock_delay
			data.getvarvariable(V_DELIVER_LOCK_DELAY)->setfrom(val_dellockdelay);
	
			// duplicate_filter_limit
			data.getvarvariable(V_DUPLICATE_FILTER_LIMIT)->setfrom(val_dupfiltlim);
	
			// fork_attempts
			data.getvarvariable(V_FORK_ATTEMPTS)->setfrom(val_forkattempts);
	
			// fork_delay
			data.getvarvariable(V_FORK_DELAY)->setfrom(val_forkdelay);
	
			// header_size_limit
			data.getvarvariable(V_HEADER_SIZE_LIMIT)->setfrom(val_headszlim);
	
			// line_length_limit
			data.getvarvariable(V_LINE_LENGTH_LIMIT)->setfrom(val_linelengthlim);
	
			// message_size_limit
			data.getvarvariable(V_MESSAGE_SIZE_LIMIT)->setfrom(val_msgsizelim);
	
			// qmgr_message_active_limit
			data.getvarvariable(V_QMGR_MESSAGE_ACTIVE_LIMIT)->setfrom(val_qmgrmsgactlim);
	
			// qmgr_message_recipient_limit
			data.getvarvariable(V_QMGR_MESSAGE_RECIPIENT_LIMIT)->setfrom(val_qmgrmsgrcplim);
	
			// queue_minfree
			data.getvarvariable(V_QUEUE_MINFREE)->setfrom(val_queueminfree);
	
			// stale_lock_time
			data.getvarvariable(V_STALE_LOCK_TIME)->setfrom(val_stalelocktim);
	
			// transport_retry_time
			data.getvarvariable(V_TRANSPORT_RETRY_TIME)->setfrom(val_transprettime);
			
			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_BOUNCE_SIZE_LIMIT,
						V_COMMAND_TIME_LIMIT,
						V_DEFAULT_PROCESS_LIMIT,
						V_DELIVER_LOCK_ATTEMPTS,
						V_DELIVER_LOCK_DELAY,
						V_DUPLICATE_FILTER_LIMIT,
						V_FORK_ATTEMPTS,
						V_FORK_DELAY,
						V_HEADER_SIZE_LIMIT,
						V_LINE_LENGTH_LIMIT,
						V_MESSAGE_SIZE_LIMIT,
						V_QMGR_MESSAGE_ACTIVE_LIMIT,
						V_QMGR_MESSAGE_RECIPIENT_LIMIT,
						V_QUEUE_MINFREE,
						V_STALE_LOCK_TIME,
						V_TRANSPORT_RETRY_TIME,
						-1
				};
				data.setdefaultvarvalues(values);
	
				// bounce_size_limit
				st = data.getvarvariable(V_BOUNCE_SIZE_LIMIT);
				val_bounceszlim = st->getval();
				
				// command_time_limit
				st = data.getvarvariable(V_COMMAND_TIME_LIMIT);
				val_cmdtimlim = st->getval();
				
				// default_process_limit
				st = data.getvarvariable(V_DEFAULT_PROCESS_LIMIT);
				val_defproclim = st->getval();
				
				// deliver_lock_attempts
				st = data.getvarvariable(V_DELIVER_LOCK_ATTEMPTS);
				val_delivlockattmp = st->getval();
				
				// deliver_lock_delay
				st = data.getvarvariable(V_DELIVER_LOCK_DELAY);
				val_dellockdelay = st->getval();
				
				// duplicate_filter_limit
				st = data.getvarvariable(V_DUPLICATE_FILTER_LIMIT);
				val_dupfiltlim = st->getval();
				
				// fork_attempts
				st = data.getvarvariable(V_FORK_ATTEMPTS);
				val_forkattempts = st->getval();
				
				// fork_delay
				st = data.getvarvariable(V_FORK_DELAY);
				val_forkdelay = st->getval();
				
				// header_size_limit
				st = data.getvarvariable(V_HEADER_SIZE_LIMIT);
				val_headszlim = st->getval();
				
				// line_length_limit
				st = data.getvarvariable(V_LINE_LENGTH_LIMIT);
				val_linelengthlim = st->getval();
				
				// message_size_limit
				st = data.getvarvariable(V_MESSAGE_SIZE_LIMIT);
				val_msgsizelim = st->getval();
				
				// qmgr_message_active_limit
				st = data.getvarvariable(V_QMGR_MESSAGE_ACTIVE_LIMIT);
				val_qmgrmsgactlim = st->getval();
				
				// qmgr_message_recipient_limit
				st = data.getvarvariable(V_QMGR_MESSAGE_RECIPIENT_LIMIT);
				val_qmgrmsgrcplim = st->getval();
				
				// queue_minfree
				st = data.getvarvariable(V_QUEUE_MINFREE);
				val_queueminfree = st->getval();
				
				// stale_lock_time
				st = data.getvarvariable(V_STALE_LOCK_TIME);
				val_stalelocktim = st->getval();
				
				// transport_retry_time
				st = data.getvarvariable(V_TRANSPORT_RETRY_TIME);
				val_transprettime = st->getval();
				
				dia.reload();
			}
		}
	}
	return ret;
}
