// vim: nowrap
#pragma implementation
#include "postfixconf.h"
#include "postfixconf.m"

/*
DESCRIPTION: This DIALOG contains settings of Postfix configuration parameters that to do address masquerading
RETURN: 0 - case the user accept the changes
        1 - case the user cancel the changes
*/
PUBLIC int MODULE_postfixconf::addressmasq_edit(DATAMAIN &data){
	int ret = 0;
	int nof = 0;
	DIALOG dia;
	SSTRING *st;
	
	// allow_percent_hack
	st = data.getvarvariable(V_ALLOW_PERCENT_HACK);
	char var_phack = getvalue_yesno (st);
	const char *opt_phack[] = {MSG_U(X_YES,"yes"),MSG_U(X_NO,"no"),NULL};
	dia.newf_chkm (MSG_U(F_ALLOWPERCHACK,"Allow percent hack"),var_phack,(const char**)opt_phack);

	// append_at_myorigin
	st = data.getvarvariable(V_APPEND_AT_MYORIGIN);
	char var_apatmyorg = getvalue_yesno (st);
	const char *opt_apatmyorg[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_APPENDATMYORIGIN,"Append at origin"),var_apatmyorg,opt_apatmyorg);
	
	// append_dot_mydomain
	st = data.getvarvariable(V_APPEND_DOT_MYDOMAIN);
	char var_apdtmydom = getvalue_yesno (st);
	const char *opt_apdtmydom[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_APPENDDOTDOMAIN,"Append dot domain"),var_apdtmydom,opt_apdtmydom);
	
	// empty_address_recipient
	dia.newf_str(MSG_U(F_EMPTYADRSREC,"Empty address recipient"),*(data.getvarvariable(V_EMPTY_ADDRESS_RECIPIENT)));
	
	// masquerade_domains
	dia.newf_str(MSG_U(F_MASQDOMAINS,"Masquerade domains"),*(data.getvarvariable(V_MASQUERADE_DOMAINS)));
	
	// masquerade_exceptions
	dia.newf_str(MSG_U(F_MASQEXCEPTIONS,"Masquerade exceptions"),*(data.getvarvariable(V_MASQUERADE_EXCEPTIONS)));

	// swap_bangpath
	st = data.getvarvariable(V_SWAP_BANGPATH);
	char var_swpbgpath = getvalue_yesno (st);
	const char *opt_swpbgpath[] = {MSG_R(X_YES),MSG_R(X_NO),NULL};
	dia.newf_chkm (MSG_U(F_SWPBANGPATH,"Swap bangpath"),var_swpbgpath,opt_swpbgpath);

	dia.setbutinfo (MENU_USR1, MSG_R(B_SETTODEFAULT), MSG_R(B_SETTODEFAULT));
	
	while (1){
		MENU_STATUS code = dia.edit(
			MSG_U(T_ADDRESSMASQ,"Configure address masquerading")
			,MSG_U(I_ADDRESSMASQ,"Here you can configure options that control address rewriting")
			,help_postfix_addressmasq
			,nof
			,MENUBUT_CANCEL|MENUBUT_ACCEPT|MENUBUT_USR1);	
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ACCEPT){
			// validations
			
			// allow_percent_hack
			setvalue_yesno (data.getvarvariable(V_ALLOW_PERCENT_HACK), var_phack);
			
			// append_at_myorigin
			setvalue_yesno (data.getvarvariable(V_APPEND_AT_MYORIGIN), var_apatmyorg);
			
			// append_dot_mydomain
			setvalue_yesno (data.getvarvariable(V_APPEND_DOT_MYDOMAIN), var_apdtmydom);

			// swap_bangpath
			setvalue_yesno (data.getvarvariable(V_SWAP_BANGPATH), var_swpbgpath);
			
			ret = 1;
			break;
		}else if (code == MENU_USR1){
			if ( dialog_yesno(MSG_R(T_RESTORETODEFAULT)
					 ,MSG_R(N_RESTORETODEFAULT)
					 ,help_postfix_basic) == MENU_YES ){
				int values[]={
						V_ALLOW_PERCENT_HACK,
						V_APPEND_AT_MYORIGIN,
						V_APPEND_DOT_MYDOMAIN,
						V_EMPTY_ADDRESS_RECIPIENT,
						V_MASQUERADE_DOMAINS,
						V_MASQUERADE_EXCEPTIONS,
						V_SWAP_BANGPATH,
						-1
				};
				data.setdefaultvarvalues(values);
				// allow_percent_hack
				st = data.getvarvariable(V_ALLOW_PERCENT_HACK);
				var_phack = getvalue_yesno (st);

				// append_at_myorigin
				st = data.getvarvariable(V_APPEND_AT_MYORIGIN);
				var_apatmyorg = getvalue_yesno (st);
				
				// append_dot_mydomain
				st = data.getvarvariable(V_APPEND_DOT_MYDOMAIN);
				var_apdtmydom = getvalue_yesno (st);
				
				// swap_bangpath
				st = data.getvarvariable(V_SWAP_BANGPATH);
				var_swpbgpath = getvalue_yesno (st);
	
				dia.reload();
			}
		}
	}
	return ret;
}
