
/*
 Mouseconf v1.1 (13 dec, 2000)
 by Daniel Mealha Cabrita (dancab@conectiva.com)

 the best thing for your rodent!

 This module needs the following to compile:
 - XF86 v4 (if absent it will not have support for XF86)
 - Kudzu (if absent it will not have support for kudzu)

 And needs the following to run:
 - Kudzu (if compiled in a kudzu system)
 - GPM
 - XF86 is optional, even is compiled with
   *BUT* if XF86 is installed it must be v4 otherwise
   the module will act as if there was no XF86 installed.

 - 1.0 (released on LC 1.23 but disabled)
   first version released.
 - 1.1
   - detects if kudzu is available and compiles accordingly
   - detects if XFree86 is available and compiles accordingly
   - verifies if XFree86 is v4 or not (only works under XF86)

 */

#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "mouseconf.h"
#include "mouseconf.m"
#include "mouseconf_main.cc"

MODULE_DEFINE_VERSION(mouseconf);

PUBLIC MODULE_mouseconf::MODULE_mouseconf()
	: LINUXCONF_MODULE("mouseconf")
{
	linuxconf_loadmsg ("mouseconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_mouseconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_HARDWARE){
		keymenu = MSG_U(M_mouseconf,"Mouse configuration");
		dia.new_menuitem ("mouseconf","",keymenu);
	}
}

static void mouseconf_start()
{
	if (perm_rootaccess (MSG_U(P_CONFIGMOUSE,"to configure the mouse"))){
		start_things();
	}
}

PUBLIC int MODULE_mouseconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_HARDWARE){
		if (key == keymenu){
			mouseconf_start();
		}
	}
	return 0;
}


PUBLIC int MODULE_mouseconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"mouseconf")==0){
		// ### Insert any menu and dialog here
            ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain mouseconf usage\n"
		 "\n"
		 "    mouseconf --option ...\n")
		);
}

PUBLIC void MODULE_mouseconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_mouseconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"mouseconf")==0){
		ret = -1;
		if (argc == 1){
			mouseconf_start();
		}else{
			::usage();
		}
	}
	return ret;
}


static MODULE_mouseconf mouseconf;

