/*
	This API allows linuxconf to show and control all services
	in a single dialog. See netconf/start.cc
*/
#ifndef SERVICECTL_API_H
#define SERVICECTL_API_H

#include <module_api.h>
#include <module_apis/servicectl_apidef.h>
static const char SERVICECTL_API_KEY[]="servicectl";
static const int  SERVICECTL_API_REV=2;

inline int servicectl_apis_init(
	const char *client,
	SERVICECTL_API *tb[])
{
	return module_get_apis (SERVICECTL_API_KEY,SERVICECTL_API_REV
		,client,(void*[])tb);
}

inline void servicectl_apis_end(SERVICECTL_API *apis[], int nbapis)
{
	module_release_apis (SERVICECTL_API_KEY,(void*[])apis,nbapis);
}

inline bool servicectl_api_available(const char *client)
{
	return module_api_available (SERVICECTL_API_KEY,SERVICECTL_API_REV,client);
}


#endif




