#pragma implementation
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "ircdconf.h"
#include "ircdconf.m"

PUBLIC void dia_users(SSTRINGS *tb)
{
    DIALOG_MENU dia;
    MENU_STATUS menu;
    int opt=0;
    dia.new_menuitem("", MSG_U(M_UKLNS,"Kill Lines"));
    dia.new_menuitem("", MSG_U(M_UILNS,"Permissions"));
    while(1)
    {
        menu = dia.editmenu(MSG_R(M_USERS),MSG_U(I_UDESC,"Users Configuration,\ncontrols users restrictions"),help_main,opt,0);
        if(menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else {
            switch(opt)
            {
            case 0:
                dia_uklns(tb);
                break;
            case 1:
                dia_uilns(tb);
                break;
            }
        }
    }
}

PUBLIC void dia_uilns(SSTRINGS *tb)
{
    DIALOG_RECORDS dia;
    int opt=-1;

    dia.newf_head("", MSG_U(I_IHEAD, "IP mask or Crap\tPass\tHostmask\tClass"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Ii", tb);
        int tb_size = temp_tb->getnb();
        for(int x=0;x<tb_size;x++)
        {
            char line[256];
            sprintf(line, "%s\t%s\t%s", get_opt(temp_tb,x,2), get_opt(temp_tb,x,3), get_opt(temp_tb,x,5));
            dia.set_menuitem(x, get_opt(temp_tb, x, 1), line);
        }
        dia.remove_last(tb_size + 1);
//        int opt=-1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_UILNS), MSG_U(I_ILDES, "Allow users to conect on your server"), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        if(menu == MENU_ADD)
            opt = -1;
        if ( menu == MENU_ESCAPE || menu == MENU_QUIT )
            break;
        else if ( menu == MENU_OK || menu == MENU_ADD )
        {
            DIALOG dia_add;
            int nof=0;
            SSTRING ipcrab, host, pass, cl, *temp;
            if(opt == -1)
            {
                temp = new SSTRING();
            }
            else
            {
                temp = temp_tb->getitem(opt);
                ipcrab.append(get_opt(temp_tb, opt, 1));
                host.append(get_opt(temp_tb, opt, 3));
                pass.append(get_opt(temp_tb, opt, 2));
                cl.append(get_opt(temp_tb, opt, 5));
            }
            dia_add.newf_str(MSG_U(F_ULIC,"IP mask or Crap"), ipcrab);
            dia_add.newf_str(MSG_U(F_ULHM,"HostMask"), host);
            dia_add.newf_info(MSG_U(F_ULPW1,"Password: (opt)"), MSG_U(I_ULPW2,"Number of connections by the same IP"));
            FIELD_LIST *pass_list = dia_add.newf_list("", pass);
            pass_list->addopt("","");
            for(int x=1;x<10;x++)
            {
                char ch[2];
                sprintf(ch, "%d", x);
                pass_list->addopt(ch,"");
            }
            const char *classes[] = { "", "1", "2", "10", "50", "70", "80", "90" };
            FIELD_LIST *classlist = dia_add.newf_list(MSG_U(F_ULCC,"Class"), cl);
            for(int x=0;x<8;x++)
                classlist->addopt(classes[x],"");
            while (1){
                bool save = 0;
                MENU_STATUS code = dia_add.edit(MSG_U(M_UILNS_EDIT, "Edit/Add permissions"), MSG_R(I_ILDES), help_main, nof, MENUBUT_DEL|MENUBUT_ACCEPT|MENUBUT_CANCEL);
                if (code == MENU_CANCEL || code == MENU_ESCAPE){
                    break;
                }else if (code == MENU_DEL){
                    if(opt != -1){
                        temp_tb->remove_del(temp);
                        save = 1;
                    }
                }else if (code == MENU_ACCEPT){
                    if (verify_str(ipcrab, host)){
                        temp->setfromf("I:%s:%s:%s::%s", ipcrab.get(), pass.get(), host.get(), cl.get());
                        if(opt == -1)
                            temp_tb->add(temp);
                        save = 1;
                    }
                }
                if(save){
                    if (!cfg_compare(temp_tb, cat_opts("Ii", tb)))
                        change_opts("Ii", tb, temp_tb);
                    if(!cfg_compare(tb, &cfg_old))
                        savecfg(tb);
                    break;
                }
            }
        }
    }
}


PUBLIC void dia_uklns(SSTRINGS *tb)
{
    DIALOG_RECORDS dia;
    int opt=-1;

    dia.newf_head("", MSG_U(I_KHEAD, "host/IP hostmask\tusermask\tIP based"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Kk", tb);
        int size_tb = temp_tb->getnb();
        for(int x=0;x<size_tb;x++)
        {
            char line[256];
            if(strchr(get_opt(temp_tb, x, 0), 'K') != NULL)
            {
                const char *ipb = MSG_U(F_IRCNO,"No");
                sprintf(line, "%s\t%s", get_opt(temp_tb,x,3),ipb);
            }
            else
            {
                const char *ipb = MSG_U(F_IRCYES,"Yes");
                sprintf(line, "%s\t%s", get_opt(temp_tb,x,3),ipb);
            }
            dia.set_menuitem(x, get_opt(temp_tb, x, 1), line);
        }
        dia.remove_last(size_tb + 1);
//        int opt=-1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_UKLNS), MSG_U(I_UKDES, "Here you can kill people from your server"), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        if(menu == MENU_ADD)
            opt=-1;
        if ( menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else if (menu == MENU_OK || menu == MENU_ADD )
        {
            DIALOG dia_add;
            SSTRING host, umask, msg;
            char ipb;
            SSTRING *temp;
            if(opt == -1)
            {
                temp = new SSTRING();
            }
            else
            {
                temp = temp_tb->getitem(opt);
                host.append(get_opt(temp_tb, opt, 1));
                umask.append(get_opt(temp_tb, opt, 3));
                msg.append(get_opt(temp_tb, opt, 2));
                if(strchr(get_opt(temp_tb, opt, 0), 'K') != NULL)
                    ipb = 0;
                else
                    ipb = 1;
            }
            dia_add.newf_str(MSG_U(F_UKLHM,"Host/IP Mask"), host);
            dia_add.newf_str(MSG_U(F_UKLUM,"Usermask"), umask);
            dia_add.newf_chk("", ipb, MSG_U(F_UKLIP,"IP based"));
            dia_add.newf_info(MSG_U(F_UKLMSG,"KLine message:"), MSG_U(I_UKMSG,"The format MUST be !<path to file> or \"<message>\""));
            dia_add.newf_str("", msg);
            int nof=0;
            menu = dia_add.edit(MSG_U(M_UKLNS_EDIT, "Edit/Add Kill Line"), MSG_R(I_UKDES), help_main, nof, MENUBUT_DEL|MENUBUT_ACCEPT|MENUBUT_CANCEL);
            if(menu == MENU_ACCEPT && verify_str(host, umask, msg))
            {
                if(ipb == 0)
                    temp->setfromf("K:%s:%s:%s", host.get(), msg.get(), umask.get());
                else
                    temp->setfromf("k:%s:%s:%s", host.get(), msg.get(), umask.get());
                if(opt == -1)
                    temp_tb->add(temp);
            }
            else if(menu == MENU_DEL)
            {
                if(opt != -1)
                    temp_tb->remove_del(temp);
            }
            if (!cfg_compare(temp_tb, cat_opts("Kk", tb)))
                change_opts("Kk", tb, temp_tb);
            if(!cfg_compare(tb, &cfg_old))
                savecfg(tb);
        }
    }
}
