#pragma implementation
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "ircdconf.h"
#include "ircdconf.m"

PUBLIC void dia_server(SSTRINGS *tb)
{
    DIALOG_MENU dia;
    MENU_STATUS menu;
    int opt=0;
    dia.new_menuitem("", MSG_U(M_SINFO,"Information"));
    dia.new_menuitem("", MSG_U(M_SOPER,"Operators"));
    dia.new_menuitem("", MSG_U(M_SRNICK,"Reserved Nicknames"));
    dia.new_menuitem("", MSG_U(M_SPRTS,"Server Ports"));
    dia.new_menuitem("", MSG_U(M_SMOTD,"MOTD Control"));
    while(1)
    {
        menu = dia.editmenu(MSG_R(M_SERVER),MSG_U(M_SDESC,"Server Configuration, controls\nthe restrictions and general\ninformation about the server."),help_main,opt,0);
        if(menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else {
            switch(opt)
            {
            case 0:
                dia_sinfo(tb);
                break;
            case 1:
                dia_soper(tb);
                break;
            case 2:
                dia_srnick(tb);
                break;
            case 3:
                dia_sprts(tb);
                break;
            case 4:
                dia_smotd(tb);
                break;
            }
        }

    }
}

PUBLIC void dia_soper(SSTRINGS *tb)
{
    DIALOG_LISTE dia;
    int opt = -1;

    dia.newf_head("", MSG_U(I_OHEAD, "Nickname\thost/IP mask\tAccess\tClass"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Oo", tb);
        int size_tb = temp_tb->getnb();
        for(int x=0;x<size_tb;x++){
            char line[256];
            if(strchr(get_opt(temp_tb, x, 0), 'O') != NULL)
            {
                const char *global = MSG_U(F_IRCGLOBAL,"Global");
                sprintf(line, "%s\t%s\t%s", get_opt(temp_tb,x,1), global, get_opt(temp_tb,x,5));
            }
            else
            {
                const char *local = MSG_U(F_IRCLOCAL,"Local");
                sprintf(line, "%s\t%s\t%s", get_opt(temp_tb,x,1), local, get_opt(temp_tb,x,5));
            }
            dia.set_menuitem(x, get_opt(temp_tb, x, 3), line);
        }
        dia.remove_last(size_tb + 1);
//        int opt = -1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_SOPER), MSG_U(I_ODES, "Change operators settings."), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        if(menu == MENU_ADD)
            opt = -1;
        if(menu == MENU_ESCAPE || menu == MENU_QUIT){
            break;
        }else if(menu == MENU_OK || menu == MENU_ADD){
            SSTRING host, pass, passcon, nick, cclass, passtemp, *temp;
            FIELD_LIST *classlist;
            char global = 0;
            DIALOG dia_add;
            if (opt == -1){
                temp = new SSTRING();
            }else{
                temp = temp_tb->getitem(opt);
                host.append(get_opt(temp_tb, opt, 1));
                nick.append(get_opt(temp_tb, opt, 3));
                passtemp.append(get_opt(temp_tb, opt, 2));
                cclass.append(get_opt(temp_tb, opt, 5));
                if(strchr(get_opt(temp_tb, opt, 0), 'O') != NULL)
                    global = 1;
                else
                    global = 0;
            }
            dia_add.newf_str(MSG_U(F_ONICK,"Nickname"), nick);
            dia_add.newf_str(MSG_U(F_OHOST,"Host/IP mask"), host);
            dia_add.newf_pass(MSG_U(F_OPASS,"Password"), pass);
            dia_add.newf_pass(MSG_U(F_OPSCN,"Confirmation"), passcon);
            classlist = dia_add.newf_list(MSG_U(F_SOCC,"Class"), cclass);
            const char *classes[] = { "", "1", "2", "10" };
            for(int x=0;x<4;x++)
                classlist->addopt(classes[x],"");
            dia_add.newf_chk("", global, MSG_U(F_SOGLOB,"Global Operator"));
            int nof = 0;
            while(1){
                MENU_STATUS menu_add = dia_add.edit(MSG_U(M_SOPER_EDIT, "Edit/Add an operator"), "", help_main, nof, MENUBUT_DEL|MENUBUT_ACCEPT|MENUBUT_CANCEL);
                if( menu_add == MENU_ESCAPE || menu_add == MENU_QUIT || menu_add == MENU_CANCEL){
                    break;
                }else if(menu_add == MENU_ACCEPT){
                    if(verify_str(nick, host)){
                        if (strcmp(pass.get(),"") != 0 )
                            passtemp.setfrom(pass.get());
                        if (global == 1)
                            temp->setfromf("O:%s:%s:%s::%s", host.get(), crypt(passtemp.get(),"r1"), nick.get(), cclass.get());
                        else
                            temp->setfromf("o:%s:%s:%s::%s", host.get(), crypt(passtemp.get(),"r1"), nick.get(), cclass.get());
                        if (opt == -1)
                            temp_tb->add(temp);
                        break;
                    }
                }else if(menu_add == MENU_DEL){
                    if (opt != -1)
                        temp_tb->remove_del(temp);
                    break;
                }
            }
            if (!cfg_compare(temp_tb, cat_opts("Oo", tb)))
                change_opts("Oo", tb, temp_tb);
            if(!cfg_compare(tb, &cfg_old))
                savecfg(tb);
        }
    }
}

PUBLIC void dia_srnick(SSTRINGS *tb)
{
    DIALOG_LISTE dia;
    int opt = -1;

    dia.newf_head("", MSG_U(I_SNHEAD, "host/IP mask\tNicknames"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Uu", tb);
        int size_tb = temp_tb->getnb();
        for(int x=0;x<size_tb;x++)
            dia.set_menuitem(x, get_opt(temp_tb, x, 1), get_opt(temp_tb, x, 2));
        dia.remove_last(size_tb + 1);
//        int opt = -1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_SRNICK), MSG_U(I_RNDES, "Only these servers are alowed to use these nicknames."), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        if(menu == MENU_ADD)
            opt = -1;
        if(menu == MENU_ESCAPE || menu == MENU_QUIT){
            break;
        }else if(menu == MENU_OK || menu == MENU_ADD){
            SSTRING server, nicks, *temp;
            DIALOG dia_add;
            if (opt == -1){
                temp = new SSTRING();
            }else{
                temp = temp_tb->getitem(opt);
                server.setfrom(get_opt(temp_tb, opt, 1));
                nicks.setfrom(get_opt(temp_tb, opt, 2));
            }
            dia_add.newf_str(MSG_U(F_RNSERV,"Server name"), server);
            dia_add.newf_str(MSG_U(F_RNNICK,"Nicknames"), nicks);
            int nof = 0;
            while(1){
                MENU_STATUS menu_add = dia_add.edit(MSG_U(M_SRNICK_EDIT, "Edit/Add reserved nicknames"), MSG_U(I_SRNDES,"Insert the nicknames saparated by comma."), help_main, nof, MENUBUT_DEL | MENUBUT_ACCEPT | MENUBUT_CANCEL);
                if( menu_add == MENU_ESCAPE || menu_add == MENU_QUIT || menu_add == MENU_CANCEL){
                    break;
                }else if(menu_add == MENU_ACCEPT){
                    if(verify_str(server, nicks)){
                        temp->setfromf("U:%s:%s", server.get(), nicks.get());
                        if (opt == -1)
                            temp_tb->add(temp);
                        break;
                    }
                }else if(menu_add == MENU_DEL){
                    if (opt != -1)
                        temp_tb->remove_del(temp);
                    break;
                }
            }
            if (!cfg_compare(temp_tb, cat_opts("Uu", tb)))
                change_opts("Uu", tb, temp_tb);
            if(!cfg_compare(tb, &cfg_old))
                savecfg(tb);
        }
    }
}

PUBLIC void dia_sinfo(SSTRINGS *tb)
{
    DIALOG dia;
    MENU_STATUS menu;
    SSTRINGS *temp_tb = cat_opts("MmAa", tb);
    SSTRING server, sdesc, adm1, adm2, adm3;
    int snb=0;
    char leaf=0;
    if(cat_opts("Mm", temp_tb)->getnb() != 0)
    {
        server.append(get_opt(cat_opts("Mm", temp_tb), 0, 1));
        sdesc.append(get_opt(cat_opts("Mm", temp_tb), 0, 3));
        snb = atoi(get_opt(cat_opts("Mm", temp_tb), 0, 5));
    }
    SSTRINGS *d_tb = cat_opts("d", tb);
    int x;
    for(x=0;x<d_tb->getnb();x++)
        if(strcmp(d_tb->getitem(x)->get(), "d:*::directcon(*)") == 0)
            leaf = 1;
    if(cat_opts("Aa", temp_tb)->getnb() != 0)
    {
        adm1.append(get_opt(cat_opts("Aa", temp_tb), 0, 1));
        adm2.append(get_opt(cat_opts("Aa", temp_tb), 0, 2));
        adm3.append(get_opt(cat_opts("Aa", temp_tb), 0, 3));
    }
    dia.newf_str(MSG_U(F_SINAME,"Server name"), server);
    dia.newf_str(MSG_U(F_SIDES,"Server Description"), sdesc);
    dia.newf_num(MSG_U(F_SINUM,"Server Number"), snb);
    dia.newf_chk("", leaf, MSG_U(F_SILEAF,"Leaf Server"));
    dia.newf_info("", MSG_U(I_ADMINFO,"Admnistrative Info"));
    dia.newf_str(MSG_U(F_SIL1,"Line 1"), adm1);
    dia.newf_str(MSG_U(F_SIL2,"Line 2"), adm2);
    dia.newf_str(MSG_U(F_SIL3,"Line 3"), adm3);
    int nof=0;
    menu = dia.edit(MSG_R(M_SINFO), MSG_U(I_SIDES, "General and administrative information."), help_main, nof, MENUBUT_ACCEPT|MENUBUT_CANCEL);
    if(menu == MENU_ACCEPT && verify_str(server, sdesc, adm1, adm2, adm3))
    {
        temp_tb->remove_all();
        char line[256];
        sprintf(line, "M:%s:*:%s:0:%d", server.get(), sdesc.get(), snb);
        temp_tb->add(new SSTRING(line));
        sprintf(line, "A:%s:%s:%s", adm1.get(), adm2.get(), adm3.get());
        temp_tb->add(new SSTRING(line));
        for(x=0;x<d_tb->getnb();x++)
            if(strcmp(d_tb->getitem(x)->get(), "d:*::directcon(*)") == 0)
                d_tb->remove_del(x);
        if (leaf == 1)
            d_tb->add(new SSTRING("d:*::directcon(*)"));
        if (!cfg_compare(temp_tb, cat_opts("MmAa", tb)))
            change_opts("MmAa", tb, temp_tb);
        if (!cfg_compare(d_tb, cat_opts("d", tb)))
            change_opts("d", tb, d_tb);
        if(!cfg_compare(tb, &cfg_old))
            savecfg(tb);
    }
}

static CONFIG_FILE def_motd("/etc/ircd/ircd.motd", help_nil, CONFIGF_OPTIONAL|CONFIGF_GENERATED, "ircdconf");

PUBLIC void dia_smotd(SSTRINGS *tb)
{
    DIALOG_RECORDS dia;
    int opt=-1;

    dia.newf_head("", MSG_U(I_SMHEAD, "host/IP mask\tMOTD file path"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Tt", tb);
        dia.set_menuitem(0, MSG_U(F_DEFAULT, "Default"), def_motd.getpath());
        int tb_size=temp_tb->getnb();
        for(int x=1;x<tb_size+1;x++)
            dia.set_menuitem(x, get_opt(temp_tb, x-1, 1), get_opt(temp_tb, x-1, 2));
        dia.remove_last(tb_size + 2);
//        int opt=-1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_SMOTD), MSG_U(I_MDDES, "Here you can set a personal\nMessage Of The Day for special users."), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        if(menu == MENU_ADD)
            opt = -1;
        if ( menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else if ( menu == MENU_OK || menu == MENU_ADD )
        {
            DIALOG dia_add;
            int nof=0;
            SSTRING host, motd, path;
            SSTRING *temp = new SSTRING();
            if(opt != -1)
            {
                free(temp);
                if(opt != 0)
                {
                    temp = temp_tb->getitem(opt-1);
                    host.append(get_opt(temp_tb, opt-1, 1));
                    path.append(get_opt(temp_tb, opt-1, 2));
                    struct stat my_stat;
                    if(lstat(path.get(), &my_stat) == 0)
                        motd.append(open_file(path.get()).get());
                }
                else
                {
                    path.append(def_motd.getpath());
                    struct stat my_stat;
                    if(lstat(def_motd.getpath(), &my_stat) == 0)
                        motd.append(open_file(def_motd.getpath()).get());
                }
            }
            if(opt == -1)
            {
                dia_add.newf_str(MSG_U(F_MOTDHOST,"host/IP mask"), host);
            }
            dia_add.newf_textarea(MSG_U(F_MOTDFILE,"MOTD"), motd, 40, 5);
            dia_add.setbutinfo(MENU_USR1, "OK", "OK");
            if(opt != 0 )
                menu = dia_add.edit(MSG_U(M_SMOTD_EDIT, "Edit/Add MOTD"), path.get(), help_main, nof, MENUBUT_DEL|MENUBUT_ACCEPT|MENUBUT_CANCEL);
            else
                menu = dia_add.edit(MSG_U(M_SMOTD_EDIT_DEF, "Editing default MOTD"), path.get(), help_main, nof, MENUBUT_CANCEL|MENUBUT_USR1);
            if((menu == MENU_ACCEPT || menu == MENU_USR1) && verify_str(host))
            {
                dia_add.save();
                if(opt == -1)
                {
                    path.setfromf("%s/%s.motd", CONFDIR, host.get());
                    temp->setfromf("T:%s:%s", host.get(), path.get());
                    temp_tb->add(temp);
                }
                struct stat my_stat;
                char dir[256];
                sprintf(dir, "%s/.", CONFDIR);
                if(lstat(dir, &my_stat) == 0)
                    close_file(path.get(), motd);
            }
            else if(menu == MENU_DEL && opt != 0 && opt != -1)
            {
                temp_tb->remove_del(temp);
                unlink(path.get());
            }
            if(!cfg_compare(temp_tb, cat_opts("Tt", tb)))
                change_opts("Tt", tb, temp_tb);
            if(!cfg_compare(tb, &cfg_old))
                savecfg(tb);
        }
    }
}

PUBLIC void dia_sprts(SSTRINGS *tb)
{
    DIALOG_RECORDS dia;
    int opt=-1;

    dia.newf_head("", MSG_U(I_UHEAD, "Port\tHostmask\tUser\t"));
    while(1)
    {
        SSTRINGS *temp_tb = cat_opts("Pp", tb);
        int tb_size = temp_tb->getnb();
        for(int x=0;x<tb_size;x++)
        {
            char *puser = "";
            char *hidden = "";
            if(get_opt(temp_tb, x, 3) != NULL)
            {
                if(get_opt(temp_tb, x, 3)[0] == 'C')
                    puser = "Client";
                else if( get_opt(temp_tb, x, 3)[0] == 'S')
                    puser = "Server";
                if(get_opt(temp_tb, x, 3)[1] == 'H')
                    hidden = "Hidden";
            }
            char line[256];
            sprintf(line, "%s\t%s\t%s", get_opt(temp_tb, x, 1), puser, hidden);
            dia.set_menuitem(x, get_opt(temp_tb, x, 4), line);
        }
        dia.remove_last(tb_size+1);
//        int opt=-1;
        MENU_STATUS menu = dia.editmenu(MSG_R(M_SPRTS), MSG_U(I_UPDES, "Set the ports where\nusers can connect to."), help_main, opt, MENUBUT_ADD|MENUBUT_QUIT);
        if(menu == MENU_ADD)
            opt = -1;
        switch(menu)
        {
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
        case MENU_OK:
            dia_sprts_edit(tb, opt);
            break;
        default:
            break;
        }
    }
}

PUBLIC void dia_sprts_edit(SSTRINGS *tb, int opt)
{
    DIALOG dia;
    SSTRINGS *temp_tb = cat_opts("Pp", tb);
    SSTRING host, *temp, user;
    int nof=0, port=0;
    char hidden=0;
    if(opt == -1)
        temp = new SSTRING();
    else
    {
        if(get_opt(temp_tb, opt, 3) != NULL)
        {
            if(get_opt(temp_tb, opt, 3)[0] == 'C')
                user.setfrom("C");
            else if( get_opt(temp_tb, opt, 3)[0] == 'S')
                user.setfrom("S");
            if(get_opt(temp_tb, opt, 3)[1] == 'H')
                hidden=1;
        }
        temp = temp_tb->getitem(opt);
        host.append(get_opt(temp_tb, opt, 1));
        port = atoi(get_opt(temp_tb, opt, 4));
    }
    dia.newf_str(MSG_U(F_SPHM,"HostMask (opt)"), host);
    dia.newf_num(MSG_U(F_SPPT,"Port"), port);
    FIELD_LIST *user_list = dia.newf_list(MSG_U(F_SP,"Port User"), user);
    user_list->addopt("", "<none>","");
    user_list->addopt("C","Client","");
    user_list->addopt("S","Server","");
    dia.newf_chk("", hidden, MSG_U(F_SPHID,"Hidden"));
    MENU_STATUS menu = dia.edit(MSG_U(M_SPRTS_EDIT, "Edit/Add Ports"), MSG_U(I_UPRDS, "Live hostmask empty to allow\neverybody to access this port."), help_main, nof, MENUBUT_DEL|MENUBUT_ACCEPT|MENUBUT_CANCEL);
    switch(menu)
    {
    case MENU_ACCEPT:
        if(verify_str(host))
        {
            if (hidden)
                temp->setfromf("P:%s::%sH:%d", host.get(), user.get(), port);
            else
                temp->setfromf("P:%s::%s:%d", host.get(), user.get(), port);
            if(opt == -1)
                temp_tb->add(temp);
        }
        break;
    case MENU_DEL:
        if(opt != -1)
            temp_tb->remove_del(temp);
        break;
    default:
        return;
    }
    if(!cfg_compare(temp_tb, cat_opts("Pp", tb)))
        change_opts("Pp", tb, temp_tb);
    if(!cfg_compare(tb, &cfg_old))
        savecfg(tb);
}
