#pragma implementation
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <translat.h>
#include "ircdconf.h"
#include "ircdconf.m"

#define CONFDIR "/etc/ircd"

PUBLIC char *line1 = "# This config file was created by linuxconf #";
PUBLIC char *line2 = "####################################################";
PUBLIC char *line3 = "# The lines below were not recognized by linuxconf #";
PUBLIC char *line4 = "####################################################";

static CONFIG_FILE cfg_file("/etc/ircd/ircd.conf", help_nil, CONFIGF_OPTIONAL|CONFIGF_GENERATED, "ircdconf");

static HELP_FILE help_main("ircdconf", "ircdconf");

PUBLIC SSTRINGS cfg_old;

PRIVATE SSTRINGS trash;

PUBLIC SSTRINGS* opencfg()
{
    SSTRINGS *tb = new SSTRINGS();
    FILE_CFG *file = cfg_file.fopen("r");
    if(file != NULL)
    {
        char opts[] = "MmAaYyIiTtCcNnLlHhUuKkOoDdPp";
        char ch = '\n';
        char ch1;
        trash.remove_all();
        while(!feof(file))
        {
            if (ch == '\n')
            {
                ch1 = ch = fgetc(file);
                SSTRING temp;
                if(ch!='\n'&&!feof(file))
                {
                    temp.append(ch);
                }
                while(ch!='\n'&&!feof(file))
                {
                    ch = fgetc(file);
                    if ( ch != '\n')
                    {
                        temp.append(ch);
                    }
                }
                if ( strchr(opts, ch1) != NULL )
                {
                    tb->add(new SSTRING(temp));
                }
                else
                {
                    if (temp.cmp(line1)!=0&&temp.cmp(line2)!=0&&temp.cmp(line3)!=0&&temp.cmp(line4)!=0)
                        trash.add(new SSTRING(temp));
                }
            }
            else
            {
                while(ch!='\n'&&!feof(file))
                {
                    ch = fgetc(file);
                }
            }
        }
        cfg_file.fclose(file);
        cfg_old.remove_all();
        cfg_old.append (*tb);
    }
    return tb;
}


PUBLIC void savecfg(SSTRINGS *tb)
{
    if(cfg_file.exist())
    {
        FILE_CFG *file = cfg_file.fopen("w");
        SSTRINGS newconfig;
        newconfig.add(new SSTRING(line1));
        for(int x=0;x<tb->getnb();x++)
        {
            newconfig.add(new SSTRING(tb->getitem(x)->get()));
        }
        newconfig.add(new SSTRING(line2));
        newconfig.add(new SSTRING(line3));
        newconfig.add(new SSTRING(line4));
        for(int x=0;x<trash.getnb();x++)
        {
            newconfig.add(new SSTRING(trash.getitem(x)->get()));
        }
        for(int x=0;x<newconfig.getnb()-1;x++)
        {
            const char *temp = newconfig.getitem(x)->get();
            fputs(temp,file);
            fputc('\n', file);
        }
        cfg_old.remove_all();
        for(int x=0;x<tb->getnb();x++)
            cfg_old.add(new SSTRING(tb->getitem(x)->get()));
        cfg_file.fclose(file);
    }
}


PUBLIC bool cfg_compare(SSTRINGS *tb, SSTRINGS *cfg_old)
{
    int x;
    if (tb->getnb() != cfg_old->getnb())
        return 0;
    for(x=0;x<tb->getnb();x++)
    {
        if(tb->getitem(x)->cmp(cfg_old->getitem(x)->get()) != 0)
            return 0;
    }
    return 1;
}


PUBLIC SSTRINGS* cat_opts(char *opts, SSTRINGS *tb)
{
    SSTRINGS *new_tb = new SSTRINGS();
    for(int x=0;x<tb->getnb();x++)
    {
        if(strchr(opts, tb->getitem(x)->get()[0]) != NULL)
        {
            const char *ch=tb->getitem(x)->get();
            new_tb->add(new SSTRING(ch));
        }
    }
    return new_tb;
}


PUBLIC void change_opts(char *opts, SSTRINGS *tb, SSTRINGS *new_tb)
{
    SSTRINGS *temp_tb = new SSTRINGS();
    for(int x=0;x<tb->getnb();x++)
    {
        if(strchr(opts, tb->getitem(x)->get()[0]) == NULL)
        {
            temp_tb->add(new SSTRING(tb->getitem(x)->get()));
        }
    }
    for(int x=0;x<new_tb->getnb();x++)
    {
        temp_tb->add(new SSTRING(new_tb->getitem(x)->get()));
    }
    tb->remove_all();
    for(int x=0;x<temp_tb->getnb();x++)
    {
        const char *ch= temp_tb->getitem(x)->get();
        tb->add(new SSTRING(ch));
    }
}


PUBLIC char* get_opt(SSTRINGS *tb, int x, int y)
{
    char *buf = (char*) malloc(256);
    char *str = buf;
    int z=0;
    int w=0;
    for(;w<tb->getitem(x)->getlen()&&z<y;w++)
    {
        if(tb->getitem(x)->get()[w]==':')
            z++;
    }
    while(1)
    {
        if(tb->getitem(x)->get()[w] == '\0'||tb->getitem(x)->get()[w] == ':')
        {
            break;
        }
        else
        {
            *str++ = tb->getitem(x)->get()[w];
            w++;
        }
    }
    *str = 0;
    return buf;
}


PUBLIC bool verify_str(SSTRING str)
{
    if(strchr(str.get(), ':') == NULL )
        return 1;
    xconf_error(MSG_U(E_ERRN,"Error! The fields must not have colon\nBuffer not saved."));
    return 0;
}

PUBLIC bool verify_str(SSTRING str1, SSTRING str2)
{
    if(verify_str(str1))
        if(verify_str(str2))
            return 1;
    return 0;
}

PUBLIC bool verify_str(SSTRING str1, SSTRING str2, SSTRING str3)
{
    if(verify_str(str1, str2))
        if(verify_str(str3))
            return 1;
    return 0;
}

PUBLIC bool verify_str(SSTRING str1, SSTRING str2, SSTRING str3, SSTRING str4)
{
    if(verify_str(str1, str2, str3))
        if(verify_str(str4))
            return 1;
    return 0;
}

PUBLIC bool verify_str(SSTRING str1, SSTRING str2, SSTRING str3, SSTRING str4, SSTRING str5)
{
    if(verify_str(str1, str2, str3, str4))
        if(verify_str(str5))
            return 1;
    return 0;
}

PUBLIC bool passwd_comp(const char *pass1, const char *pass2)
{
    if ( strcmp(pass1, pass2) == 0)
        return 1;
    xconf_error(MSG_U(E_ERRP,"Error! The password confirmation does not match."));
    return 0;
}


PUBLIC SSTRING open_file(const char *file_path)
{
    SSTRING temp;
    //struct stat my_new_buf;
    //if(stat(file_path, &my_new_buf) == 0){
        FILE *file = fopen(file_path, "r");
        while(!feof(file))
        {
            const char ch = fgetc(file);
            if(!feof(file))
                temp.append(ch);
        }
        fclose(file);
    //}
    return temp;
}

PUBLIC void close_file(const char *file_path, SSTRING file_buf)
{
    FILE *file = fopen(file_path, "w");
    fprintf(file, "%s", file_buf.get());
    fclose(file);
}

