#pragma implementation

#include <stdlib.h>
#include <string.h>
#include <fviews.h>
#include "heartbeatconf.h"
#include "misc.h"
#include "heartbeatconf.m"


bool exists_ip_or_device(const char *item)
{
    VIEWITEMS tb;
    tb.read(file_haconf);
    int tb_size = tb.getnb();
    for(int x=0;x<tb_size;x++)
    {
        SSTRING tmp;
        tmp.copyword(str_skip(tb.getitem(x)->line.get()));
        if(tmp.cmp("serial") == 0 || tmp.cmp("ppp-udp") == 0 || tmp.cmp("udp") == 0)
        {
            SSTRING type;
            type.setfrom(tmp.get());
            const char *line = str_skip(tmp.copyword(replace_str(str_skip(tb.getitem(x)->line.get()), ',', ' ')));
            while(strcmp(line, "") != 0){
                line = str_skip(tmp.copyword(line));
                if (strcmp(tmp.get(), item) == 0){
                    if(is_ip(item)){
                        SSTRING message;
                        message.setfromf(MSG_U(ER_IPISINUSEDEVICE, "Another %s Device is using this IP: %s"), type.get(), item);
                        xconf_error(message.get());
                        return(1);
                    }else{
                        SSTRING message;
                        message.setfromf(MSG_U(ER_NAMEISINUSEDEVICE, "Another %s Device is using this name: %s"), type.get(), item);
                        xconf_error(message.get());
                        return(1);
                    }
                }
            }
        }
    }
    return(0);
}

const char *replace_str(char *str, unsigned char ch, unsigned char newch)
{
    char *new_str = str;
    for(unsigned int x=0;x<strlen(new_str);x++)
    {
        if(new_str[x] == ch)
            new_str[x] = newch;
    }
    return new_str;
}


void edit_devices()
{
    DIALOG_RECORDS dia;
    dia.newf_head("", MSG_U(H_DEVICES, "Device\tType\tIP"));
    int opt = -1;
    while(1)
    {
        VIEWITEMS tb;
        tb.read(file_haconf);
        int tb_size = tb.getnb();
        int item = 0;
        for(int x=0;x<tb_size;x++)
        {
            SSTRING tmp;
            tmp.copyword(str_skip(tb.getitem(x)->line.get()));
            if(tmp.cmp("serial") == 0 || tmp.cmp("ppp-udp") == 0 || tmp.cmp("udp") == 0)
            {
                SSTRING type;
                type.setfrom(tmp.get());
                const char *line = str_skip(tmp.copyword(replace_str(str_skip(tb.getitem(x)->line.get()), ',', ' ')));
                while(strcmp(line, "") != 0){
                    line = str_skip(tmp.copyword(line));
                    if(type.cmp("ppp-udp") == 0){
                        SSTRING str_tmp1, str_tmp2;
                        str_tmp1.setfrom(tmp);
                        line = str_skip(tmp.copyword(line));
                        str_tmp2.setfromf("%s\t%s", type.get(), tmp.get());
                        dia.set_menuitem(item,str_tmp1.get(),str_tmp2.get());
                    }else
                        dia.set_menuitem(item, tmp.get(), type.get());
                    item++;
                }
            }
        }
        dia.remove_last(item + 1);
        MENU_STATUS menu = dia.editmenu(MSG_U(T_DEVICES, "Device list"), MSG_U(I_DEVICEDELDES, "List of devices to send heartbeats."), help_heartbeat, opt, MENUBUT_ADD);
        if(menu == MENU_ESCAPE || menu == MENU_QUIT)
            break;
        else if(menu == MENU_ADD){
            add_device();
        }else if(menu == MENU_OK ){
            ren_device(opt);
        }
    }
}


void add_device()
{
    DIALOG_MENU dia_type;
    dia_type.new_menuitem("", MSG_U(M_SERIAL, "serial"));
    dia_type.new_menuitem("", MSG_U(M_PPPUDP, "ppp-udp"));
    dia_type.new_menuitem("", MSG_U(M_UDP, "udp"));
    int opt = -1;
    MENU_STATUS menu_type = dia_type.editmenu(MSG_U(T_DEVICETYPE, "Device Type"), MSG_U(I_DEVICETYPE, "Select a device type"), help_heartbeat, opt, 0);
    if(menu_type == MENU_OK){
        if (opt == 0){
            DIALOG dia;
            SSTRING name;
            dia.newf_str(MSG_U(F_DEVICENAME, "Device Name"), name);
            dia.last_noempty();
            while(1){
                MENU_STATUS menu = dia.edit(MSG_U(T_ADDSERIALDEVICE, "Adding Serial Device"), "", help_heartbeat);
                if( menu == MENU_ESCAPE || menu == MENU_QUIT || menu == MENU_CANCEL)
                    break;
                else if( menu == MENU_ACCEPT && !exists_ip_or_device(name.get())){
                    VIEWITEMS tb;
                    SSTRING item;
                    name.copyword(str_skip(name.get()));
                    item.setfromf("serial %s", name.get());
                    tb.read(file_haconf);
                    tb.add(new VIEWITEM(item.get()));
                    tb.write(file_haconf, NULL);
                    break;
                }
            }
        }else if(opt == 1){
            DIALOG dia;
            SSTRING name, ip;
            dia.newf_str(MSG_R(F_DEVICENAME), name);
            dia.last_noempty();
            dia.newf_str(MSG_U(F_DEVICEIP, "Device IP"), ip);
            dia.last_noempty();
            while(1){
                MENU_STATUS menu = dia.edit(MSG_U(T_ADDSERIALPPPDEVICE, "Adding Serial-PPP Device"), "", help_heartbeat);
                if( menu == MENU_ESCAPE || menu == MENU_QUIT || menu == MENU_CANCEL)
                    break;
                else if(menu == MENU_ACCEPT && verify_ip(ip.get())&& !exists_ip_or_device(name.get())&& !exists_ip_or_device(ip.get())){
                    VIEWITEMS tb;
                    SSTRING item;
                    name.copyword(str_skip(name.get()));
                    item.setfromf("ppp-udp %s %s", name.get(), ip.get());
                    tb.read(file_haconf);
                    tb.add(new VIEWITEM(item.get()));
                    tb.write(file_haconf, NULL);
                    break;
                }
            }
        }else if(opt == 2){
            DIALOG dia;
            SSTRING name;
            dia.newf_str(MSG_R(F_DEVICENAME), name);
            dia.last_noempty();
            while(1){
                MENU_STATUS menu = dia.edit(MSG_U(T_ADDETHERNETDEVICE, "Adding Ethernet Device"), "", help_heartbeat);
                if( menu == MENU_ESCAPE || menu == MENU_QUIT || menu == MENU_CANCEL)
                    break;
                else if(menu == MENU_ACCEPT && !exists_ip_or_device(name.get())){
                    VIEWITEMS tb;
                    SSTRING item;
                    name.copyword(str_skip(name.get()));
                    item.setfromf("udp %s", name.get());
                    tb.read(file_haconf);
                    tb.add(new VIEWITEM(item.get()));
                    tb.write(file_haconf, NULL);
                    break;
                }
            }
        }
    }
}

void ren_device(int opt)
{
    VIEWITEMS tb;
    tb.read(file_haconf);
    int tb_size = tb.getnb();
    int item = 0;
    for(int x=0;x<tb_size;x++)
    {
        SSTRING tmp;
        tmp.copyword(str_skip(tb.getitem(x)->line.get()));
        if(tmp.cmp("serial") == 0 || tmp.cmp("ppp-udp") == 0 || tmp.cmp("udp") == 0)
        {
            SSTRING type;
            type.setfrom(tmp.get());
            const char *line = str_skip(tmp.copyword(replace_str(str_skip(tb.getitem(x)->line.get()), ',', ' ')));
            SSTRING temp_item;
            bool change = 0;
            while(strcmp(line, "") != 0){
                line = str_skip(tmp.copyword(line));
                if(item != opt){
                    temp_item.setfromf("%s %s", temp_item.get(), tmp.get());
                    if(type.cmp("ppp-udp") == 0){
                        line = str_skip(tmp.copyword(line));
                        temp_item.setfromf("%s %s", temp_item.get(), tmp.get());
                    }
                }else{
                    DIALOG dia;
                    SSTRING name, ip;
                    SSTRING tmp_name, tmp_ip;
                    name.setfrom(tmp);
                    tmp_name.setfrom(tmp);
                    dia.newf_str(MSG_R(F_DEVICENAME), name);
                    if(type.cmp("ppp-udp") == 0){
                        line = str_skip(tmp.copyword(line));
                        ip.setfrom(tmp);
                        tmp_ip.setfrom(tmp);
                        dia.newf_str(MSG_R(F_DEVICEIP), ip);
                    }
                    int nof = 0;
                    while(1){
                        SSTRING title;
                        title.setfromf(MSG_U(T_EDITDEVICE, "Editing %s Device %s"), type.get(), name.get());
                        MENU_STATUS menu = dia.edit(title.get(), "", help_heartbeat, nof, MENUBUT_ACCEPT | MENUBUT_DEL | MENUBUT_CANCEL);
                        if(menu == MENU_QUIT || menu == MENU_ESCAPE || menu == MENU_CANCEL )
                            break;
                        else if(menu == MENU_ACCEPT && (tmp_name.cmp(name.get()) == 0 || !exists_ip_or_device(name.get()))){
                            if(type.cmp("ppp-udp") == 0 && ( tmp_ip.cmp(ip.get()) == 0 || (verify_ip(ip.get()) && !exists_ip_or_device(ip.get())))){
                                change = 1;
                                temp_item.setfromf("%s %s %s", temp_item.get(), name.get(), ip.get());
                                break;
                            }else{
                                change = 1;
                                temp_item.setfromf("%s %s", temp_item.get(), name.get());
                                break;
                            }
                        }else if(menu == MENU_DEL && dialog_yesno(MSG_R(T_DEL), MSG_U(T_DELDEVICE, "Do you realy want to remove this device?"), help_heartbeat) == MENU_YES ){
                            change = 1;
                            break;
                        }
                    }
                }
                item++;
            }
            if(change){
                VIEWITEM *it;
                it = tb.getitem(x);
                if(strcmp(str_skip(temp_item.get()),"") == 0)
                    tb.remove(it);
                else{
                    tmp.copyword(replace_str(str_skip(tb.getitem(x)->line.get()), ',', ' '));
                    it->line.setfromf("%s %s", tmp.get(), temp_item.get());
                }
                tb.write(file_haconf,NULL);
                break;
            }
        }
    }
}


