#pragma interface
#ifndef FIREWALL_H
#define FIREWALL_H

#ifndef MISC_H
    #include <misc.h>
#endif
#ifndef MODULE_H
    #include <module.h>
#endif

#if 1
	#include <dialog.h>
#else
	#include <modapi_def.h>
	#include <modapi.h>
#endif

class MODULE_firewall: public LINUXCONF_MODULE{
    /*~PROTOBEG~ MODULE_firewall */
public:
	MODULE_firewall (void);
	int dohtml (const char *key);
	int domenu (MENU_CONTEXT context,
		 const char *key);
	int execmain (int argc, char *argv[], bool);
	int message (const char *msg,
		 int ,
		 const char *[]);
	int probe (int level, int , bool);
	void setmenu (DIALOG&dia,
		 MENU_CONTEXT context);
    /*~PROTOEND~ MODULE_firewall */
};
#ifndef NETCONF_DEF_H
	#include <netconf_def.h>
#endif

class IPFW_SOLVED_TRIPLET: public ARRAY_OBJ{
public:
	bool not_flag;			// The ! syntax was used on the address
	char ip[LEN_IP_ASC];
	char mask[LEN_IP_ASC];
	char interface[LEN_IP_ASC];
	/*~PROTOBEG~ IPFW_SOLVED_TRIPLET */
public:
	IPFW_SOLVED_TRIPLET (const char *_ip,
		 const char *_mask,
		 const char *_interface,
		 bool _not_flag);
	/*~PROTOEND~ IPFW_SOLVED_TRIPLET */
};

class IPFW_SOLVED_TRIPLETS: public ARRAY{
	/*~PROTOBEG~ IPFW_SOLVED_TRIPLETS */
public:
	IPFW_SOLVED_TRIPLET *add (const char *_ip,
		 const char *_mask,
		 const char *_interface,
		 bool not_flag);
	IPFW_SOLVED_TRIPLET *getitem (int no)const;
	/*~PROTOEND~ IPFW_SOLVED_TRIPLETS */
};

class IPFW_SOLVED{
public:
	IPFW_SOLVED_TRIPLETS triplets;
	int nbbit_msk;		// Computed number of bit in the netmask
						// to speed up the sort.
	/*~PROTOBEG~ IPFW_SOLVED */
public:
	IPFW_SOLVED (void);
	/*~PROTOEND~ IPFW_SOLVED */
};

struct IPFW_SRC{
	SSTRING host;
	SSTRING netmask;
	SSTRING portrange;
	SSTRING ports;
	SSTRING interface;	// eth0 ...
	char allow_syn;		// tcp SYN packet accepted
	IPFW_SOLVED solved;
	SSTRING dispatch;	// How to dispatch in chains
};

#define FW_ACCEPT	0
#define FW_REJECT	1
#define FW_DENY		2

class DIALOG_CONTEXT;



class FWINFO_API;

enum FWTYPE{
	FWTYPE_INPUT,
	FWTYPE_FORWARD,
	FWTYPE_MASQ,
	FWTYPE_OUTPUT,
	FWTYPE_ACCT,
	FWTYPE_REDIR,
};

enum   FIREWALL_SECTION {
	FIRESECT_INPUT, FIRESECT_FORWARD, FIRESECT_OUTPUT,
	FIRESECT_ACCT, FIRESECT_INTERNAL
};

class IPFW_RULE: public ARRAY_OBJ{
	friend class IPFW_RULES;
protected:
	char active;		// Is this rules has been activated
				// by the user.
	SSTRING protocol;	// icmp, udp, tcp, all
	IPFW_SRC from;
	IPFW_SRC to;
	char bidir;		// the rule is bidirectional
	int  weight;		// Weight factor for ordering
	SSTRING comment;	// Comment/documentation
	bool solved_valid;	// All information is available
	char logging;		// Do logging when the rule is matched
	int rulenum;		// rule number for debugging
	FIREWALL_SECTION sectnum;
public:
	virtual void save(CONFDB *)=0;
	virtual int edit()=0;
	virtual int setup_left(bool doit, SSTRING *collect, SSTRING &errmsg)=0;
	virtual int setup_right(bool doit, SSTRING *collect, SSTRING &errmsg)=0;
	virtual int cmp_to (IPFW_RULE *r)=0;
	virtual int cmp_from (IPFW_RULE *r)=0;
	/*~PROTOBEG~ IPFW_RULE */
protected:
	IPFW_RULE (const char *&buf);
	IPFW_RULE (void);
public:
	int cmp_gen_from (IPFW_RULE *r,
		 int masq1,
		 int masq2,
		 int redir1,
		 int redir2);
	int cmp_gen_to (IPFW_RULE *r,
		 int masq1,
		 int masq2,
		 int redir1,
		 int redir2);
private:
	int diacheck (IPFW_SRC&s, int &nof);
public:
	int editk (DIALOG&dia,
		 const char *title,
		 DIALOG_CONTEXT&ctx);
	int getweight (void);
	bool is_bidir (void);
	int nbbitmask_from (void);
	int nbbitmask_to (void);
	void present (char *buf1,
		 int size1,
		 char *buf2,
		 int size2);
protected:
	void savek (char *buf);
public:
	int setup (int policy,
		 const IPFW_SRC&f,
		 const IPFW_SRC&t,
		 FWTYPE type,
		 const char *redirport,
		 const char *redirhost,
		 bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
protected:
	void setup_features (DIALOG&dia,
		 DIALOG_CONTEXT&);
	void setup_from (DIALOG&dia,
		 DIALOG_CONTEXT&ctx,
		 const char *devtitle);
	void setup_host (DIALOG&dia, SSTRING&host);
	void setup_interface (DIALOG&dia,
		 const char *devtitle,
		 SSTRING&interface);
	void setup_to (DIALOG&dia,
		 DIALOG_CONTEXT&ctx,
		 const char *devtitle);
	void setup_top (DIALOG&dia, DIALOG_CONTEXT&ctx);
private:
	int setupone (int policy,
		 const IPFW_SRC&f,
		 const IPFW_SRC&t,
		 FWTYPE type,
		 const char *redirport,
		 const char *redirhost,
		 bool syn_packets,
		 bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
public:
	int solve (IPFW_SRC&f,
		 FWINFO_API *tbapi[],
		 int nbapi);
	/*~PROTOEND~ IPFW_RULE */
};

class IPFW_RULEP: public IPFW_RULE{
protected:
	char policy; 	// FW_POLICY
	/*~PROTOBEG~ IPFW_RULEP */
protected:
	IPFW_RULEP (const char *&buf);
	IPFW_RULEP (void);
	void append_chain (char *buf);
	void append_newf (char *buf);
public:
	int cmp_policy_from (IPFW_RULEP *r,
		 int masq1,
		 int masq2,
		 int redir1,
		 int redir2);
	int cmp_policy_to (IPFW_RULEP *r,
		 int masq1,
		 int masq2,
		 int redir1,
		 int redir2);
protected:
	const char *extract_chain (const char *buf);
	const char *extract_newf (const char *buf);
	void setpolicy (DIALOG&dia);
	int setup (IPFW_SRC&f,
		 IPFW_SRC&t,
		 FWTYPE type,
		 const char *redirport,
		 const char *redirhost,
		 bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
public:
	/*~PROTOEND~ IPFW_RULEP */
};


class IPFW_RULE_FORWARD: public IPFW_RULEP{
	char masquerade;	// Masquerade while forwarding ?
	/*~PROTOBEG~ IPFW_RULE_FORWARD */
public:
	IPFW_RULE_FORWARD (const char *buf);
	IPFW_RULE_FORWARD (void);
	int cmp_from (IPFW_RULE *r);
	int cmp_to (IPFW_RULE *r);
	int edit (void);
	void save (CONFDB *db);
	int setup_left (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_FORWARD */
};

class IPFW_RULE_OUTPUT: public IPFW_RULEP{
	/*~PROTOBEG~ IPFW_RULE_OUTPUT */
public:
	IPFW_RULE_OUTPUT (const char *buf);
	IPFW_RULE_OUTPUT (void);
	int cmp_from (IPFW_RULE *r);
	int cmp_to (IPFW_RULE *r);
	int edit (void);
	void save (CONFDB *db);
	int setup_left (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_OUTPUT */
};

class IPFW_RULE_INPUT: public IPFW_RULEP{
	char doredir;
	SSTRING redirport;
	SSTRING redirhost;
	/*~PROTOBEG~ IPFW_RULE_INPUT */
public:
	IPFW_RULE_INPUT (const char *buf);
	IPFW_RULE_INPUT (void);
	int cmp_from (IPFW_RULE *r);
	int cmp_to (IPFW_RULE *r);
	int edit (void);
	void save (CONFDB *db);
	int setup_left (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_INPUT */
};

class IPFW_RULE_ACCT: public IPFW_RULE{
	/*~PROTOBEG~ IPFW_RULE_ACCT */
public:
	IPFW_RULE_ACCT (const char *buf);
	IPFW_RULE_ACCT (void);
	int cmp_from (IPFW_RULE *r);
	int cmp_to (IPFW_RULE *r);
	int edit (void);
	void save (CONFDB *db);
	int setup_left (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	int setup_right (bool doit,
		 SSTRING *collect,
		 SSTRING&errmsg);
	/*~PROTOEND~ IPFW_RULE_ACCT */
};

extern const char K_FIREWALL[];
extern const char K_FORWARD[];
extern const char K_BLOCK[];
extern const char K_OUTPUT[];
extern const char K_ACCT[];

#include "firewall.p"

#endif
