#include "drbdconf.h"
#include "drbdconf.m"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fviews.h>
#include <sys/stat.h>

#define TYPICAL_PATH_SIZE 500
#define TYPICAL_STRING_SIZE 100
#define TYPICAL_INPUT_SIZE 50

#define MAX_DRBD_FILES 10
#define DRBD_CONFIG_PATH "/etc/sysconfig/drbd"
#define DRBD_CONFIG_FILENAME "drbd"
#define DRBD_CONFIG_EXAMPLE "/etc/sysconfig/drbd/drbd.example"
#define DRBD_SYSTEMDEF "drbd"
#define DRBD_CONFIGFILE_HEADCOMMENT "# This file was created by Linuxconf's DRBD configurator\n# You may change this file by hand\n\n"
#define DRBD_DEFAULT_PORT 7788
#define DRBD_DEFAULT_RESTART_COMMAND "drbd restart"

HELP_FILE editdrbdfile_help("drbdconf", "drbdopts");
HELP_FILE drbdlist_help("drbdconf", "drbdlist");

char drbd_files[MAX_DRBD_FILES]; /* dbbd files status array, 0=file not present */


/* execute command line, in silence (no stdout output) */
int execute_proggy(char *given_command_line)
{
    char my_command[500];
    char my_args[500];
    char *where_to_cut;

    my_command[0]=0;
    my_args[0]=0;
    strcpy(my_command, given_command_line);
    if((where_to_cut=strchr(my_command, ' '))){
        *where_to_cut=0;
        where_to_cut++;
        strcpy(my_args, where_to_cut);
    }

    return(netconf_system_if(my_command, my_args));
}

void informational_window(const char *my_title, const char *my_text)
{
        int nothing=0;
        DIALOG uhoh_dialog;

        uhoh_dialog.editmenu(my_title, my_text, help_nil, nothing, 0);
}

/* returns true if drbd config directory exists
   if false, means that probably drbd is not installed on system */
int is_drbd_installed(void)
{
    struct stat my_statbuff;

    /* this thing exists? */
    if(stat(DRBD_CONFIG_PATH, &my_statbuff)){
        return(0);
    } else {
        /* ok, it exists.. but is it a directory? */
        if(!(my_statbuff.st_mode&S_IFDIR))
            return(0);
    }
    return(1);
}

/* returns a pointer or NULL, if file couldn't be loaded
   this memory shall be freed manually with free() */
char *load_file_to_memory(char *given_filename)
{
    FILE *my_file;
    char *my_buff;
    int  myfilesize;

    if((my_file=fopen(given_filename, "r"))){
        fseek(my_file, 0, SEEK_END);
        myfilesize=ftell(my_file);
        fseek(my_file, 0, SEEK_SET);
        if((my_buff=(char *)malloc(myfilesize+1))){
            *my_buff=0;
            *(my_buff+myfilesize)=0;
            fread(my_buff, myfilesize, 1, my_file);
            /* ok, whole file readen */
            return(my_buff);
        }
        fclose(my_file);
    }
    return(NULL);
}

/* appends string data to the given string with
 my_identificator provided_data (if *provided_data!=its_default_value)
 OR
 my_identificator  (if provided_data==NULL) */
void add_flag_data(const char *my_identificator, SSTRING *provided_data, char *given_destination)
{
    if(!provided_data){
        strcat(given_destination, my_identificator);
        strcat(given_destination, " ");
    } else {
        if(strlen(provided_data->get())){
            char temporary_thing[TYPICAL_STRING_SIZE];
            int  my_integer_value;

            my_integer_value=atoi(provided_data->get());
            sprintf(temporary_thing, "%s %d ", my_identificator, my_integer_value);
            strcat(given_destination, temporary_thing);
        }
    }
}

/* auxiliary routine for parsing
 returns !=0 if present
 ex.:  '-p 500' fills 500 and returns 1 if -p is asked
 if output_to==NULL then just returns its existance/non_existance */
int get_value_just_after_string(const char *where_to_seek, char *what_to_seek, SSTRING *output_to)
{
    char *where_it_is;
    char *where_to_zero;
    int  my_value=0;
    char copy_of_str[1000];

    strcpy(copy_of_str, where_to_seek);

    if((where_it_is=strstr(copy_of_str, what_to_seek))){
        my_value=1;
        if(output_to){
            if((where_it_is=strchr(where_it_is, ' '))){
                where_it_is++;
                where_to_zero=where_it_is;
                if((*where_to_zero>47)&&(*where_to_zero<58)){
                    while((*where_to_zero>47)&&(*where_to_zero<58)){
                        where_to_zero++;
                    }
                    *where_to_zero=0;
                    output_to->setfrom(where_it_is);
                }
            }
        }
    } else {
        return(0);
    }

    return(my_value);
}

/* fills array, uses drdb_files */
void fill_status_array(void)
{
    char my_filename[TYPICAL_PATH_SIZE];
    int my_counter=MAX_DRBD_FILES;

    while(my_counter--){
        sprintf(my_filename, "%s/%s%d", DRBD_CONFIG_PATH, DRBD_CONFIG_FILENAME, my_counter);
        {
            CONFIG_FILE cf_drbd(my_filename, help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, DRBD_SYSTEMDEF);
            drbd_files[my_counter]=cf_drbd.exist();
        }
    }
}

void strgname(SSTRING &givenstr)
{
    if(!(strcmp(givenstr.get(), "drbdconfcredits"))){
        int nothing=0;
        DIALOG uhoh_dialog;
        uhoh_dialog.editmenu("do you like lame easter eggs?", "this module was created by\nDaniel Mealha Cabrita\n(dancab@conectiva.com)\ninitial version: May, 2000", help_nil, nothing, 0);
    }
}

/* blablabla:1234  to  blablabla and 1234 */
void split_node_port(SSTRING &node_port_string, int *port_variable)
{
    char string_to_work_with[TYPICAL_STRING_SIZE];
    const char *string_to_read;
    char *where_the_separator_is;

    *port_variable=DRBD_DEFAULT_PORT;
    string_to_read=node_port_string.get();
    strcpy(string_to_work_with, string_to_read);

    if((where_the_separator_is=strchr(string_to_work_with, ':'))){
        *where_the_separator_is=0;
        node_port_string.setfrom(string_to_work_with);
        *port_variable=atoi(where_the_separator_is+1);
    }
}

/* blablabla and 1234  to  blablabla:1234 */
void join_node_port(SSTRING &node_port_string, int *port_variable)
{
    /* ommit port if defined to default */
    /* uncomment these two below lines if you want to ommit port number
       if it was defined with the default value the value will be ommited */
//    if(*port_variable!=DRBD_DEFAULT_PORT){
        char string_to_work_with[TYPICAL_STRING_SIZE];
        const char *string_to_read;

        string_to_read=node_port_string.get();
        sprintf(string_to_work_with, "%s:%d", string_to_read, *port_variable);
        node_port_string.setfrom(string_to_work_with);
//    }
}
                                                                                                                                                     /* linux: glupi ludzi, glupi os. lepiej pracowac na amidze. ;) */
void edit_given_drbdfile(char *drbd_filename)
{
    /* this is the data to be assigned to dialog */
    SSTRING s_master_node, s_slave_node, s_protocol,
    s_master_device, s_slave_device, s_master_partition, s_slave_partition,
    s_master_if, s_slave_if;
    SSTRING s_flag_t, s_flag_r, s_flag_s, s_flag_d; /* these are supposed to carry integer or BLANK string, only */
    int i_port_master, i_port_slave;
    char b_flag_k, b_flag_p; /* bool */

    /* these are the readen values which need to be processed before being sent to the correct variables */

    DIALOG     dia_editdrbd;
    FIELD_LIST *pop_protocol;
    VIEWITEMS  vitems_drbd;
    char my_filename[TYPICAL_PATH_SIZE];
    int  my_selection;
    int  my_button;

    sprintf(my_filename, "%s/%s", DRBD_CONFIG_PATH, drbd_filename);
    {
        CONFIG_FILE cf_drbd(my_filename, help_nil, CONFIGF_OPTIONAL|CONFIGF_MANAGED, DRBD_SYSTEMDEF);

        vitems_drbd.read(cf_drbd);

        char my_tempbuff[1000];
        const char *my_returned_string;

        /* fill with defaults */
        b_flag_k=0;
        b_flag_p=0;

        /* assumes SSTRING variables in empty state, just after their creation */

        if((my_returned_string=vitems_drbd.locateval("OPTIONS", my_tempbuff))){
            get_value_just_after_string(my_returned_string, "-t", &s_flag_t);
            get_value_just_after_string(my_returned_string, "-r", &s_flag_r);
            get_value_just_after_string(my_returned_string, "-s", &s_flag_s);
            get_value_just_after_string(my_returned_string, "-d", &s_flag_d);
            if(get_value_just_after_string(my_returned_string, "-k", NULL))
                b_flag_k=1;
            if(get_value_just_after_string(my_returned_string, "-p", NULL))
                b_flag_p=1;
        }

        if((my_returned_string=vitems_drbd.locateval("MASTER_NODE", my_tempbuff))){
            s_master_node.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("SLAVE_NODE", my_tempbuff))){
            s_slave_node.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("MASTER_DEVICE", my_tempbuff))){
            s_master_device.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("SLAVE_DEVICE", my_tempbuff))){
            s_slave_device.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("MASTER_PARTITION", my_tempbuff))){
            s_master_partition.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("SLAVE_PARTITION", my_tempbuff))){
            s_slave_partition.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("PROTOCOL", my_tempbuff))){
            s_protocol.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("MASTER_IF", my_tempbuff))){
            s_master_if.setfrom(my_returned_string);
        }
        if((my_returned_string=vitems_drbd.locateval("SLAVE_IF", my_tempbuff))){
            s_slave_if.setfrom(my_returned_string);
        }

        /* separates the port number from string (the way presented in config file) */
        if(*s_master_if.get()){
            split_node_port(s_master_if, &i_port_master);
        } else{
            split_node_port(s_master_node, &i_port_master);
        }
        if(*s_slave_if.get()){
            split_node_port(s_slave_if, &i_port_slave);
        } else {
            split_node_port(s_slave_node, &i_port_slave);
        }

        /* here starts the dialog construction.. */

        dia_editdrbd.newf_title(MSG_U(I_SETTINGSFORMASTER, "Settings for Master"), 1, "", MSG_R(I_SETTINGSFORMASTER));
        dia_editdrbd.newf_str(MSG_U(F_MASTERNODE, "Node:"), s_master_node, TYPICAL_INPUT_SIZE);
        dia_editdrbd.newf_str(MSG_U(F_MASTERIP, "IP (optional):"), s_master_if, TYPICAL_INPUT_SIZE);
        dia_editdrbd.newf_num(MSG_U(F_MASTERPORT, "Port:"), i_port_master);
        dia_editdrbd.newf_str(MSG_U(F_MASTERDEV, "Device:"), s_master_device, TYPICAL_INPUT_SIZE);
        dia_editdrbd.newf_str(MSG_U(F_MASTERPAR, "Partition:"), s_master_partition, TYPICAL_INPUT_SIZE);

        dia_editdrbd.newf_title(MSG_U(I_SETTINGSFORSLAVE, "Settings for Slave"), 1, "", MSG_R(I_SETTINGSFORSLAVE));
        dia_editdrbd.newf_str(MSG_U(F_SLAVENODE, "Node:"), s_slave_node, TYPICAL_INPUT_SIZE);
        dia_editdrbd.newf_str(MSG_U(F_SLAVEIP, "IP (optional):"), s_slave_if, TYPICAL_INPUT_SIZE);
        dia_editdrbd.newf_num(MSG_U(F_SLAVEPORT, "Port:"), i_port_slave);
        dia_editdrbd.newf_str(MSG_U(F_SLAVEDEV, "Device:"), s_slave_device, TYPICAL_INPUT_SIZE);
        dia_editdrbd.newf_str(MSG_U(F_SLAVEPAR, "Partition:"), s_slave_partition, TYPICAL_INPUT_SIZE);

        dia_editdrbd.newf_title(MSG_U(I_OTHERPROPS, "Other properties"), 1, "", MSG_R(I_OTHERPROPS));
        dia_editdrbd.newf_str(MSG_U(F_TIMEOUT, "Timeout (1/10th sec):"), s_flag_t);
        dia_editdrbd.newf_str(MSG_U(F_SYNCRATE, "Sync rate (KB/sec):"), s_flag_r);
        dia_editdrbd.newf_str(MSG_U(F_TRANSFERLOGSIZE, "Transfer log size (entries):"), s_flag_s);
        dia_editdrbd.newf_str(MSG_U(F_DISKSIZE, "Disk size (KB):"), s_flag_d);

        dia_editdrbd.newf_chk("", b_flag_k, MSG_U(F_SKIPSYNC, "Skip synchronization"));
        dia_editdrbd.newf_chk("", b_flag_p, MSG_U(F_KERNELPANIC, "Enable kernel panic"));

        pop_protocol=dia_editdrbd.newf_list(MSG_U(F_USEPROTOCOL, "Use protocol:"), s_protocol); {
            pop_protocol->addopt("A");
            pop_protocol->addopt("B");
            pop_protocol->addopt("C");
        }

        /* opens window.. */
        {
            char my_dialog_title[TYPICAL_STRING_SIZE];

            sprintf(my_dialog_title, MSG_U(T_EDITING, "Editing %s"), drbd_filename);
            my_selection=0;
            my_button=dia_editdrbd.editmenu(my_dialog_title, "", editdrbdfile_help, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL);
            strgname(s_master_node);
        }
        /* now user pressed some button, let's have some processing.. */


        if(*s_master_if.get()){
            join_node_port(s_master_if, &i_port_master);
        } else{
            join_node_port(s_master_node, &i_port_master);
        }
        if(*s_slave_if.get()){
            join_node_port(s_slave_if, &i_port_slave);
        } else {
            join_node_port(s_slave_node, &i_port_slave);
        }

        /* react according pressed dialog button */

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_DEL:
            {
                char my_remconfirm_title[TYPICAL_STRING_SIZE];

                sprintf(my_remconfirm_title, MSG_U(T_REMOVINGDEF, "Removing definition %s"), drbd_filename);
                if(dialog_yesno(my_remconfirm_title, MSG_U(I_REMOVETXT, "Do you really want\nto remove this definition?"), help_nil)==MENU_YES){
                    unlink(cf_drbd.getpath());
                }
            }
            break;
        case MENU_ACCEPT:
            {
                char options_temp_string[TYPICAL_STRING_SIZE];

                /* process flags.. */
                options_temp_string[0]=0;
                add_flag_data("-t", &s_flag_t, options_temp_string);
                add_flag_data("-r", &s_flag_r, options_temp_string);
                add_flag_data("-s", &s_flag_s, options_temp_string);
                add_flag_data("-d", &s_flag_d, options_temp_string);
                if(b_flag_k)
                    add_flag_data("-k", NULL, options_temp_string);
                if(b_flag_p)
                    add_flag_data("-p", NULL, options_temp_string);
                /* cuts last ' ' if strlen!=0 */
                if(strlen(options_temp_string)){
                    *(options_temp_string+(strlen(options_temp_string)-1))=0;
                }
                vitems_drbd.update("OPTIONS", options_temp_string);

                vitems_drbd.update("MASTER_NODE", s_master_node);
                vitems_drbd.update("SLAVE_NODE", s_slave_node);
                vitems_drbd.update("MASTER_DEVICE", s_master_device);
                vitems_drbd.update("SLAVE_DEVICE", s_slave_device);
                vitems_drbd.update("MASTER_PARTITION", s_master_partition);
                vitems_drbd.update("SLAVE_PARTITION", s_slave_partition);
                vitems_drbd.update("PROTOCOL", s_protocol);
                vitems_drbd.update("MASTER_IF", s_master_if);
                vitems_drbd.update("SLAVE_IF", s_slave_if);

                vitems_drbd.write(cf_drbd, NULL);
            }
            break;
        }
    }
}


/* returns !=-1 if entry couldn't be added */
int add_drbdfile(void)
{
    int my_counter=0;

    while(my_counter<MAX_DRBD_FILES){
        if(!drbd_files[my_counter]){
            char my_pathname[TYPICAL_PATH_SIZE];
            FILE *my_file;
            char *my_buff;

            /* copies example to newly-created file. if unable to, generate the new file by itself */
            sprintf(my_pathname, "%s/%s%d", DRBD_CONFIG_PATH, DRBD_CONFIG_FILENAME, my_counter);
            if((my_file=fopen(my_pathname, "w"))){

                if((my_buff=load_file_to_memory(DRBD_CONFIG_EXAMPLE)))
                {
                    /* copies the example to new entry */
                    fputs(my_buff, my_file);
                    free(my_buff);
                } else {
                    /* create default data */
                    fputs(DRBD_CONFIGFILE_HEADCOMMENT, my_file);
                    fputs("MASTER_NODE=\"ha1:7788\"\nSLAVE_NODE=\"ha2:7788\"\nMASTER_IF=\"\"\nSLAVE_IF=\"\"\nOPTIONS=\"\"\nPROTOCOL=\"B\"\nMASTER_DEVICE=\"/dev/nb0\"\nSLAVE_DEVICE=\"/dev/nb0\"\nMASTER_PARTITION=\"/dev/hda3\"\nSLAVE_PARTITION=\"/dev/hda3\"\n", my_file);
                }
                fclose(my_file);
                return(my_counter);
            }
        }
        my_counter++;
    }
    return(-1);
}

void select_drbdfile_to_edit(void)
{
    int  my_button=0;
    int  my_selection=0;
    char my_drbd_name[TYPICAL_STRING_SIZE];
    DIALOG_RECORDS dia_drbdfilelist;


    dia_drbdfilelist.newf_head("", MSG_U(F_CONFIGFILELIST, "configuration file"));

    while(1)
    {
    fill_status_array();

    {
        //        DIALOG_RECORDS dia_drbdfilelist;
//        dia_drbdfilelist.remove_all();
        int  my_counter;
        char my_used_name[TYPICAL_STRING_SIZE];
        int  line_counter=0;

//        dia_drbdfilelist.newf_head("", MSG_U(F_CONFIGFILELIST, "configuration file"));

        my_counter=0;
        while(my_counter<MAX_DRBD_FILES)
        {
            if(drbd_files[my_counter]){
                sprintf(my_used_name, "%s%d", DRBD_CONFIG_FILENAME, my_counter);
//                dia_drbdfilelist.new_menuitem(my_used_name, "");
                dia_drbdfilelist.set_menuitem(line_counter++, my_used_name, "");
            }
            my_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        dia_drbdfilelist.remove_last(line_counter+1);

        my_button=dia_drbdfilelist.editmenu(MSG_U(T_DRBDCONFIGURATOR, "DRBD configurator"), MSG_U(I_THESEARE, "These are the definitions present\nin this system."), drbdlist_help, my_selection, MENUBUT_QUIT|MENUBUT_ADD);
    }

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return;
    case MENU_ADD:
        {
            int added_drbd;

            added_drbd=add_drbdfile();
            if(added_drbd!=-1){
                sprintf(my_drbd_name, "%s%d", DRBD_CONFIG_FILENAME, added_drbd);
                edit_given_drbdfile(my_drbd_name);
            } else {
                informational_window(MSG_U(T_UNABLETOADDENTRY, "Unable to add entry"), MSG_U(I_UNABLETOADDENTRY, "The maximum number of entries has reached.\n\nYou have to delete some one in\norder to be able to add a new one."));
            }
        }
        break;
    default:
        {
            int my_counter=0;
            int my_true_counter=0;

            while((!drbd_files[my_counter])||(my_true_counter!=my_selection)){
                if(drbd_files[my_counter])
                    my_true_counter++;
                my_counter++;
            }
            sprintf(my_drbd_name, "%s%d", DRBD_CONFIG_FILENAME, my_counter);
            edit_given_drbdfile(my_drbd_name);
        }
        break;
    }
    }
}

void drbd_module_starter(void)
{
    if(perm_rootaccess("")){
        if(!is_drbd_installed()){
            char drbd_missing_warning_text[500];

            sprintf(drbd_missing_warning_text, MSG_U(I_DRBDNOTDETECTED, "Couldn't find directory \"%s\".\nSeems that DRBD wasn't properly installed\nor not installed at all."), DRBD_CONFIG_PATH);
            informational_window(MSG_U(T_DRBDDETECTED, "Unable to configure DRBD"), drbd_missing_warning_text);
            return;
        }

        select_drbdfile_to_edit();

/* old and dirty method.. now drbdconf probes the right way */
//        if(dialog_yesno(MSG_U(T_RESTARTINGDRBD, "Restarting DRBD"), MSG_U(I_RESTARTINGDRBD, "DRBD needs to be restarted in order\nto changes take effect.\n\nDo you want to restart DRBD services?"), help_nil)==MENU_YES){
//            execute_proggy(DRBD_DEFAULT_RESTART_COMMAND);
//        }
    }
}
