#pragma interface
#ifndef MISC_H
#define MISC_H

#include <stdio.h>

class ARRAY_OBJ{
protected:
	char modified;
	/*~PROTOBEG~ ARRAY_OBJ */
public:
	ARRAY_OBJ (void);
	virtual int edit (void);
	void rstmodified (void);
	void setmodified (void);
	virtual int was_modified (void);
	virtual ~ARRAY_OBJ (void);
	/*~PROTOEND~ ARRAY_OBJ */
};

class ARRAY: public ARRAY_OBJ{
protected:
	int is_owner;	// Is this object allowed to delete
			// the objects it contains ?
	ARRAY_OBJ **tb;
	int nb;
	int maxtb;	// Current maximum length of the table
	int increm;	// growth rate of tb
	/*~PROTOBEG~ ARRAY */
public:
	ARRAY (void);
	void add (ARRAY_OBJ *pt);
	int editone (ARRAY_OBJ *e);
	int editone (int no);
protected:
	ARRAY_OBJ *getitem (int no)const;
public:
	int getnb (void)const;
protected:
	void grow (void);
private:
	void grow_realloc (int newmax);
public:
	void insert (int pos, ARRAY_OBJ *pt);
	void invert (void);
	int lookup (ARRAY_OBJ *o)const;
	int manage_edit (ARRAY_OBJ *e, int code);
	int manage_edit (ARRAY_OBJ *e, int code, int insertpos);
	void moveto (ARRAY_OBJ *o, int newpos);
	void neverdelete (void);
	int remove (ARRAY_OBJ *obj);
	int remove (int no);
	void remove_all (void);
	int remove_del (ARRAY_OBJ *obj);
	int remove_del (int no);
	void remove_last (int cut);
	void rstmodified (void);
	void set (int pos, ARRAY_OBJ *pt);
	void setgrowth (int _increm);
	void sort (int (*cmp)(const ARRAY_OBJ *, const ARRAY_OBJ *));
	virtual int was_modified (void);
	virtual int write (void);
	virtual ~ARRAY (void);
	/*~PROTOEND~ ARRAY */
};


#ifndef SSTRING_H
	#include "sstring.h"
#endif
#ifndef CONFIGF_H
	#include "configf.h"
#endif

class ARRAY_KEY: public SSTRING{
	bool owner;		// May delete the object
public:
	ARRAY_OBJ *obj;
	/*~PROTOBEG~ ARRAY_KEY */
public:
	ARRAY_KEY (const char *_key,
		 ARRAY_OBJ *_obj,
		 bool is_owner);
	~ARRAY_KEY (void);
	/*~PROTOEND~ ARRAY_KEY */
};

class ARRAY_KEYS: public ARRAY{
	/*~PROTOBEG~ ARRAY_KEYS */
public:
	void add (const char *key,
		 ARRAY_OBJ *obj,
		 bool owner);
	void add (const char *key, ARRAY_OBJ *obj);
	ARRAY_KEY *getitem (int no)const;
	ARRAY_KEY *getobj (const char *key)const;
	ARRAY_OBJ *getval (const char *key)const;
	void sort (void);
	/*~PROTOEND~ ARRAY_KEYS */
};

class SSTRING_KEY: public ARRAY_KEY{
	/*~PROTOBEG~ SSTRING_KEY */
public:
	SSTRING_KEY (const char *_key, const char *_val);
	SSTRING *getobj (void);
	const char *getobjval (void);
	/*~PROTOEND~ SSTRING_KEY */
};

class SSTRING_KEYS: public ARRAY_KEYS{
	/*~PROTOBEG~ SSTRING_KEYS */
public:
	void add (const char *key, const char *val);
	SSTRING_KEY *getitem (int no)const;
	SSTRING_KEY *getobj (const char *key)const;
	const char *getval (const char *key)const;
	/*~PROTOEND~ SSTRING_KEYS */
};

class CONTEXT_LOCK{
	class CONTEXT_LOCK_PRIVATE *priv;
	/*~PROTOBEG~ CONTEXT_LOCK */
public:
	CONTEXT_LOCK (const char *_key1,
		 const char *_key2);
	CONTEXT_LOCK (const char *key);
private:
	void init (const char *_key1,
		 const char *_key2,
		 int _flags);
public:
	bool isok (void)const;
	~CONTEXT_LOCK (void);
	/*~PROTOEND~ CONTEXT_LOCK */
};


class DIALOG;

#ifndef DIALOG_DEF_H
	#include "dialog_def.h"
#endif

class PRIVILEGE;
class CONFDB;
class SSTREAM;
class USERACCT_COMNGS;
class FILE_CFG;

#include "module_api.h"

#include "misc.p"


#endif


