#pragma interface
#ifndef FVIEWS_H
#define FVIEWS_H

#ifndef MISC_H
	#include "misc.h"
#endif

class CONFIG_FILE;
class PRIVILEGE;
class VIEWITEMS;
class VIEWITEM;

enum VIEWITEM_TYPE{
	VIEWITEM_UNKNOWN,
	VIEWITEM_COMMENT,
	VIEWITEM_VARIABLE,
	VIEWITEM_EMPTY,
	VIEWITEM_LAST
};

class VIEWITEMS_PARSER{
protected:
	int cvi;		// Iterator for getline
	VIEWITEMS *vi;
public:
	SSTRINGS comstrs;
	char sepchar;
	char quotchar;
	bool linecont;
	/*~PROTOBEG~ VIEWITEMS_PARSER */
public:
	VIEWITEMS_PARSER (void);
	virtual void addline (const char *line);
	virtual const char *getline (bool reset,
		 const char *&comment);
	virtual void init (VIEWITEMS&_vi);
	virtual bool is_comment (const char *line);
	virtual const char *skip_comment (const char *line);
	/*~PROTOEND~ VIEWITEMS_PARSER */
	virtual ~VIEWITEMS_PARSER(){};
};

// #Specbeg: VIEWITEM / layout
class VIEWITEM: public ARRAY_OBJ{
public:
	SSTRING line;
	SSTRING comment;	// Comment at the end of the statement
	int type;
	// #Specend:
	/*~PROTOBEG~ VIEWITEM */
public:
	VIEWITEM (const char *_line);
	VIEWITEM (const char *_line, int _type);
	/*~PROTOEND~ VIEWITEM */
};

class VIEWITEMS: public ARRAY{
protected:
	VIEWITEMS_PARSER vip_default;
	VIEWITEMS_PARSER &vip;
	/*~PROTOBEG~ VIEWITEMS */
public:
	VIEWITEMS (VIEWITEMS_PARSER&_vip);
	VIEWITEMS (void);
	void add (VIEWITEM *pt);
	void add (VIEWITEM *pt, int type);
	void comment (VIEWITEM *vi);
	void comment (VIEWITEM *vi, const char *comstr);
	bool comment (const char *var);
	bool comment (const char *var, const char *comstr);
	VIEWITEM *getitem (int no)const;
	VIEWITEM *getitem (int no, int type)const;
	int getnb (int type)const;
	int getnb (void)const;
	void insert (int pos, VIEWITEM *pt);
	void insert (int pos, VIEWITEM *pt, int type);
	VIEWITEM *locate (const char *key);
	VIEWITEM *locate (const char *key,
		 int start,
		 int end);
	VIEWITEM *locate (const char *key,
		 int start,
		 int end,
		 int type);
	int locate (const char *key, VIEWITEMS&items);
	VIEWITEM *locate (const char *key, int type);
	VIEWITEM *locate (const char *key1,
		 const char *key2);
	int locate (const char *key1,
		 const char *key2,
		 VIEWITEMS&items);
	VIEWITEM *locate (const char *key1,
		 const char *key2,
		 int start,
		 int end);
	VIEWITEM *locate (const char *key1,
		 const char *key2,
		 int start,
		 int end,
		 int type);
	VIEWITEM *locate (const char *key1,
		 const char *key2,
		 int type);
private:
	int locate_gen (const char *key,
		 VIEWITEMS&items,
		 bool fullmatch);
public:
	int locate_prefix (const char *key,
		 VIEWITEMS&items);
	VIEWITEM *locateassign (const char *var);
	int locatebval (const char *var);
	int locatebval (const char *var, int defval);
	VIEWITEM *locatecommented (const char *var);
	int locatehval (const char *var);
	int locatenval (const char *var);
	const char *locateval (const char *var,
		 char tmp[1000]);
	int lookup (VIEWITEM *o)const;
	int lookup (VIEWITEM *o, bool real)const;
	void moveto (VIEWITEM *o, int newpos);
	void moveto (VIEWITEM *o, int newpos, int type);
	int read (CONFIG_FILE&fconf);
	int realpos (int no, int type)const;
	int remove_del (VIEWITEM *it);
	int remove_del (int no);
	int remove_del (int no, int type);
	void setcomcar (char com);
	void uncomment (VIEWITEM *vi);
	bool uncomment (const char *var);
	void update (const char *var, const SSTRING&val);
	void update (const char *var, const char *val);
	void update (const char *var, int val);
	void updatebval (const char *var, bool val);
	void updatehval (const char *var, int val);
	int virtpos (int no)const;
	int write (CONFIG_FILE&fconf, PRIVILEGE *priv);
	/*~PROTOEND~ VIEWITEMS */
};

#endif
