/* #Specification: FIELD_SHEET / principle
	A FIELD_SHEET is an array of text field. It may have several lines
	and columns. It may also have a "grow" button at the bottom allowing
	user to enlarge the array (add more lines).

	Further, it has a title line, one title for each column.
*/
#include <stdlib.h>
#include "dialog.h"
#include "../diajava/proto.h"
#include <string.h>

void sheet_required(){}

class FIELD_SHEET: public FIELD{
	SSTRINGS &rows;
	SSTRINGS backup;
	SSTRINGS current;
	const char **titles;
	int nbcols;
	int nbrows;
	/*~PROTOBEG~ FIELD_SHEET */
public:
	FIELD_SHEET (const char *prompt,
		 const char *_titles[],
		 SSTRINGS&_rows);
	MENU_STATUS dokey (WINDOW *,
		 int ,
		 FIELD_MSG&,
		 bool&);
	void drawtxt (WINDOW *, int);
	const char *get_registry_value (void);
	char getidprefix (void);
	void gui_draw (int nof, SSTRINGS&);
	MENU_STATUS gui_get (int nof,
		 const char *,
		 const char *);
	void html_draw (int nof);
	int html_validate (int nof);
	void reload (const char *, int);
	void restore (void);
	void save (void);
	void set_registry_value (const char *);
	/*~PROTOEND~ FIELD_SHEET */
};

PUBLIC FIELD_SHEET::FIELD_SHEET(
	const char *prompt,
	const char *_titles[],
	SSTRINGS &_rows)
	: FIELD (prompt), rows(_rows)
{
	titles = _titles;
	for (nbcols=0; titles[nbcols] != NULL; nbcols++);
	nbrows = rows.getnb()/nbcols;
	current.append (rows);
	backup.append (rows);
	vsize = nbrows + 2;
}

PUBLIC void FIELD_SHEET::set_registry_value(const char *)
{
}
PUBLIC const char *FIELD_SHEET::get_registry_value()
{
	return NULL;
}


PUBLIC void FIELD_SHEET::drawtxt(WINDOW *, int){}
PUBLIC MENU_STATUS FIELD_SHEET::dokey(WINDOW *, int , FIELD_MSG &, bool &)
{
	return MENU_NULL;
}
PUBLIC void FIELD_SHEET::save()
{
	rows.remove_all();
	rows.append (current);
}
PUBLIC void FIELD_SHEET::restore()
{
	rows.remove_all();
	rows.append (backup);
}
PUBLIC void FIELD_SHEET::reload(const char *, int)
{
	current.remove_all();
	current.append (rows);
}

PUBLIC void FIELD_SHEET::html_draw(int nof)
{
	html_printf ("<tr><td>%s",prompt);
	for (int i=0; i<nbcols; i++){
		html_printf ("<th>%s",titles[i]);
	}
	html_printf ("\n");
	int item = 0;
	for (int i=0; i<nbrows; i++){
		html_printf ("<tr><td>");
		for (int j=0; j<nbcols; j++,item++){
			html_printf ("<td>");
			char key[100];
			html_formatkey (key,"%s-%d.%d.%d",prompt,nof,i,j);
			html_defvar ("text",key,current.getitem(item)->get()
				,"size=30 maxlength=256");
			html_defvarcur (key,backup.getitem(item)->get());
		}
	}
}
PUBLIC char FIELD_SHEET::getidprefix ()
{
	return 'H';
}

PUBLIC int  FIELD_SHEET::html_validate(int nof)
{
	int ret = 0;
	int item = 0;
	for (int i=0; i<nbrows; i++){
		for (int j=0; j<nbcols; j++,item++){
			char key[100];
			html_formatkey (key,"%s-%d.%d.%d",prompt,nof,i,j);
			const char *old_val = html_getoldval (key);
			const char *new_val = html_getval (key);
			SSTRING *s = current.getitem(item);
			const char *buf = s->get();
			if (strcmp(buf,old_val)==0
				&& (int)strlen(new_val)<256){
				s->setfrom (new_val);
			}else{
				ret = -1;
			}
		}
	}
	return ret;
}


PUBLIC void FIELD_SHEET::gui_draw(int nof, SSTRINGS &)
{
	guisendprompt();
	char buf[1000];
	int len = 0;
	for (int i=0; titles[i] != NULL; i++){
		len += sprintf (buf+len," \"%s\"",titles[i]);
	}
	diagui_sendcmd (P_Sheet,"H%d %d %s\n",nof,nbcols,buf);
	int item=0;
	for (int i=0; i<nbrows; i++){
		for (int j=0; j<nbcols; j++,item++){
			char tmp[1000];
			diagui_sendcmd (P_Sheet_item,"H%d %d %d %s\n",nof,i,j
				,diagui_quote (rows.getitem(item)->get(),tmp));
		}
	}
}


PUBLIC MENU_STATUS FIELD_SHEET::gui_get(int nof, const char *, const char *)
{
	nbrows = atoi(diagui_getval('H',nof));
	current.remove_all();
	for (int i=0; i<nbrows; i++){
		for (int j=0; j<nbcols; j++){
			char tmp[20];
			sprintf (tmp,"%d-%d-%d",nof,i,j);
			const char *val = diagui_getval ('H',tmp);
			current.add (new SSTRING (val));
		}
	}
	return MENU_NULL;
}

PUBLIC void DIALOG::newf_sheet (
	const char *prompt,
	const char *titles[],
	SSTRINGS &tb)
{
	add (new FIELD_SHEET(prompt,titles,tb));
}

