#ifndef DIALOG_DEF_H
#define DIALOG_DEF_H

// #Specbeg: DIALOG_TYPE
enum DIALOG_TYPE {
	DIATYPE_STD,
	DIATYPE_ERROR,
	DIATYPE_NOTICE,
	DIATYPE_POPUP,
	DIATYPE_MENUPOPUP,
};
// #Specend:

// #Specbeg: MENU_CONTEXT
enum MENU_CONTEXT{
	MENU_UNKNOWN,		// Special menu which is unknown to modules
						// or is not yet module aware
	MENU_NETWORK_CLIENT,// Client section of the network menu
	MENU_NETWORK_SERVER,// Server section of the network menu
	MENU_NETWORK_MISC,	// Misc section of the network menu
	MENU_NETWORK_BOOT,	// Boot services section of the network menu
	MENU_MAIN_CONFIG,	// Config section of the main linuxconf menu
	MENU_MAIN_CONTROL,	// Control section of the main linuxconf menu
	MENU_CTRL_FILE,		// Control file and systems
	MENU_USER_STD,		// Standard user account section
	MENU_USER_SPC,		// Special user account section
	MENU_USER_POLICIES,	// Policies in user account section
	MENU_USER_ALIAS,	// Aliases in user account section
	MENU_CONTROL_PANEL,	// Control panel
	MENU_LOGS,			// All the logs
	MENU_NETWORK_FIREWALL,	// Firewalling
	MENU_SYS_STATUS,		// System status
	MENU_MAILCONF,		// Basic section of the mailconf main menu
	MENU_MISCSERV,		// Misc services menu
	MENU_FSCONF,		// File system configuration
	MENU_MAIN_STATUS,	// status section of the main linuxconf menu
	MENU_GURUS,			// Helpers to configure from scratch common
						// services (or set of services)
	MENU_BOOT,			// Boot mode and configuration
	MENU_HARDWARE,		// Peripheral section of the main menu
};
// #Specend:

// #Specbeg: definitions / MENUBUT
/* Optionnal buttons for menubox */
#define MENUBUT_SAVE	1
#define MENUBUT_ADD		2
#define MENUBUT_DEL		4
#define MENUBUT_INS		8
// Other button setup internally
#define MENUBUT_OK		16
#define MENUBUT_ACCEPT		32
#define MENUBUT_CANCEL		64
#define MENUBUT_QUIT		128
#define MENUBUT_YES		256
#define MENUBUT_NO		512
#define MENUBUT_EDIT		1024
#define MENUBUT_RESET		2048
#define MENUBUT_MORE		4096
#define MENUBUT_USR1		8192
#define MENUBUT_USR2		16384
#define MENUBUT_USR3		32768
#define MENUBUT_USR4		(32768<<1)
#define MENUBUT_USR5		(32768<<2)
#define MENUBUT_USR6		(32768<<3)
#define MENUBUT_USR7		(32768<<4)
// #Specend:

// #Specbeg: definitions / DIALOG_MODE
// User interface mode
enum DIALOG_MODE{
	DIALOG_CURSES,	// Use Ncurse
	DIALOG_HTML,	// Web mode
	DIALOG_GUI,		// One day maybe
	DIALOG_SILENT,	// Special mode, we don't want anything to be printed
	DIALOG_TREE,	// We are building the global menu tree
	DIALOG_TREEJMP,	// We are jumping to a special menu entry of the
					// global tree.
	DIALOG_GET,		// Called by the "registry" to grab data from fields
	DIALOG_SET,		// Called by the "registry" to put data into the fields
};
/*
	Glocal variable telling the current operation mode
*/
extern DIALOG_MODE dialog_mode;		
// #Specend:

enum DIAGUI_MODE{
	DIAGUI_AUTO,		// GUI mode if X11 is available, text mode if not
						// or if the GUI mode is disable from the features
						// screen
	DIAGUI_GUI,			// Pick the GUI mode even if disable from the
						// features screen
	DIAGUI_NOGUI,		// Text mode only
};

// #Specbeg: definitions / MENU_STATUS
// These are the values returned by DIALOG::edit___() functions.
// Note that beside MENU_ESCAPE, a call to edit can only return a code
// associated with a button you have registered.
enum MENU_STATUS {
	MENU_NULL,
	MENU_ESCAPE,
	MENU_CANCEL,
	MENU_QUIT,
	MENU_SAVE,
	MENU_OK,
	MENU_ACCEPT,
	MENU_DEL,
	MENU_INS,
	MENU_ADD,
	MENU_YES,
	MENU_NO,
	MENU_EDIT,
	MENU_RESET,
	MENU_INTERNAL_TIMEOUT,		// Used to signal a one second delay
								// to the dialog editor
	MENU_HELP,				// Help button, used internally
	MENU_MORE,
	MENU_USR1,
	MENU_USR2,
	MENU_USR3,
	MENU_USR4,
	MENU_USR5,
	MENU_USR6,
	MENU_USR7,

	MENU_CUT,
	MENU_MESSAGE,
	MENU_DUMP,
};
// #Specend:

enum HTML_KEY_TYPE{	// see FIELD_MENU::format_htmlkey()
	HTML_KEY_FULL,	// Use the tag and the menu text to create the key
	HTML_KEY_TAG,	// Use only the tag
	HTML_KEY_INDEX,	// Use the index of the field to create the key
};

// Definition for gui_dispolast()
enum GUI_H_DISPO {
	GUI_H_LEFT=0,
	GUI_H_CENTER=1,
	GUI_H_RIGHT=2
};
enum GUI_V_DISPO {
	GUI_V_TOP=0,
	GUI_V_CENTER=1,
	GUI_V_BOTTOM=2
};
enum GFONT_ID{
	GFONT_ID_DEFAULT=0,
	GFONT_ID_DECORATIVE=1,
	GFONT_ID_MODERN=2,
	GFONT_ID_ROMAN=3,
	GFONT_ID_SCRIPT=4,
	GFONT_ID_SWISS=5,
	GFONT_ID_TELETYPE=6,
};
enum GFONT_STYLE{
	GFONT_STYLE_DEFAULT=1,
	GFONT_STYLE_SLANT=2,
	GFONT_STYLE_ITALIC=3
};
enum GFONT_WEIGHT{
	GFONT_WEIGHT_DEFAULT=0,
	GFONT_WEIGHT_BOLD=1,
	GFONT_WEIGHT_LIGHT=2,
};

enum GPEN_STYLE{
	GPEN_STYLE_SOLID=0,
	GPEN_STYLE_TRANSPARENT=1,
	GPEN_STYLE_DOT=101,
	GPEN_STYLE_LONG_DASH=102,
	GPEN_STYLE_SHORT_DASH=103,
	GPEN_STYLE_DOT_DASH=104
};


enum GBRUSH_STYLE{
	GBRUSH_STYLE_SOLID=0,
};

#define MAX_LEN		2048

// Special dummy button for the GUI protocol
#define BUTSPC_XQUIT	99		// The user clicked on the X to close a dialog
#define BUTSPC_ENTER	98		// The user hit <enter> and this is the
								// default action for the dialog
#define BUTSPC_DUMP		97		// Dummy button sent when the application
								// requested a Dump

#endif
