/***************************************************************************
                          csquelch.cpp  -  description
                             -------------------
    begin                : Sun Apr 2 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "csquelch.h"

#define Black color[0]
#define Grey  color[64]
#define Cyan  color[127]
#define Yellow color[192]

mySlider::mySlider(QWidget *parent, const char *name = 0) : QSlider(0,100,10,50,QSlider::Vertical,parent,name)
{
setBackgroundColor(Black);
setValue(50);
Threshold=50;
SquelchLevel=0;
SquelchStatus = false;
}

mySlider::~mySlider()
{
}

/** Painting Slider Background depending on Threshold and Signal Strength      */
void mySlider::paintEvent(QPaintEvent *)
{
QPainter p;
int scale;
int y;
int slide;
y=height();
scale =(100- SquelchLevel)*y/100;
slide =(100- Threshold)*y/100;


p.begin(this);
if (SquelchStatus)
	p.fillRect(0,scale,20,y-scale,Yellow);
else
	p.fillRect(0,scale,20,y-scale,Grey);
paintSlider(&p,colorGroup(),QRect(0,slide,20,5));
p.setPen(Cyan);
drawWinGroove(&p,10);
p.end();
}

/** sets a new Threshold for Squelch */
void mySlider::newThreshold(int value)
{
int i;
i= 100-value;
if ( i != Threshold)
	{
	Threshold=i;
	setValue(value);
	repaint();
  }
}

CSquelch::CSquelch(QWidget *parent, const char *name  ) :QGroupBox(1,Horizontal,"Squelch",parent,name)
{
	
setFrameStyle(QFrame::WinPanel | QFrame::Raised);
setAlignment(AlignCenter);
setMargin(0);



Slider = new mySlider(this);
connect(Slider,SIGNAL(valueChanged(int)),Slider,SLOT(newThreshold(int)));
OnOff = new QRadioButton("On/Off",this);
OnOff->setChecked(true);
connect(OnOff,SIGNAL(clicked()),this,SLOT(turnOnOffSquelch()));
OnOffStatus=true;
}

CSquelch::~CSquelch()
{
delete Slider;
}


bool CSquelch::SquelchOn()
{
if (!OnOffStatus)
	return true;
else	
return Slider->SquelchStatus;

}

void CSquelch::setSquelchLevel(int i)
{
if ( ((Slider->SquelchLevel - i) > 2) || ((i - Slider->SquelchLevel) > 2 ))
	{
	if ( i > Slider->SquelchLevel ) 	// Signalquality raises
	 Slider->SquelchStatus = Slider->SquelchStatus || (i > Slider->Threshold);

	else											// Signalquality falls
	 Slider->SquelchStatus = Slider->SquelchStatus && (i > Slider->Threshold);
	 Slider->SquelchLevel=i;
 	 Slider->update();
	}	
}

void CSquelch::setSquelchStatus(bool squelch)
{

Slider->SquelchStatus = Slider->SquelchStatus || squelch;
}

void CSquelch::turnOnOffSquelch()
{
OnOffStatus = !OnOffStatus;
}

