/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-host-view.h"

#include "lm-host-view-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 26 "lm-host-view.gob"

#include "config.h"
#include "lm-util.h"
#include "lm-stock.h"

enum {
  COLUMN_HOST,
  COLUMN_NAME,
  N_COLUMNS
};

static GtkClipboard *global_clipboard;

#line 40 "lm-host-view.c"
/* self casting macros */
#define SELF(x) LM_HOST_VIEW(x)
#define SELF_CONST(x) LM_HOST_VIEW_CONST(x)
#define IS_SELF(x) LM_IS_HOST_VIEW(x)
#define TYPE_SELF LM_TYPE_HOST_VIEW
#define SELF_CLASS(x) LM_HOST_VIEW_CLASS(x)

#define SELF_GET_CLASS(x) LM_HOST_VIEW_GET_CLASS(x)

/* self typedefs */
typedef LMHostView Self;
typedef LMHostViewClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void lm_host_view_init (LMHostView * o) G_GNUC_UNUSED;
static void lm_host_view_class_init (LMHostViewClass * class) G_GNUC_UNUSED;
static GObject * ___6_lm_host_view_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static GSList * lm_host_view_get_selected_rows (LMHostView * self) G_GNUC_UNUSED;
static void lm_host_view_store_remove (LMHostView * self, GtkListStore * store, GtkTreeIter * iter) G_GNUC_UNUSED;
static void lm_host_view_reorder (LMHostView * self) G_GNUC_UNUSED;
static void ___real_lm_host_view_activate_add (LMHostView * self);
static void ___real_lm_host_view_activate_move (LMHostView * self, int direction);
static void ___real_lm_host_view_activate_remove (LMHostView * self);
static void lm_host_view_remove_selected_hosts (LMHostView * self) G_GNUC_UNUSED;
static void lm_host_view_copy_selected_hosts (LMHostView * self) G_GNUC_UNUSED;
static void ___real_lm_host_view_activate_cut (LMHostView * self);
static void lm_host_view_activate_cut (LMHostView * self) G_GNUC_UNUSED;
static void ___real_lm_host_view_activate_copy (LMHostView * self);
static void lm_host_view_activate_copy (LMHostView * self) G_GNUC_UNUSED;
static void ___real_lm_host_view_activate_paste (LMHostView * self);
static void lm_host_view_activate_paste (LMHostView * self) G_GNUC_UNUSED;
static void lm_host_view_selection_changed_h (GtkTreeSelection * selection, gpointer user_data) G_GNUC_UNUSED;
static void lm_host_view_editing_canceled_h (GtkCellRenderer * renderer, gpointer user_data) G_GNUC_UNUSED;
static void lm_host_view_edited_h (GtkCellRendererText * renderer, const char * path_string, const char * new_text, gpointer user_data) G_GNUC_UNUSED;
static void lm_host_view_update_sensitivity (LMHostView * self) G_GNUC_UNUSED;
static void lm_host_view_popup_menu (LMHostView * self, unsigned int button, guint32 activate_time) G_GNUC_UNUSED;
static gboolean lm_host_view_popup_menu_h (GtkWidget * widget, gpointer user_data) G_GNUC_UNUSED;
static gboolean lm_host_view_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data) G_GNUC_UNUSED;
static void lm_host_view_select_all_activate_h (GtkMenuItem * item, gpointer user_data) G_GNUC_UNUSED;
static void lm_host_view_up_activate_h (GtkMenuItem * item, gpointer user_data) G_GNUC_UNUSED;
static void lm_host_view_down_activate_h (GtkMenuItem * item, gpointer user_data) G_GNUC_UNUSED;
static gboolean lm_host_view_search_equal_cb (GtkTreeModel * model, int column, const char * key, GtkTreeIter * iter, gpointer search_data) G_GNUC_UNUSED;

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__activate_add(object,func,data)	lm_host_view_connect__activate_add((object),(func),(data))
#define self_connect_after__activate_add(object,func,data)	lm_host_view_connect_after__activate_add((object),(func),(data))
#define self_connect_data__activate_add(object,func,data,destroy_data,flags)	lm_host_view_connect_data__activate_add((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_move(object,func,data)	lm_host_view_connect__activate_move((object),(func),(data))
#define self_connect_after__activate_move(object,func,data)	lm_host_view_connect_after__activate_move((object),(func),(data))
#define self_connect_data__activate_move(object,func,data,destroy_data,flags)	lm_host_view_connect_data__activate_move((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_remove(object,func,data)	lm_host_view_connect__activate_remove((object),(func),(data))
#define self_connect_after__activate_remove(object,func,data)	lm_host_view_connect_after__activate_remove((object),(func),(data))
#define self_connect_data__activate_remove(object,func,data,destroy_data,flags)	lm_host_view_connect_data__activate_remove((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_cut(object,func,data)	lm_host_view_connect__activate_cut((object),(func),(data))
#define self_connect_after__activate_cut(object,func,data)	lm_host_view_connect_after__activate_cut((object),(func),(data))
#define self_connect_data__activate_cut(object,func,data,destroy_data,flags)	lm_host_view_connect_data__activate_cut((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_copy(object,func,data)	lm_host_view_connect__activate_copy((object),(func),(data))
#define self_connect_after__activate_copy(object,func,data)	lm_host_view_connect_after__activate_copy((object),(func),(data))
#define self_connect_data__activate_copy(object,func,data,destroy_data,flags)	lm_host_view_connect_data__activate_copy((object),(func),(data),(destroy_data),(flags))
#define self_connect__activate_paste(object,func,data)	lm_host_view_connect__activate_paste((object),(func),(data))
#define self_connect_after__activate_paste(object,func,data)	lm_host_view_connect_after__activate_paste((object),(func),(data))
#define self_connect_data__activate_paste(object,func,data,destroy_data,flags)	lm_host_view_connect_data__activate_paste((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (LMHostView *, gint , gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((LMHostView *)data1,
		(gint ) g_value_get_int (param_values + 1),
		data2);
}


enum {
	ACTIVATE_ADD_SIGNAL,
	ACTIVATE_MOVE_SIGNAL,
	ACTIVATE_REMOVE_SIGNAL,
	ACTIVATE_CUT_SIGNAL,
	ACTIVATE_COPY_SIGNAL,
	ACTIVATE_PASTE_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_APPLET,
	PROP_CAN_GO_UP,
	PROP_CAN_GO_DOWN
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GtkTreeViewClass *parent_class = NULL;

/* Short form macros */
#define self_get_can_go_up lm_host_view_get_can_go_up
#define self_set_can_go_up lm_host_view_set_can_go_up
#define self_get_can_go_down lm_host_view_get_can_go_down
#define self_set_can_go_down lm_host_view_set_can_go_down
#define self_get_selected_rows lm_host_view_get_selected_rows
#define self_store_remove lm_host_view_store_remove
#define self_reorder lm_host_view_reorder
#define self_activate_add lm_host_view_activate_add
#define self_activate_move lm_host_view_activate_move
#define self_activate_remove lm_host_view_activate_remove
#define self_remove_selected_hosts lm_host_view_remove_selected_hosts
#define self_copy_selected_hosts lm_host_view_copy_selected_hosts
#define self_activate_cut lm_host_view_activate_cut
#define self_activate_copy lm_host_view_activate_copy
#define self_activate_paste lm_host_view_activate_paste
#define self_selection_changed_h lm_host_view_selection_changed_h
#define self_editing_canceled_h lm_host_view_editing_canceled_h
#define self_edited_h lm_host_view_edited_h
#define self_update_sensitivity lm_host_view_update_sensitivity
#define self_popup_menu lm_host_view_popup_menu
#define self_popup_menu_h lm_host_view_popup_menu_h
#define self_button_press_event_h lm_host_view_button_press_event_h
#define self_select_all_activate_h lm_host_view_select_all_activate_h
#define self_up_activate_h lm_host_view_up_activate_h
#define self_down_activate_h lm_host_view_down_activate_h
#define self_search_equal_cb lm_host_view_search_equal_cb
#define self_new lm_host_view_new
GType
lm_host_view_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMHostViewClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_host_view_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMHostView),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_host_view_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_TREE_VIEW, "LMHostView", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMHostView *)g_object_new(lm_host_view_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMHostView * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMHostView *
GET_NEW_VARG (const char *first, ...)
{
	LMHostView *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMHostView *)g_object_new_valist (lm_host_view_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Host:View::finalize"
	LMHostView *self G_GNUC_UNUSED = LM_HOST_VIEW (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 45 "lm-host-view.gob"
	if(self->_priv->menu) { gtk_widget_destroy ((gpointer) self->_priv->menu); self->_priv->menu = NULL; }
#line 243 "lm-host-view.c"
}
#undef __GOB_FUNCTION__

static void 
lm_host_view_init (LMHostView * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host:View::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_HOST_VIEW,LMHostViewPrivate);
#line 45 "lm-host-view.gob"
	o->_priv->menu = gtk_menu_new();
#line 254 "lm-host-view.c"
}
#undef __GOB_FUNCTION__
#line 61 "lm-host-view.gob"
static void 
lm_host_view_class_init (LMHostViewClass * class G_GNUC_UNUSED)
#line 260 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) class;

	g_type_class_add_private(class,sizeof(LMHostViewPrivate));

	parent_class = g_type_class_ref (GTK_TYPE_TREE_VIEW);

	object_signals[ACTIVATE_ADD_SIGNAL] =
		g_signal_new ("activate_add",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMHostViewClass, activate_add),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_MOVE_SIGNAL] =
		g_signal_new ("activate_move",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMHostViewClass, activate_move),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_INT);
	if ___GOB_UNLIKELY(sizeof(int ) != sizeof(gint ) || parent_class == NULL /* avoid warning */) {
		g_error("lm-host-view.gob line 257: Type mismatch of \"activate_move\" signal signature");
	}
	object_signals[ACTIVATE_REMOVE_SIGNAL] =
		g_signal_new ("activate_remove",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMHostViewClass, activate_remove),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_CUT_SIGNAL] =
		g_signal_new ("activate_cut",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMHostViewClass, activate_cut),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_COPY_SIGNAL] =
		g_signal_new ("activate_copy",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMHostViewClass, activate_copy),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[ACTIVATE_PASTE_SIGNAL] =
		g_signal_new ("activate_paste",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION),
			G_STRUCT_OFFSET (LMHostViewClass, activate_paste),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 84 "lm-host-view.gob"
	g_object_class->constructor = ___6_lm_host_view_constructor;
#line 237 "lm-host-view.gob"
	class->activate_add = ___real_lm_host_view_activate_add;
#line 257 "lm-host-view.gob"
	class->activate_move = ___real_lm_host_view_activate_move;
#line 312 "lm-host-view.gob"
	class->activate_remove = ___real_lm_host_view_activate_remove;
#line 390 "lm-host-view.gob"
	class->activate_cut = ___real_lm_host_view_activate_cut;
#line 397 "lm-host-view.gob"
	class->activate_copy = ___real_lm_host_view_activate_copy;
#line 403 "lm-host-view.gob"
	class->activate_paste = ___real_lm_host_view_activate_paste;
#line 336 "lm-host-view.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_pointer
		("applet" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_APPLET,
		param_spec);
	param_spec = g_param_spec_boolean
		("can_go_up" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CAN_GO_UP,
		param_spec);
	param_spec = g_param_spec_boolean
		("can_go_down" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_CAN_GO_DOWN,
		param_spec);
    }
 {
#line 62 "lm-host-view.gob"

    GtkBindingSet *binding_set;

    global_clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);

    binding_set = gtk_binding_set_by_class(class);

    /* Delete removes a row */
    gtk_binding_entry_add_signal(binding_set, GDK_Delete, 0, "activate-remove", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_KP_Delete, 0, "activate-remove", 0);

    /* HIG 2.0 cut/copy/paste shortcuts */
    gtk_binding_entry_add_signal(binding_set, GDK_x, GDK_CONTROL_MASK, "activate-cut", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_c, GDK_CONTROL_MASK, "activate-copy", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_v, GDK_CONTROL_MASK, "activate-paste", 0);

    /* cut/copy/paste shortcuts taken from gtkentry.c */
    gtk_binding_entry_add_signal(binding_set, GDK_Delete, GDK_SHIFT_MASK, "activate-cut", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_Insert, GDK_CONTROL_MASK, "activate-copy", 0);
    gtk_binding_entry_add_signal(binding_set, GDK_Insert, GDK_SHIFT_MASK, "activate-paste", 0);
  
#line 393 "lm-host-view.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Host:View::set_property"
{
	LMHostView *self G_GNUC_UNUSED;

	self = LM_HOST_VIEW (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 43 "lm-host-view.gob"
self->_priv->applet = g_value_get_pointer (VAL);
#line 414 "lm-host-view.c"
		}
		break;
	case PROP_CAN_GO_UP:
		{
#line 56 "lm-host-view.gob"
self->can_go_up = g_value_get_boolean (VAL);
#line 421 "lm-host-view.c"
		}
		break;
	case PROP_CAN_GO_DOWN:
		{
#line 59 "lm-host-view.gob"
self->can_go_down = g_value_get_boolean (VAL);
#line 428 "lm-host-view.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "LM:Host:View::get_property"
{
	LMHostView *self G_GNUC_UNUSED;

	self = LM_HOST_VIEW (object);

	switch (property_id) {
	case PROP_APPLET:
		{
#line 43 "lm-host-view.gob"
g_value_set_pointer (VAL, self->_priv->applet);
#line 459 "lm-host-view.c"
		}
		break;
	case PROP_CAN_GO_UP:
		{
#line 56 "lm-host-view.gob"
g_value_set_boolean (VAL, self->can_go_up);
#line 466 "lm-host-view.c"
		}
		break;
	case PROP_CAN_GO_DOWN:
		{
#line 59 "lm-host-view.gob"
g_value_set_boolean (VAL, self->can_go_down);
#line 473 "lm-host-view.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 56 "lm-host-view.gob"
gboolean 
lm_host_view_get_can_go_up (LMHostView * self)
#line 492 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::get_can_go_up"
{
#line 56 "lm-host-view.gob"
		gboolean val; g_object_get (G_OBJECT (self), "can_go_up", &val, NULL); return val;
}}
#line 499 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 56 "lm-host-view.gob"
void 
lm_host_view_set_can_go_up (LMHostView * self, gboolean val)
#line 505 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::set_can_go_up"
{
#line 56 "lm-host-view.gob"
		g_object_set (G_OBJECT (self), "can_go_up", val, NULL);
}}
#line 512 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 59 "lm-host-view.gob"
gboolean 
lm_host_view_get_can_go_down (LMHostView * self)
#line 518 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::get_can_go_down"
{
#line 59 "lm-host-view.gob"
		gboolean val; g_object_get (G_OBJECT (self), "can_go_down", &val, NULL); return val;
}}
#line 525 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 59 "lm-host-view.gob"
void 
lm_host_view_set_can_go_down (LMHostView * self, gboolean val)
#line 531 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::set_can_go_down"
{
#line 59 "lm-host-view.gob"
		g_object_set (G_OBJECT (self), "can_go_down", val, NULL);
}}
#line 538 "lm-host-view.c"
#undef __GOB_FUNCTION__


#line 84 "lm-host-view.gob"
static GObject * 
___6_lm_host_view_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 545 "lm-host-view.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "LM:Host:View::constructor"
{
#line 86 "lm-host-view.gob"
	
    GObject *object;
    Self *self;
    GtkMenuShell *shell;
    GtkWidget *add_item;
    GtkWidget *select_all_item;
    GtkListStore *store;
    GtkCellRenderer *renderer;
    GtkTreeViewColumn *column;
    GtkTreeSelection *selection;
    GSList *l;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(self), FALSE);
    gtk_tree_view_set_reorderable(GTK_TREE_VIEW(self), TRUE);
    gtk_tree_view_set_search_equal_func(GTK_TREE_VIEW(self), self_search_equal_cb, NULL, NULL);

    shell = GTK_MENU_SHELL(selfp->menu);

    add_item = lm_menu_shell_append(shell, GTK_STOCK_ADD, NULL);
    selfp->remove_item = lm_menu_shell_append(shell, GTK_STOCK_REMOVE, NULL);
    lm_menu_shell_append(shell, NULL, NULL);
    selfp->up_item = lm_menu_shell_append(shell, GTK_STOCK_GO_UP, _("Move _Up"));
    selfp->down_item = lm_menu_shell_append(shell, GTK_STOCK_GO_DOWN, _("Move _Down"));
    lm_menu_shell_append(shell, NULL, NULL);
    selfp->cut_item = lm_menu_shell_append(shell, GTK_STOCK_CUT, NULL);
    selfp->copy_item = lm_menu_shell_append(shell, GTK_STOCK_COPY, NULL);
    selfp->paste_item = lm_menu_shell_append(shell, GTK_STOCK_PASTE, NULL);
    lm_menu_shell_append(shell, NULL, NULL);
    select_all_item = lm_menu_shell_append(shell, LM_STOCK_SELECT_ALL, NULL);

    g_signal_connect_swapped(add_item, "activate", G_CALLBACK(self_activate_add), self);
    g_signal_connect_swapped(selfp->remove_item, "activate", G_CALLBACK(self_activate_remove), self);
    g_signal_connect(selfp->up_item, "activate", G_CALLBACK(self_up_activate_h), self);
    g_signal_connect(selfp->down_item, "activate", G_CALLBACK(self_down_activate_h), self);
    g_signal_connect_swapped(selfp->cut_item, "activate", G_CALLBACK(self_activate_cut), self);
    g_signal_connect_swapped(selfp->copy_item, "activate", G_CALLBACK(self_activate_copy), self);
    g_signal_connect_swapped(selfp->paste_item, "activate", G_CALLBACK(self_activate_paste), self);
    g_signal_connect(select_all_item, "activate", G_CALLBACK(self_select_all_activate_h), self);

    store = gtk_list_store_new(N_COLUMNS, LM_TYPE_HOST, G_TYPE_STRING);
    gtk_tree_view_set_model(GTK_TREE_VIEW(self), GTK_TREE_MODEL(store));

    renderer = gtk_cell_renderer_text_new();
    g_object_set(G_OBJECT(renderer), "editable", TRUE, NULL);
    g_object_connect(renderer,
		     "signal::editing-canceled", self_editing_canceled_h, self,
		     "signal::edited", self_edited_h, self,
		     NULL);

    column = gtk_tree_view_column_new_with_attributes(_("Host"),
						      renderer,
						      "text", COLUMN_NAME,
						      NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(self), column);

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
    g_signal_connect(selection, "changed", G_CALLBACK(self_selection_changed_h), self);

    /* fill */
    LM_LIST_FOREACH(l, selfp->applet->hosts)
      {
	LMHost *host = l->data;
	GtkTreeIter iter;

	gtk_list_store_insert_with_values(store, &iter,
					  G_MAXINT,
					  COLUMN_HOST, host,
					  COLUMN_NAME, host->name,
					  -1);
      }

    /* handle row dnd */
    g_signal_connect_swapped(store, "row-deleted", G_CALLBACK(self_reorder), self);

    g_object_unref(store);

    g_object_connect(self,
		     "signal::popup-menu", self_popup_menu_h, NULL,
		     "signal::button-press-event", self_button_press_event_h, NULL,
		     NULL);

    self_update_sensitivity(self);

    return object;
  }}
#line 643 "lm-host-view.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 176 "lm-host-view.gob"
static GSList * 
lm_host_view_get_selected_rows (LMHostView * self)
#line 650 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::get_selected_rows"
#line 176 "lm-host-view.gob"
	g_return_val_if_fail (self != NULL, (GSList * )0);
#line 176 "lm-host-view.gob"
	g_return_val_if_fail (LM_IS_HOST_VIEW (self), (GSList * )0);
#line 657 "lm-host-view.c"
{
#line 178 "lm-host-view.gob"
	
    GtkTreeModel *model;
    GtkTreeSelection *selection;
    GList *paths;
    GList *l;
    GSList *references = NULL;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    paths = gtk_tree_selection_get_selected_rows(selection, NULL);

    LM_LIST_FOREACH(l, paths)
      {
	GtkTreePath *path = l->data;

	references = g_slist_append(references, gtk_tree_row_reference_new(model, path));
	gtk_tree_path_free(path);
      }
    g_list_free(paths);

    return references;
  }}
#line 682 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 201 "lm-host-view.gob"
static void 
lm_host_view_store_remove (LMHostView * self, GtkListStore * store, GtkTreeIter * iter)
#line 688 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::store_remove"
#line 201 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 201 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 201 "lm-host-view.gob"
	g_return_if_fail (store != NULL);
#line 201 "lm-host-view.gob"
	g_return_if_fail (GTK_IS_LIST_STORE (store));
#line 201 "lm-host-view.gob"
	g_return_if_fail (iter != NULL);
#line 701 "lm-host-view.c"
{
#line 205 "lm-host-view.gob"
	
    /* block dnd handler */
    g_signal_handlers_block_by_func(store, self_reorder, self);
    gtk_list_store_remove(store, iter);
    g_signal_handlers_unblock_by_func(store, self_reorder, self);
  }}
#line 710 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 212 "lm-host-view.gob"
static void 
lm_host_view_reorder (LMHostView * self)
#line 716 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::reorder"
#line 212 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 212 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 723 "lm-host-view.c"
{
#line 214 "lm-host-view.gob"
	
    GtkTreeModel *model;
    gboolean valid;
    GtkTreeIter iter;
    GSList *hosts = NULL;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    valid = gtk_tree_model_get_iter_first(model, &iter);

    while (valid)
      {
	LMHost *host;

	gtk_tree_model_get(model, &iter, COLUMN_HOST, &host, -1);
	hosts = g_slist_append(hosts, host);

	valid = gtk_tree_model_iter_next(model, &iter);
      }

    lm_applet_reorder_hosts(selfp->applet, hosts);
    lm_g_object_slist_free(hosts);
  }}
#line 748 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 237 "lm-host-view.gob"
void 
lm_host_view_activate_add (LMHostView * self)
#line 754 "lm-host-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 237 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 237 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 766 "lm-host-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_ADD_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 237 "lm-host-view.gob"
static void 
___real_lm_host_view_activate_add (LMHostView * self G_GNUC_UNUSED)
#line 782 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::activate_add"
{
#line 239 "lm-host-view.gob"
	
    GtkTreeModel *model;
    GtkTreePath *path;
    GtkTreeViewColumn *column;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    gtk_list_store_append(GTK_LIST_STORE(model), &selfp->add_pending_iter);
    selfp->add_pending_count++;

    path = gtk_tree_model_get_path(model, &selfp->add_pending_iter);
    column = gtk_tree_view_get_column(GTK_TREE_VIEW(self), 0);

    gtk_widget_grab_focus(GTK_WIDGET(self));
    gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(self), path, column, FALSE, 0, 0);
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(self), path, column, TRUE);
    gtk_tree_path_free(path);
  }}
#line 804 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 257 "lm-host-view.gob"
void 
lm_host_view_activate_move (LMHostView * self, int direction)
#line 810 "lm-host-view.c"
{
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 257 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 257 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 822 "lm-host-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_INT);
	g_value_set_int (&___param_values[1], (gint ) direction);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_MOVE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 257 "lm-host-view.gob"
static void 
___real_lm_host_view_activate_move (LMHostView * self G_GNUC_UNUSED, int direction)
#line 843 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::activate_move"
{
#line 259 "lm-host-view.gob"
	
    GtkTreeModel *model;
    GSList *references;
    GSList *l;

    g_return_if_fail(direction == -1 || direction == +1);

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    references = self_get_selected_rows(self);
    if (direction == +1)
      references = g_slist_reverse(references);

    LM_LIST_FOREACH(l, references)
      {
	GtkTreeRowReference *reference = l->data;
	GtkTreePath *path;
	GtkTreeIter iter;
	GtkTreeIter other_iter;
	gboolean status;

	path = gtk_tree_row_reference_get_path(reference);

	status = gtk_tree_model_get_iter(model, &iter, path);
	g_assert(status == TRUE);

	if (direction == -1)
	  gtk_tree_path_prev(path);
	else
	  gtk_tree_path_next(path);

	if (gtk_tree_model_get_iter(model, &other_iter, path))
	  {
	    LMHost *host;
	    LMHost *other_host;

	    gtk_tree_model_get(model, &iter, COLUMN_HOST, &host, -1);
	    gtk_tree_model_get(model, &other_iter, COLUMN_HOST, &other_host, -1);

	    gtk_list_store_swap(GTK_LIST_STORE(model), &iter, &other_iter);

	    g_object_unref(host);
	    g_object_unref(other_host);
	  }

	gtk_tree_path_free(path);
	gtk_tree_row_reference_free(reference);
      }
    g_slist_free(references);

    self_reorder(self);
    self_update_sensitivity(self); /* for up and down */
  }}
#line 900 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 312 "lm-host-view.gob"
void 
lm_host_view_activate_remove (LMHostView * self)
#line 906 "lm-host-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 312 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 312 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 918 "lm-host-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_REMOVE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 312 "lm-host-view.gob"
static void 
___real_lm_host_view_activate_remove (LMHostView * self G_GNUC_UNUSED)
#line 934 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::activate_remove"
{
#line 314 "lm-host-view.gob"
	
    self_remove_selected_hosts(self);
  }}
#line 942 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 318 "lm-host-view.gob"
static void 
lm_host_view_remove_selected_hosts (LMHostView * self)
#line 948 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::remove_selected_hosts"
#line 318 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 318 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 955 "lm-host-view.c"
{
#line 320 "lm-host-view.gob"
	
    GtkTreeModel *model;
    GSList *references;
    GSList *l;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    references = self_get_selected_rows(self);
    LM_LIST_FOREACH(l, references)
      {
	GtkTreeRowReference *reference = l->data;
	GtkTreePath *path;
	GtkTreeIter iter;
	gboolean status;
	LMHost *host;

	path = gtk_tree_row_reference_get_path(reference);
	status = gtk_tree_model_get_iter(model, &iter, path);
	g_assert(status == TRUE);
	gtk_tree_path_free(path);

	gtk_tree_model_get(model, &iter, COLUMN_HOST, &host, -1);

	lm_applet_remove_host(selfp->applet, host);
	self_store_remove(self, GTK_LIST_STORE(model), &iter);

	g_object_unref(host);
	gtk_tree_row_reference_free(reference);
      }
    g_slist_free(references);
  }}
#line 988 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 351 "lm-host-view.gob"
static void 
lm_host_view_copy_selected_hosts (LMHostView * self)
#line 994 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::copy_selected_hosts"
#line 351 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 351 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 1001 "lm-host-view.c"
{
#line 353 "lm-host-view.gob"
	
    GString *string;
    GtkTreeModel *model;
    GSList *references;
    GSList *l;

    string = g_string_new(NULL);
    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    references = self_get_selected_rows(self);
    LM_LIST_FOREACH(l, references)
      {
	GtkTreeRowReference *reference = l->data;
	GtkTreePath *path;
	GtkTreeIter iter;
	gboolean status;
	LMHost *host;

	path = gtk_tree_row_reference_get_path(reference);
	status = gtk_tree_model_get_iter(model, &iter, path);
	g_assert(status == TRUE);
	gtk_tree_path_free(path);

	gtk_tree_model_get(model, &iter, COLUMN_HOST, &host, -1);

	if (*string->str)
	  g_string_append_c(string, '\n');
	g_string_append(string, host->name);

	g_object_unref(host);
	gtk_tree_row_reference_free(reference);
      }
    g_slist_free(references);

    gtk_clipboard_set_text(global_clipboard, string->str, -1);
    g_string_free(string, TRUE);
  }}
#line 1040 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 390 "lm-host-view.gob"
static void 
lm_host_view_activate_cut (LMHostView * self)
#line 1046 "lm-host-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 390 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 390 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 1058 "lm-host-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_CUT_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 390 "lm-host-view.gob"
static void 
___real_lm_host_view_activate_cut (LMHostView * self G_GNUC_UNUSED)
#line 1074 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::activate_cut"
{
#line 392 "lm-host-view.gob"
	
    self_copy_selected_hosts(self);
    self_remove_selected_hosts(self);
  }}
#line 1083 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 397 "lm-host-view.gob"
static void 
lm_host_view_activate_copy (LMHostView * self)
#line 1089 "lm-host-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 397 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 397 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 1101 "lm-host-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_COPY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 397 "lm-host-view.gob"
static void 
___real_lm_host_view_activate_copy (LMHostView * self G_GNUC_UNUSED)
#line 1117 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::activate_copy"
{
#line 399 "lm-host-view.gob"
	
    self_copy_selected_hosts(self);
  }}
#line 1125 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 403 "lm-host-view.gob"
static void 
lm_host_view_activate_paste (LMHostView * self)
#line 1131 "lm-host-view.c"
{
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 403 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 403 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 1143 "lm-host-view.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ACTIVATE_PASTE_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 403 "lm-host-view.gob"
static void 
___real_lm_host_view_activate_paste (LMHostView * self G_GNUC_UNUSED)
#line 1159 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::activate_paste"
{
#line 405 "lm-host-view.gob"
	
    char *text;
    char **hosts;
    int i;
    GtkTreeModel *model;

    text = gtk_clipboard_wait_for_text(global_clipboard);
    g_assert(text != NULL);

    hosts = g_strsplit(text, "\n", 0);
    g_free(text);

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    for (i = 0; hosts[i]; i++)
      {
	GtkTreeIter iter;
	LMHost *host;

	host = lm_applet_add_host(selfp->applet, hosts[i]);

	gtk_list_store_insert_with_values(GTK_LIST_STORE(model), &iter,
					  G_MAXINT,
					  COLUMN_HOST, host,
					  COLUMN_NAME, hosts[i],
					  -1);
      }
    g_strfreev(hosts);
  }}
#line 1192 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 434 "lm-host-view.gob"
static void 
lm_host_view_selection_changed_h (GtkTreeSelection * selection, gpointer user_data)
#line 1198 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::selection_changed_h"
{
#line 437 "lm-host-view.gob"
	
    Self *self = user_data;

    self_update_sensitivity(self);
  }}
#line 1208 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 443 "lm-host-view.gob"
static void 
lm_host_view_editing_canceled_h (GtkCellRenderer * renderer, gpointer user_data)
#line 1214 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::editing_canceled_h"
{
#line 446 "lm-host-view.gob"
	
    Self *self = user_data;

    if (selfp->add_pending_count)
      {
	GtkTreeModel *model;

	selfp->add_pending_count--;
	model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
	self_store_remove(self, GTK_LIST_STORE(model), &selfp->add_pending_iter);
      }
  }}
#line 1231 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 459 "lm-host-view.gob"
static void 
lm_host_view_edited_h (GtkCellRendererText * renderer, const char * path_string, const char * new_text, gpointer user_data)
#line 1237 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::edited_h"
{
#line 464 "lm-host-view.gob"
	
    Self *self = user_data;
    GtkTreeModel *model;
    GtkTreePath *path;
    GtkTreeIter iter;
    LMHost *old_host;
    LMHost *host;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    path = gtk_tree_path_new_from_string(path_string);
    gtk_tree_model_get_iter(model, &iter, path);
    gtk_tree_path_free(path);

    gtk_tree_model_get(model, &iter, COLUMN_HOST, &old_host, -1);

    if (old_host)
      {
	host = lm_applet_replace_host(selfp->applet, old_host, new_text);
	g_object_unref(old_host);
      }
    else
      host = lm_applet_add_host(selfp->applet, new_text);

    gtk_list_store_set(GTK_LIST_STORE(model), &iter,
		       COLUMN_HOST, host,
		       COLUMN_NAME, new_text,
		       -1);

    if (selfp->add_pending_count)
      selfp->add_pending_count--;
  }}
#line 1273 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 496 "lm-host-view.gob"
static void 
lm_host_view_update_sensitivity (LMHostView * self)
#line 1279 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::update_sensitivity"
#line 496 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 496 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 1286 "lm-host-view.c"
{
#line 498 "lm-host-view.gob"
	
    GtkTreeModel *model;
    GtkTreeSelection *selection;
    GList *paths;
    gboolean has_selection = FALSE;
    gboolean has_prev = FALSE;
    gboolean has_next = FALSE;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(self));
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    paths = gtk_tree_selection_get_selected_rows(selection, NULL);

    if (paths)
      {
	GList *l;
	GtkTreeIter iter;
	gboolean status;

	has_selection = TRUE;

	/* has prev? */

	l = paths;
	if (gtk_tree_path_prev(l->data))
	  {
	    gtk_tree_path_next(l->data); /* restore it */
	    has_prev = TRUE;
	  }

	/* has next? */

	l = g_list_last(paths);
	status = gtk_tree_model_get_iter(model, &iter, l->data);
	g_assert(status == TRUE);
	if (gtk_tree_model_iter_next(model, &iter))
	  has_next = TRUE;

	/* cleanup */

	LM_LIST_FOREACH(l, paths)
	  gtk_tree_path_free(l->data);
	g_list_free(paths);
      }

    self_set_can_go_up(self, has_prev);
    self_set_can_go_down(self, has_next);

    gtk_widget_set_sensitive(selfp->remove_item, has_selection);
    gtk_widget_set_sensitive(selfp->cut_item, has_selection);
    gtk_widget_set_sensitive(selfp->copy_item, has_selection);
    gtk_widget_set_sensitive(selfp->up_item, has_prev);
    gtk_widget_set_sensitive(selfp->down_item, has_next);
  }}
#line 1342 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 552 "lm-host-view.gob"
static void 
lm_host_view_popup_menu (LMHostView * self, unsigned int button, guint32 activate_time)
#line 1348 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::popup_menu"
#line 552 "lm-host-view.gob"
	g_return_if_fail (self != NULL);
#line 552 "lm-host-view.gob"
	g_return_if_fail (LM_IS_HOST_VIEW (self));
#line 1355 "lm-host-view.c"
{
#line 554 "lm-host-view.gob"
	
    gtk_widget_set_sensitive(selfp->paste_item, gtk_clipboard_wait_is_text_available(global_clipboard));
    gtk_menu_popup(GTK_MENU(selfp->menu), NULL, NULL, NULL, NULL, button, activate_time);
  }}
#line 1362 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 559 "lm-host-view.gob"
static gboolean 
lm_host_view_popup_menu_h (GtkWidget * widget, gpointer user_data)
#line 1368 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::popup_menu_h"
{
#line 561 "lm-host-view.gob"
	
    Self *self = SELF(widget);

    self_popup_menu(self, 0, gtk_get_current_event_time());
    gtk_menu_shell_select_first(GTK_MENU_SHELL(selfp->menu), FALSE);

    return TRUE;		/* a menu was activated */
  }}
#line 1381 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 570 "lm-host-view.gob"
static gboolean 
lm_host_view_button_press_event_h (GtkWidget * widget, GdkEventButton * event, gpointer user_data)
#line 1387 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::button_press_event_h"
{
#line 574 "lm-host-view.gob"
	
    if (event->button == 3)
      self_popup_menu(SELF(widget), event->button, event->time);

    return FALSE;		/* propagate event */
  }}
#line 1398 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 581 "lm-host-view.gob"
static void 
lm_host_view_select_all_activate_h (GtkMenuItem * item, gpointer user_data)
#line 1404 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::select_all_activate_h"
{
#line 583 "lm-host-view.gob"
	
    Self *self = user_data;
    GtkTreeSelection *selection;

    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(self));
    gtk_tree_selection_select_all(selection);
  }}
#line 1416 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 591 "lm-host-view.gob"
static void 
lm_host_view_up_activate_h (GtkMenuItem * item, gpointer user_data)
#line 1422 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::up_activate_h"
{
#line 593 "lm-host-view.gob"
	
    Self *self = user_data;
    self_activate_move(self, -1);
  }}
#line 1431 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 598 "lm-host-view.gob"
static void 
lm_host_view_down_activate_h (GtkMenuItem * item, gpointer user_data)
#line 1437 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::down_activate_h"
{
#line 600 "lm-host-view.gob"
	
    Self *self = user_data;
    self_activate_move(self, +1);
  }}
#line 1446 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 605 "lm-host-view.gob"
static gboolean 
lm_host_view_search_equal_cb (GtkTreeModel * model, int column, const char * key, GtkTreeIter * iter, gpointer search_data)
#line 1452 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::search_equal_cb"
{
#line 611 "lm-host-view.gob"
	
    gboolean status = TRUE;
    GValue value = { 0, };
    GValue transformed = { 0, };
    const char *str;
    char *normalized_string;
    char *normalized_key;

    /*
     * The stock gtk_tree_view_search_equal_func() only searches the
     * start of the string, using strncmp(). We use strstr(), to
     * search anywhere inside the string.
     */

    gtk_tree_model_get_value(model, iter, column, &value);

    g_value_init(&transformed, G_TYPE_STRING);

    if (! g_value_transform(&value, &transformed))
      {
	g_value_unset(&value);
	return TRUE;
      }

    g_value_unset(&value);

    str = g_value_get_string(&transformed);
    if (! str)
      {
	g_value_unset(&transformed);
	return TRUE;
      }

    normalized_string = g_utf8_normalize(str, -1, G_NORMALIZE_ALL);
    normalized_key = g_utf8_normalize(key, -1, G_NORMALIZE_ALL);

    if (normalized_string && normalized_key)
      {
	char *case_normalized_string;
	char *case_normalized_key;

	case_normalized_string = g_utf8_casefold(normalized_string, -1);
	case_normalized_key = g_utf8_casefold(normalized_key, -1);

	if (strstr(case_normalized_string, case_normalized_key))
	  status = FALSE;

	g_free(case_normalized_string);
	g_free(case_normalized_key);
      }

    g_value_unset (&transformed);
    g_free(normalized_key);
    g_free(normalized_string);

    return status;
  }}
#line 1514 "lm-host-view.c"
#undef __GOB_FUNCTION__

#line 669 "lm-host-view.gob"
GtkWidget * 
lm_host_view_new (LMApplet * applet)
#line 1520 "lm-host-view.c"
{
#define __GOB_FUNCTION__ "LM:Host:View::new"
#line 669 "lm-host-view.gob"
	g_return_val_if_fail (applet != NULL, (GtkWidget * )0);
#line 669 "lm-host-view.gob"
	g_return_val_if_fail (LM_IS_APPLET (applet), (GtkWidget * )0);
#line 1527 "lm-host-view.c"
{
#line 671 "lm-host-view.gob"
	
    return GTK_WIDGET(GET_NEW_VARG(LM_HOST_VIEW_PROP_APPLET(applet), NULL));
  }}
#line 1533 "lm-host-view.c"
#undef __GOB_FUNCTION__
