/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "lm-host-frontend.h"

#include "lm-host-frontend-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "lm-host-frontend.gob"

#include "config.h"
#if WITH_GEOIP
#include <GeoIP.h>
#endif
#include "lm-util.h"
#include "lm-graph.h"

#define BAR_THICKNESS			6

#define N_SAMPLES			60 /* one minute */

static unsigned int tooltip_graph_data_timeout_id = 0;

#line 41 "lm-host-frontend.c"
/* self casting macros */
#define SELF(x) LM_HOST_FRONTEND(x)
#define SELF_CONST(x) LM_HOST_FRONTEND_CONST(x)
#define IS_SELF(x) LM_IS_HOST_FRONTEND(x)
#define TYPE_SELF LM_TYPE_HOST_FRONTEND
#define SELF_CLASS(x) LM_HOST_FRONTEND_CLASS(x)

#define SELF_GET_CLASS(x) LM_HOST_FRONTEND_GET_CLASS(x)

/* self typedefs */
typedef LMHostFrontend Self;
typedef LMHostFrontendClass SelfClass;

/* here are local prototypes */
static void lm_host_frontend_init (LMHostFrontend * o) G_GNUC_UNUSED;
static void lm_host_frontend_class_init (LMHostFrontendClass * c) G_GNUC_UNUSED;
static GObject * ___1_lm_host_frontend_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___2_lm_host_frontend_dispose (GObject * object) G_GNUC_UNUSED;
static gboolean lm_host_frontend_update_tooltip_graph_data_cb (gpointer data) G_GNUC_UNUSED;
static gboolean lm_host_frontend_update_tooltip_graph_text_dead_cb (gpointer data) G_GNUC_UNUSED;
static void lm_host_frontend_update_applet_progress_bar (LMHostFrontend * self) G_GNUC_UNUSED;
static void lm_host_frontend_update_tooltip_location (LMHostFrontend * self) G_GNUC_UNUSED;
static void lm_host_frontend_update_tooltip_status (LMHostFrontend * self) G_GNUC_UNUSED;
static void lm_host_frontend_update_tooltip_graph_text (LMHostFrontend * self) G_GNUC_UNUSED;
static void lm_host_frontend_update_tooltip_graph_text_dead (LMHostFrontend * self) G_GNUC_UNUSED;
static void lm_host_frontend_set_graph_text (LMHostFrontend * self, const char * text) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static LMHostClass *parent_class = NULL;

/* Short form macros */
#define self_update_tooltip_graph_data_cb lm_host_frontend_update_tooltip_graph_data_cb
#define self_update_tooltip_graph_text_dead_cb lm_host_frontend_update_tooltip_graph_text_dead_cb
#define self_configure_applet_progress_bar lm_host_frontend_configure_applet_progress_bar
#define self_update_applet_progress_bar lm_host_frontend_update_applet_progress_bar
#define self_update_tooltip_location lm_host_frontend_update_tooltip_location
#define self_update_tooltip_status lm_host_frontend_update_tooltip_status
#define self_update_tooltip_graph_text lm_host_frontend_update_tooltip_graph_text
#define self_update_tooltip_graph_text_dead lm_host_frontend_update_tooltip_graph_text_dead
#define self_set_graph_text lm_host_frontend_set_graph_text
#define self_new lm_host_frontend_new
GType
lm_host_frontend_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LMHostFrontendClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) lm_host_frontend_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LMHostFrontend),
			0 /* n_preallocs */,
			(GInstanceInitFunc) lm_host_frontend_init,
			NULL
		};

		type = g_type_register_static (LM_TYPE_HOST, "LMHostFrontend", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LMHostFrontend *)g_object_new(lm_host_frontend_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LMHostFrontend * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LMHostFrontend *
GET_NEW_VARG (const char *first, ...)
{
	LMHostFrontend *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LMHostFrontend *)g_object_new_valist (lm_host_frontend_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___dispose (GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::dispose"
	LMHostFrontend *self G_GNUC_UNUSED = LM_HOST_FRONTEND (obj_self);
#line 142 "lm-host-frontend.gob"
	___2_lm_host_frontend_dispose(obj_self);
#line 133 "lm-host-frontend.c"
#line 54 "lm-host-frontend.gob"
	if(self->applet_progress_bar) { g_object_unref ((gpointer) self->applet_progress_bar); self->applet_progress_bar = NULL; }
#line 136 "lm-host-frontend.c"
#line 57 "lm-host-frontend.gob"
	if(self->tooltip) { g_object_unref ((gpointer) self->tooltip); self->tooltip = NULL; }
#line 139 "lm-host-frontend.c"
}
#undef __GOB_FUNCTION__


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::finalize"
	LMHostFrontend *self G_GNUC_UNUSED = LM_HOST_FRONTEND (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#define samples (self->_priv->samples)
#define VAR samples
	{
#line 48 "lm-host-frontend.gob"
	 g_array_free(VAR, TRUE); }
#line 157 "lm-host-frontend.c"
	memset(&samples, 0, sizeof(samples));
#undef VAR
#undef samples
#line 52 "lm-host-frontend.gob"
	if(self->_priv->country_name) { g_free ((gpointer) self->_priv->country_name); self->_priv->country_name = NULL; }
#line 163 "lm-host-frontend.c"
}
#undef __GOB_FUNCTION__

static void 
lm_host_frontend_init (LMHostFrontend * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LM_TYPE_HOST_FRONTEND,LMHostFrontendPrivate);
}
#undef __GOB_FUNCTION__
static void 
lm_host_frontend_class_init (LMHostFrontendClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(LMHostFrontendPrivate));

	parent_class = g_type_class_ref (LM_TYPE_HOST);

#line 68 "lm-host-frontend.gob"
	g_object_class->constructor = ___1_lm_host_frontend_constructor;
#line 142 "lm-host-frontend.gob"
	g_object_class->dispose = ___dispose;
#line 188 "lm-host-frontend.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 68 "lm-host-frontend.gob"
static GObject * 
___1_lm_host_frontend_constructor (GType type G_GNUC_UNUSED, guint n_construct_properties, GObjectConstructParam * construct_params)
#line 198 "lm-host-frontend.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::constructor"
{
#line 70 "lm-host-frontend.gob"
	
    GObject *object;
    LMHost *host;
    Self *self;
    int i;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    host = LM_HOST(object);
    self = SELF(object);

    selfp->samples = g_array_sized_new(FALSE, TRUE, sizeof(double), N_SAMPLES);
    for (i = 0; i < N_SAMPLES; i++)
      {
	double value = -1;
	g_array_append_val(selfp->samples, value);
      }

    self->applet_progress_bar = gtk_progress_bar_new();

    self->tooltip = gtk_hbox_new(FALSE, 12);

    self->tooltip_status_box = gtk_hbox_new(FALSE, 6);

    self->tooltip_flag = gtk_image_new();
    selfp->tooltip_status = gtk_label_new(NULL);
    gtk_misc_set_alignment(GTK_MISC(selfp->tooltip_status), 0.0, 0.5);

    gtk_box_pack_start(GTK_BOX(self->tooltip_status_box), self->tooltip_flag, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(self->tooltip_status_box), selfp->tooltip_status, FALSE, FALSE, 0);

    selfp->tooltip_graph = lm_graph_new(host->applet);

    gtk_box_pack_start(GTK_BOX(self->tooltip), self->tooltip_status_box, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(self->tooltip), selfp->tooltip_graph, TRUE, TRUE, 0);

    gtk_widget_show_all(self->tooltip_status_box);
    gtk_widget_show(selfp->tooltip_graph);

    lm_gtk_object_ref_and_sink(GTK_OBJECT(self->applet_progress_bar));
    lm_gtk_object_ref_and_sink(GTK_OBJECT(self->tooltip));

    lm_callback_init(&selfp->applet_progress_bar_callback, (LMCallbackFunc) self_update_applet_progress_bar, self);
    lm_callback_init(&selfp->tooltip_location_callback, (LMCallbackFunc) self_update_tooltip_location, self);
    lm_callback_init(&selfp->tooltip_status_callback, (LMCallbackFunc) self_update_tooltip_status, self);
    lm_callback_init(&selfp->tooltip_graph_text_callback, (LMCallbackFunc) self_update_tooltip_graph_text, self);

    g_object_connect(self,
		     "swapped-signal::notify::ip", lm_callback_queue, &selfp->tooltip_location_callback,
		     "swapped-signal::notify::ip", lm_callback_queue, &selfp->tooltip_status_callback,
		     "swapped-signal::notify::status", lm_callback_queue, &selfp->tooltip_status_callback,
		     "swapped-signal::notify::error", lm_callback_queue, &selfp->tooltip_status_callback,
		     "swapped-signal::notify::alive", lm_callback_queue, &selfp->applet_progress_bar_callback,
		     "swapped-signal::notify::alive", lm_callback_queue, &selfp->tooltip_graph_text_callback,
		     "swapped-signal::notify::roundtrip-time", lm_callback_queue, &selfp->applet_progress_bar_callback,
		     "swapped-signal::notify::roundtrip-time", lm_callback_queue, &selfp->tooltip_graph_text_callback,
		     NULL);
    lm_g_object_connect(self, host->applet,
			"swapped-signal::notify::scale", lm_callback_queue, &selfp->applet_progress_bar_callback,
			NULL);

    if (! tooltip_graph_data_timeout_id)
      tooltip_graph_data_timeout_id = g_timeout_add(1000, self_update_tooltip_graph_data_cb, NULL);

    self_configure_applet_progress_bar(self);
    self_update_applet_progress_bar(self);
    self_update_tooltip_location(self);
    self_update_tooltip_status(self);
    self_update_tooltip_graph_text(self);

    return object;
  }}
#line 278 "lm-host-frontend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 142 "lm-host-frontend.gob"
static void 
___2_lm_host_frontend_dispose (GObject * object G_GNUC_UNUSED)
#line 285 "lm-host-frontend.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->dispose) \
		(* G_OBJECT_CLASS(parent_class)->dispose)(___object); }
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::dispose"
{
#line 144 "lm-host-frontend.gob"
	
    Self *self = SELF(object);

    lm_source_clear(&selfp->update_tooltip_graph_text_dead_timeout_id);

    lm_callback_clear(&selfp->applet_progress_bar_callback);
    lm_callback_clear(&selfp->tooltip_location_callback);
    lm_callback_clear(&selfp->tooltip_status_callback);
    lm_callback_clear(&selfp->tooltip_graph_text_callback);

    PARENT_HANDLER(object);
  }}
#line 305 "lm-host-frontend.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 157 "lm-host-frontend.gob"
static gboolean 
lm_host_frontend_update_tooltip_graph_data_cb (gpointer data)
#line 312 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_tooltip_graph_data_cb"
{
#line 159 "lm-host-frontend.gob"
	
    GSList *a;
    gboolean has_hosts = FALSE;

    GDK_THREADS_ENTER();

    LM_LIST_FOREACH(a, lm_shell->applets)
      {
	LMApplet *applet = a->data;
	GSList *b;

	LM_LIST_FOREACH(b, applet->hosts)
	  {
	    Self *self = b->data;
	    LMHost *host = LM_HOST(self);
	    double value;

	    has_hosts = TRUE;

	    g_array_remove_index(selfp->samples, 0);
	    value = host->alive ? host->roundtrip_time : -1;
	    g_array_append_val(selfp->samples, value);

	    lm_graph_set_data(LM_GRAPH(selfp->tooltip_graph), selfp->samples);
	  }
      }

    GDK_THREADS_LEAVE();

    if (has_hosts)
      return TRUE;		/* continue */
    else
      {				/* all hosts are gone, disable timeout */
	tooltip_graph_data_timeout_id = 0;
	return FALSE;
      }
  }}
#line 354 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 197 "lm-host-frontend.gob"
static gboolean 
lm_host_frontend_update_tooltip_graph_text_dead_cb (gpointer data)
#line 360 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_tooltip_graph_text_dead_cb"
{
#line 199 "lm-host-frontend.gob"
	
    Self *self = data;

    GDK_THREADS_ENTER();

    self_update_tooltip_graph_text_dead(self);

    GDK_THREADS_LEAVE();

    return TRUE;		/* continue */
  }}
#line 376 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 211 "lm-host-frontend.gob"
void 
lm_host_frontend_configure_applet_progress_bar (LMHostFrontend * self)
#line 382 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::configure_applet_progress_bar"
#line 211 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 211 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 389 "lm-host-frontend.c"
{
#line 213 "lm-host-frontend.gob"
	
    switch (panel_applet_get_orient(PANEL_APPLET(LM_HOST(self)->applet)))
      {
      case PANEL_APPLET_ORIENT_UP:
      case PANEL_APPLET_ORIENT_DOWN:
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(self->applet_progress_bar), GTK_PROGRESS_BOTTOM_TO_TOP);
	gtk_widget_set_size_request(self->applet_progress_bar, BAR_THICKNESS, -1);
	break;

      case PANEL_APPLET_ORIENT_LEFT:
      case PANEL_APPLET_ORIENT_RIGHT:
	gtk_progress_bar_set_orientation(GTK_PROGRESS_BAR(self->applet_progress_bar), GTK_PROGRESS_LEFT_TO_RIGHT);
	gtk_widget_set_size_request(self->applet_progress_bar, -1, BAR_THICKNESS);
	break;

      default:
	g_assert_not_reached();
	break;
      }
  }}
#line 412 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 234 "lm-host-frontend.gob"
static void 
lm_host_frontend_update_applet_progress_bar (LMHostFrontend * self)
#line 418 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_applet_progress_bar"
#line 234 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 234 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 425 "lm-host-frontend.c"
{
#line 236 "lm-host-frontend.gob"
	
    LMHost *host = LM_HOST(self);

    if (host->alive)
      {
	double fraction;

	fraction = host->roundtrip_time / LM_HOST(self)->applet->scale;
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(self->applet_progress_bar), CLAMP(fraction, 0.0, 1.0));
	gtk_widget_modify_bg(self->applet_progress_bar, GTK_STATE_NORMAL, NULL);
      }
    else
      {
	static const GdkColor color = { 0, 0xffff, 0x0000, 0x0000 };

	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(self->applet_progress_bar), 0);
	gtk_widget_modify_bg(self->applet_progress_bar, GTK_STATE_NORMAL, &color);
      }
  }}
#line 447 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 256 "lm-host-frontend.gob"
static void 
lm_host_frontend_update_tooltip_location (LMHostFrontend * self)
#line 453 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_tooltip_location"
#line 256 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 256 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 460 "lm-host-frontend.c"
{
#line 258 "lm-host-frontend.gob"
	
#if WITH_GEOIP
    LMHost *host = LM_HOST(self);
    GdkPixbuf *flag = NULL;
    char *country_name = NULL;

    if (host->ip)
      {
	GeoIP *geoip;

	geoip = GeoIP_new(0);
	if (geoip)
	  {
	    const char *country_code;

	    country_code = GeoIP_country_code_by_addr(geoip, host->ip);
	    if (country_code)
	      {
		char *base;
		char *filename;
		char *pathname;

		base = g_ascii_strdown(country_code, -1);
		filename = g_strconcat(base, ".svg", NULL);
		g_free(base);

		pathname = g_build_filename(FLAGSDIR, filename, NULL);
		g_free(filename);

		if (g_file_test(pathname, G_FILE_TEST_EXISTS))
		  {
		    GError *err = NULL;
		    GdkPixbuf *raw;

		    raw = gdk_pixbuf_new_from_file(pathname, &err);
		    if (raw)
		      {
			flag = gdk_pixbuf_scale_simple(raw, 30, 20, GDK_INTERP_BILINEAR);
			g_object_unref(raw);
		      }
		    else
		      {
			g_warning(_("unable to load %s: %s"), pathname, err->message);
			g_error_free(err);
		      }
		  }
		g_free(pathname);
	      }

	    country_name = g_strdup(GeoIP_country_name_by_addr(geoip, host->ip));
	    GeoIP_delete(geoip);
	  }
      }

    gtk_image_set_from_pixbuf(GTK_IMAGE(self->tooltip_flag), flag);
    if (flag)
      g_object_unref(flag);

    g_free(selfp->country_name);
    selfp->country_name = country_name;
#endif
  }}
#line 525 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 321 "lm-host-frontend.gob"
static void 
lm_host_frontend_update_tooltip_status (LMHostFrontend * self)
#line 531 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_tooltip_status"
#line 321 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 321 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 538 "lm-host-frontend.c"
{
#line 323 "lm-host-frontend.gob"
	
    LMHost *host = LM_HOST(self);
    char *small_text = NULL;
    char *markup;

    switch (host->status)
      {
      case LM_HOST_STATUS_RUNNING:
	if (host->ip && strcmp(host->ip, host->name))
	  {
	    if (selfp->country_name)
	      small_text = g_strdup_printf("%s, %s", selfp->country_name, host->ip);
	    else
	      small_text = g_strdup(host->ip);
	  }
	else if (selfp->country_name)
	  small_text = g_strdup(selfp->country_name);
	break;

      case LM_HOST_STATUS_RESOLVING:
	small_text = g_strdup(_("resolving hostname"));
	break;

      case LM_HOST_STATUS_ERROR:
	g_assert(host->error != NULL);
	small_text = g_strdup(host->error);
	break;

      default:
	g_assert_not_reached();
	break;
      }

    if (small_text)
      {
	markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>\n<span size=\"smaller\">%s</span>", host->name, small_text);
	g_free(small_text);
      }
    else
      markup = g_markup_printf_escaped("<span weight=\"bold\">%s</span>", host->name);

    gtk_label_set_markup(GTK_LABEL(selfp->tooltip_status), markup);
    g_free(markup);
  }}
#line 585 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 368 "lm-host-frontend.gob"
static void 
lm_host_frontend_update_tooltip_graph_text (LMHostFrontend * self)
#line 591 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_tooltip_graph_text"
#line 368 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 368 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 598 "lm-host-frontend.c"
{
#line 370 "lm-host-frontend.gob"
	
    LMHost *host = LM_HOST(self);

    if (host->alive)
      {
	char *text;

	lm_source_clear(&selfp->update_tooltip_graph_text_dead_timeout_id);

	text = g_strdup_printf(_("%.0f ms"), host->roundtrip_time);
	self_set_graph_text(self, text);
	g_free(text);
      }
    else
      {
	if (! selfp->update_tooltip_graph_text_dead_timeout_id)
	  {
	    self_update_tooltip_graph_text_dead(self);
	    selfp->update_tooltip_graph_text_dead_timeout_id = g_timeout_add(500, self_update_tooltip_graph_text_dead_cb, self);
	  }
      }
  }}
#line 623 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 393 "lm-host-frontend.gob"
static void 
lm_host_frontend_update_tooltip_graph_text_dead (LMHostFrontend * self)
#line 629 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::update_tooltip_graph_text_dead"
#line 393 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 393 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 636 "lm-host-frontend.c"
{
#line 395 "lm-host-frontend.gob"
	
    LMHost *host = LM_HOST(self);
    char *text = NULL;

    if (host->last_received)
      {
	time_t now;
	time_t diff;

	now = lm_time();
	diff = now - host->last_received;

	if (diff >= 10)
	  {
	    if (diff < 60)
	      text = g_strdup_printf(_("last reply: %i” ago"), diff);
	    else if (diff < 60 * 60)
	      text = g_strdup_printf(_("last reply: %.2i:%.2i” ago"), diff / 60, diff % 60);
	    else
	      text = g_strdup_printf(_("last reply: %.2i:%.2i:%.2i” ago"), diff / (60 * 60), (diff % (60 * 60)) / 60, diff % 60);
	  }
      }

    self_set_graph_text(self, text);
    g_free(text);
  }}
#line 665 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 422 "lm-host-frontend.gob"
static void 
lm_host_frontend_set_graph_text (LMHostFrontend * self, const char * text)
#line 671 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::set_graph_text"
#line 422 "lm-host-frontend.gob"
	g_return_if_fail (self != NULL);
#line 422 "lm-host-frontend.gob"
	g_return_if_fail (LM_IS_HOST_FRONTEND (self));
#line 678 "lm-host-frontend.c"
{
#line 424 "lm-host-frontend.gob"
	
    char *markup;

    markup = text ? g_markup_printf_escaped("<span size=\"small\">%s</span>", text) : NULL;
    lm_graph_set_markup(LM_GRAPH(selfp->tooltip_graph), markup);
    g_free(markup);
  }}
#line 688 "lm-host-frontend.c"
#undef __GOB_FUNCTION__

#line 432 "lm-host-frontend.gob"
LMHostFrontend * 
lm_host_frontend_new (LMApplet * applet, const char * name, unsigned int host_id)
#line 694 "lm-host-frontend.c"
{
#define __GOB_FUNCTION__ "LM:Host:Frontend::new"
#line 432 "lm-host-frontend.gob"
	g_return_val_if_fail (applet != NULL, (LMHostFrontend * )0);
#line 432 "lm-host-frontend.gob"
	g_return_val_if_fail (LM_IS_APPLET (applet), (LMHostFrontend * )0);
#line 432 "lm-host-frontend.gob"
	g_return_val_if_fail (name != NULL, (LMHostFrontend * )0);
#line 703 "lm-host-frontend.c"
{
#line 436 "lm-host-frontend.gob"
	
    return GET_NEW_VARG(LM_HOST_PROP_APPLET(applet),
			LM_HOST_PROP_NAME((char *) name),
			LM_HOST_PROP_HOST_ID(host_id),
			NULL);
  }}
#line 712 "lm-host-frontend.c"
#undef __GOB_FUNCTION__
