/* $Id: lesson.c,v 1.7 2005/03/24 10:27:23 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2004-2005 Marcus von Appen. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <string.h>
#include <libxml/xmlstring.h>

#include "errors.h"
#include "lesson.h"

/*
 * small wrapper around ling_lesson_create_lesson, which returns TRUE or FALSE,
 * dependant on if loading the passed lesson was successful or not
 */
lingbool
lesson_load_lesson_to_prefs (lingoteachSettings *preferences, char *file)
{
     lingLesson *ls = NULL;
     lingLesson *tmp = preferences->lessons;

     ls = ling_lesson_create (file, preferences->config);
     if (!ls)
          return FALSE;

     /* add lesson to global list */
     tmp = ling_lesson_add (preferences->lessons, ls);
     if (!tmp)
     {
          ling_lesson_free (ls);
          return FALSE;
     }
     preferences->lessons = tmp;

     debug ("Lesson %s successfully added!\n", file);

     return TRUE;
}

lingbool
lesson_lesson_in_list (lingLesson *list, char *file)
{
     /* check, if it is not already loaded */
     while (list)
     {
          if (xmlStrncmp (file, ling_lesson_get_path (list),
                          xmlStrlen (file)) == 0)
               return TRUE;
          list = list->next;
     }
     return FALSE;
}
