/* $Id: cfg.h,v 1.10 2005/05/10 17:18:39 marcusva Exp $
 *
 *  This file is part of LingoTeach, the Language Teaching program
 *  Copyright (C) 2001-2005 The LingoTeach Team. All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef LINGOTEACH_CFG_H
#define LINGOTEACH_CFG_H 1

#include <stdio.h>
#include <lingoteach.h>

#include "li18n.h"
#include "learn.h"

#define CONF_SOLUTION N_("Please make sure, your configuration has proper " \
                         "settings. This means exactly:\n" \
                         "The language file, configuration directory and " \
                         "the configuration file.")

typedef struct
{
     char      *conf_dir;
     char      *conf_file;
     char      *soundpath;
     char      *player;
     char      *browser;
     lingchar  **languages;
     lingLesson *lessons;
     lingConfig *config;
     lingbool   predef;   /* default config? */
     lingbool   skip;     /* config skipped? */
     lingbool   old_conf; /* used for backwards compatibility */
} lingoteachSettings;

typedef enum
{
     CONF_VAL_NONE = -1,
     CONF_VAL_SOUND,
     CONF_VAL_BROWSER,
     CONF_VAL_PLAYER
} lingConfValue;

/*
 * returns a new lingoteachSettings struct or NULL on error
 */ 
lingoteachSettings*
conf_init_new (void);

/*
 * loads the configuration data into the lingoteachSettings
 */
void
conf_load_config (lingoteachSettings *config);

/*
 * loads the languages from a file to the passed lingoteachSettings
 */
lingbool
conf_load_languages (lingoteachSettings *config, char *file);

#define CONF_LOAD_DEFAULT_LANGUAGES(x) \
    (conf_load_languages (x, DATADIR"/language.xml"))

/*
 * saves the data of the lingoteachSettings to the conf_file 
 */
lingbool
conf_save_settings (lingoteachSettings *config);

/*
 * sets the content of "what" to the passed preference entry
 */
void
conf_set_preference_val (lingoteachSettings *config, lingConfValue which,
                         char *what);

/*
 * frees a lingoteachSettings struct
 */
void 
conf_free_config (lingoteachSettings *config);

void
conf_load_defaults (lingoteachSettings *config);

void
conf_create_config_file (lingoteachSettings *config);

char*
file_read_line (FILE *fp, int *ok);

/* for backwards compatibility */
void
conf_load_old_conf (lingoteachSettings *config);

#endif /* LINGOTEACH_CFG_H */
