#define _LCS_MAIN

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <syslog.h>
#include "init.h"
#include "global_vars.h"
#include "../common.h"
#include "srv_def.h"
#include "cfg.h"
#include "cmd.h"
#include "con.h"
#include "iface.h"
#include "client.h"
#include "proc.h"
#include "execute.h"
#include "ipvalidator.h"
#include "times.h"
#include "netinput.h"
#include "cmd_lcp3.h"
#include "proc_supp.h"
#include "proc_lcp3.h"
#include "isdn_watcher.h"
#include "external.h"
#include "lines.h"
#include "syslog_call_from.h"
#include "../config.h"

/* declare the global vars */
/* server - settings */
struct server_t *server;
/* the lists cltlist, ordq, ackq */
struct list_anchor_t cltlist;
struct list_anchor_t ordq;
/* server has to wait for all acks in ackq of a certain client,
   before it can send a cmd to that client */
struct list_anchor_t ackq;
/* allow or deny listed IPs? */
struct list_anchor_t ipl;
struct list_anchor_t shtdn_ipl;
/* multiline */
struct list_anchor_t lstlines;

int segf_indicator = 0;
// the value of segf_indicator will be logged to syslog after a segfault happened

int time_failure()
{
    struct line_t *line = (struct line_t*)lstlines.first;
    struct client_t *clt = (struct client_t*)cltlist.first;
    struct ackq_item_t *aq = (struct ackq_item_t*)ackq.first;
    struct t_lcp3_ordq_item *lcp3oq = (struct t_lcp3_ordq_item*)lcp3_ordq.first;
    time_t now = time(NULL);
    signed int delta = now - server->small_loop;
    syslog(LOG_INFO, "system-time changed (%d secs), updating variables", delta);
    /* update client timeouts... */
    while ( clt )
    {
	//clt->timeout += delta + 10; // avoid strange things...
	clt->timeout = now + clt->interval; // avoid kicks!
	if ( clt->started != 0 ) clt->started += delta;
	clt = (struct client_t*)clt->next;
    }
    /* now avoid timeouts in the ackq */
    while ( aq )
    {
	aq->prev_try += delta;
	aq = (struct ackq_item_t*)aq->next;
    }
    /* update the lcp3_ordq too */
    while ( lcp3oq )
    {
	lcp3oq->prev_send += delta;
	lcp3oq = (struct t_lcp3_ordq_item*)lcp3oq->next;
    }
    /* hmm... yes we're now for 25 hours and 13 secs online.... :) */
    while ( line )
    {
	if ( line->con_up_time != 0 ) line->con_up_time += delta;
	line->pinger_prev += delta;
	line = (struct line_t*)line->next;
    }
    // make sure to run big loop
    server->big_loop = now - server->big_loop_min - 2;
    // we run small_loop everytime we pass... and that's quite now
    server->small_loop = now;
    server->mid_loop = now - LCS_LITTLE_LOOP;
    return(0);
}

int main(int argc, char *argv[])
{
 pid_t pid;
 struct sockaddr_in from;
 struct p_order_t pack;
 int rlen, len;
 int sock;	// got_data(...)
 char type;	// got_data(...)
 struct client_t *clt;
 fprintf(stdout, "LineControl Server %s -- %s\n", LCS_VERSION_STR, LCS_CPR);
 fflush(stdout);
 /*---- begin to work... ----*/
 if ( !(server = malloc(sizeof(struct server_t))) )
 {
     fprintf(stderr, "Not enough memory. Unable to start.\n");
     exit(-1);
 }
 if ( init(argc, argv) != 0 )
 {
     fprintf(stderr, "Init() failed. Unable to start.\n");
     // quite everything has to get cleaned up by the operatingsystem!
     exit(-1);
 }
 fprintf(stdout, "%s %s leaving the console...\n", LCS_NAME, LCS_VERSION_STR);
#ifndef STAY_TTY
 if ((pid = fork()) < 0)
 {
    fprintf(stderr, "unable to fork, terminating.\n");
    cleanup();
 }
 else { if (pid > 0) return(0); }
 setsid();
 if ((pid = fork()) < 0) {
     fprintf(stderr, "unable to fork, terminating.\n");
     cleanup();
 }
 else { if (pid > 0) return(0); }
#endif /* STAY_TTY */
 syslog(LOG_INFO, "%s %s started.", LCS_NAME, LCS_VERSION_STR);
 // dump our pid to a file...
 if ( server->pidfile )
     if ( server->pidfile[0] )
     {
         FILE* pidf;
	 if ( (pidf = fopen(server->pidfile, "w")) )
	 {
	     fprintf(pidf, "%d\n", getpid());
	     fclose(pidf);
	 }
	 else
	     syslog(LOG_INFO, "Unable to write to '%s'.", server->pidfile);
     }
 // check the ip lists... (we should disable them for the usage with pam...)
 if ( server->ipl_type == IPL_INVALID )
 {
     char *errmsg_iplinv = "Invalid IP list; unable to work.";
     syslog(LOG_ERR, "%s", errmsg_iplinv);
     fprintf(stderr, "%s\n", errmsg_iplinv);
     cleanup();
 }
 /*---- enter infinite loop... ----*/
 for (;;)
 {
	if ( server->syslog_call_from )
		handle_syslog_call_from();
	else
    	isdn_watcher(); // check whether isdnlog has news
    if ( (rlen = got_data(&pack, &from, &sock, &type)) > 0 )
    {
	 len = validate_pack(&pack, rlen);
	 if ( (validate_ip(server->ipl_type, &ipl, &from) == 0) && (len == 0) )
	 {	// OK, packet is valid
	     switch ( pack.version )
	     {
	         case LC_PACKET_VERSION: // DialControl Protocol
	             if ( pack.cmd == CMD_ACK )
	             {
	                 ack_remove(&pack, &from);
		         ack_proc(from.sin_addr.s_addr, from.sin_port);
	             }
	             else
	             {
	                 ack_send(&from, &pack);
	             }
	             process_order(&pack, &from, sock, type);
			     break;
			 default:
			     if ( (pack.version >= LCP3_MIN_PROTO_VERSION) && (pack.version <= LCP3_PROTO_VERSION) )
			     {
		    	     process_lcp3_order((struct t_lcp3_cmd*)&pack, &from, sock, type);
			     }
			     else
			     {
		    	     syslog(LOG_INFO, "%s:%d uses unsupported protocol", inet_ntoa(from.sin_addr), ntohs(from.sin_port));
		        	 if ( (clt = get_client(from.sin_addr.s_addr, from.sin_port)) )
			             kick_client(clt, 7);
			         else if ( type == SOCK_TYPE_TCP )
			             close(sock);
		    	 }
	     }
	 }
	 else if ( rlen > 0 )	// hmm... grmbl! invalid packet
	 {
	     if ( len == 0 )
	     {	// unallowed IP !!
	         struct t_lcp3_info_ack infoack;
	         syslog(LOG_WARNING, "%s:%d has no access.", inet_ntoa(from.sin_addr), ntohs(from.sin_port));
			 switch (pack.version)
			 {
			     case LC_PACKET_VERSION:
		    	     cmd_direct(CMD_REFUSED, sock, &from, NULL, 0, type);
					 break;
			     default:
			         if ( (pack.version >= LCP3_MIN_PROTO_VERSION) && (pack.version <= LCP3_PROTO_VERSION) )
			         {
		    	         infoack.ackcmd = pack.cmd;
		        	     lcp3_cmd_direct(CMD3_NOACCESS, sock, &infoack, sizeof(struct t_lcp3_info_ack));
					 }
			 }
	     }
	     else if ( rlen )
	     {	// invalid packet
	         syslog(LOG_WARNING, "%s:%d sent an invalid packet. code: %d", inet_ntoa(from.sin_addr), ntohs(from.sin_port), len);
		 }
	 }
     }
     /* ------ LITTLE LOOP ------ */
     // check (& update) time-vars
     if ( abs(time(NULL) - server->small_loop) > LCS_TIME_FAILED )
         time_failure(); // may happen with ntpdate or so.
     // update con status
segf_indicator = 1;
     check_con_status();
     // update LTP-status
segf_indicator = 2;
	 #ifdef LPT_MONITOR
	    update_lpt_status();
	 #endif
	 #ifdef LCD_MONITOR
	 	update_lcd_status();
	 #endif
segf_indicator = 3;
     /* ------ MIDDLE LOOP ------ */
     // do throughput calculations (mid_loop) & online-check
     if (    (time(NULL) - server->mid_loop > LCS_LITTLE_LOOP-1)
          && ( lines_up() > 0 )
	)
     {
segf_indicator = -4;
         if (server->send_throughput > 0) proc_throughput(NULL);
segf_indicator = 4;
	 lines_check_close(); // will close the lines which aren't in use anymore
segf_indicator = 5;
	 server->mid_loop = time(NULL);
     }
     if ( time(NULL) - server->big_loop > server->big_loop_min )
     {	// we have to run the big loop
segf_indicator = 6;
         server->big_loop = time(NULL);
segf_indicator = 7;
	 // check client timeouts
         clean_clients(NULL);
segf_indicator = 8;
	 // check ackq & lcp3_ordq for timeouts
	 ackq_check();
segf_indicator = 9;
	 lcp3_ordq_check();
segf_indicator = 10;
     }
     server->small_loop = time(NULL);
segf_indicator = 11;
     lines_check_pinger(); // do we have to send a ping on a line?
segf_indicator = 12;
     proc_con_action(); // are we closing / opening a line?
                        // is there a timeout on a line?
segf_indicator = 13;
 } // infinite loop, terminate with SIGQUIT or SIGTERM!
}

#undef _LCS_MAIN
