#include "external.h"

#include <asm/io.h>
#include <string.h>
#include <syslog.h>
#include "global_vars.h"
#include "../lcp3.h"

#ifdef LPT_MONITOR

void update_lpt_status()
{
    static int previous = -1;
    struct line_t *line = (struct line_t*)lstlines.first;
    int current;
    if ( !server->lpt_status ) return;
    while ( line )
    {
	if ( !strncmp(line->linename, server->lpt_linename, LCP3_LINENAME_LEN) )
	    break;
	line = (struct line_t*)line->next;
    }
    if ( !line )
    {
	server->lpt_status = 0;
	syslog(LOG_WARNING, "No line called '%s' to monitor on lpt!", server->lpt_linename);
	return;
    }
    switch ( server->lpt_status )
    {
	case 0: return;
	case 1: // lines
	    if ( (line->con_stat == CST_UP_USER)
		|| (line->con_stat == CST_UP_SERVER) )
		current = 1;
	    else
		current = 0;
	    break;
	case 2: // clients in 2-digit HEX mode
	    current = (line->online % 16) | ((line->online / 16) << 4);
	    break;
	default: server->lpt_status = 0; return;
    }
    if ( current != previous )
    {
	previous = current;
	outb(current, server->lpt_addr);
    }
}

#endif // LPT_MONITOR

#ifdef LCD_MONITOR
// contributed 20011024 by
// Martin Berentsen berentsen at sent5 dot uni-duisburg dot de
void update_lcd_status()
{
  static int previous = -1;
  struct line_t *line = (struct line_t*)lstlines.first;
  int cnt = 0;
  int c2 = 0;
  long int current = 0;
  time_t ut = 0;	      
  char tbuf[6];
  FILE *fd;
  
  struct client_t *cur = (struct client_t*)cltlist.first;
  while ( cur ) { cnt++; cur = (struct client_t*)cur->next; }

  if (line->con_stat == CST_UP_SERVER) 
    {
      c2 = 1; 
      ut = time(NULL) - line->con_up_time; /* time in secs here */
      sprintf(tbuf,"%.5ld",ut/60);
    }
  else sprintf(tbuf," off ");
  
  current = cnt+c2+line->online+ut;
  if ( current != previous ) 
    {
      previous = current; 
      if((fd = fopen("/dev/lcd","w")) != NULL)
        {
          fprintf(fd,"\33cU:%.2d O:%.1d \nT:%s",cnt,c2,tbuf);
          fclose(fd);
        }
    }
}
#endif
