import os, re

class DebFilenameParser:
    def __init__(self, file):
        parsed_filename = re.match(r'(?P<pkg>[^_]*)_(?P<version>[^_]*)(_.*)?\.', \
            os.path.split(file)[-1])
        if parsed_filename == None:
            self.package = '.'.join(os.path.split(file)[-1].split('.')[:-1])
            self.version = ''
        else:
            self.package = parsed_filename.groupdict()['pkg']
            self.version = parsed_filename.groupdict()['version']

