import re
from rfc822 import unquote
from linda import libchecks, checks
from linda.parser.menu import MenuParser

class MenuCheck(libchecks.LindaChecker):
    'Run checks over the menu files in a package.'
    def init(self):
        self.menu_files = {}
        
    def check_binary_2(self):
        self.load_menu_files()
        self.check_commands()
        self.check_paths()
        self.check_section()
        self.check_quoting()

    def load_menu_files(self):
        for file in self.information['collector']('files', 'files').keys():
            path, filename = os.path.split(file)
            if path in ('/usr/lib/menu', '/usr/share/menu'):
                self.menu_files[file] = \
                    MenuParser(os.path.join(self.information['dir'], \
                    'unpacked', file[1:]))
    def check_paths(self):
        if filter(lambda x: x.startswith('/usr/lib/menu'), \
            self.menu_files.keys()):
            self.signal_error('menu-files-in-usr-lib-menu')
    def check_commands(self):
        commands = []
        for menu in self.menu_files.keys():
            for stanza in self.menu_files[menu].menu_file:
                commands.append(stanza['fields']['command'])
        for cmd in commands:
            unquoted = unquote(cmd)
            real_cmd = unquoted.split(' ')[0]
            if re.search(r'(sh|killall|su-to-root)', real_cmd) is not None:
                continue
            found = 0
            if os.path.isabs(real_cmd):
                if os.path.exists(os.path.join(self.information['dir'], \
                    'unpacked', real_cmd[1:])):
                    found = 1
            else:
                for dir in ('usr/bin', 'bin', 'usr/bin/X11', 'usr/games'):
                    if os.path.exists(os.path.join(self.information['dir'], \
                        'unpacked', dir, real_cmd)):
                        found = 1
            if not found:
                self.signal_error('command-not-exist', [unquoted])
    def check_section(self):
        sections = {'Apps': ('Databases', 'Editors', 'Education', \
            'Emulators', 'Graphics', 'Hamradio', 'Math', 'Net', \
            'Programming', 'Science', 'Tools', 'Technical', 'Text', \
            'Shells', 'Sound', 'Viewers', 'System'), 'Games': ('Adventure', \
            'Arcade', 'Board', 'Card', 'Puzzles', 'Simulation', 'Sports', \
            'Strategy', 'Tetris-like', 'Toys'), 'Help': (), 'Screen': \
            ('Lock', 'Save', 'Root-window'), 'WindowManagers': ('Modules'), \
            'XShells': ()}
        for menu in self.menu_files.keys():
            for stanza in self.menu_files[menu].menu_file:
                tmp_sect = unquote(stanza['fields']['section']).split('/')
                if sections.has_key(tmp_sect[0]):
                    if len(tmp_sect) == 1:
                        if sections[tmp_sect[0]] and tmp_sect[0] != \
                            "WindowManagers":
                            self.signal_error('top-level-section-bad', \
                                [tmp_sect[0]])
                    elif tmp_sect:
                        if tmp_sect[1] not in sections[tmp_sect[0]]:
                            self.signal_error('unknown-menu-subsection', \
                                [tmp_sect[1]])
                else:
                    self.signal_error('unknown-menu-section', [tmp_sect[0]])
    def check_quoting(self):
        for menu in self.menu_files.keys():
            for stanza in self.menu_files[menu].menu_file:
                for field in stanza['fields']:
                    if not re.match(r'[\'"].*[\'"]$', stanza['fields'][field]):
                        self.signal_error('command-not-quoted', \
                            [stanza['fields'][field]])

checks.register(MenuCheck)

