/****************************************************************************
**
** $Id: profile.h,v 1.4 2001/06/28 23:03:34 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef PROFILE_H_20010626		// prevent multiple includes
#define PROFILE_H_20010626


/*---------------------------------------------------------------------------*
 *  Include Files                                                            *
 *---------------------------------------------------------------------------*/

#include "config.h"
#include "ac_system_defs.h"

#include <qstring.h>
//#include <qlist.h>

/*---------------------------------------------------------------------------*
 *  Definitions, Macros                                                      *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  typedefs                                                                 *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  global Variables                                                         *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  Prototypes / classes                                                     *
 *---------------------------------------------------------------------------*/



class lincvsProfile
{
  
    public:
        lincvsProfile(
          const QString& name,
          int method,
          const QString& user,
          const QString& server,
          const QString& repository)
          {
            _name       = name;
            _method     = method;
            _user       = user;
            _server     = server;
            _repository = repository;
          }
        
        QString     name()       const      { return _name; }
        int         method()     const      { return _method; }
        QString     user()       const      { return _user; }
        QString     server()     const      { return _server; }
        QString     repository() const      { return _repository; }


 private:
        QString     _name;
        int         _method;
        QString     _user;
        QString     _server;
        QString     _repository;
};


#endif	   //PROFILE_H_20010626

/*--------- END OF FILE -----------------------------------------------------*/
