/****************************************************************************
**
** $Id: globals.h,v 1.14 2001/10/15 22:39:48 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef GLOBALS_H_20010626
#define GLOBALS_H_20010626

//----------------------------------------------------------------------------

#include "config.h"
#include "ac_system_defs.h"

#include <qlabel.h>
#include <qstring.h>
#include <qstringlist.h>

//----------------------------------------------------------------------------

#ifdef MAIN
  #define EXTERN      
#else
  #define EXTERN extern
#endif


const int ACCESS_METHOD_ERROR =  0;
const int ACCESS_PSERVER      =  1;
const int ACCESS_RSH          =  2;
const int ACCESS_LOCAL        =  4;

const int RSH_DEFAULT         =  8;
const int RSH_EXT             = 16;
const int RSH_SERVER          = 32;


//--- cfg values -------------------------------------------------------------

EXTERN QStringList  m_projectDisabledList;
EXTERN QStringList  m_projectNameList;

EXTERN int          CHECKSTATUSINTERVALL; // [msec]
EXTERN int          CVSCALLINTERVALL;  
EXTERN int          PROGRESSINTERVALL;
EXTERN QString      CVSSTYLE;
//!!!EXTERN QString      INSTDIR; //	install directory
EXTERN QString      EDITOR; // editor command

EXTERN struct
{
  QString NAME;
  long int POINTSIZE;
  long WEIGHT;
  long ITALIC;
  long CHARSET;
}CVSFONT;

//--- settings / dialog ------------------------------------------------------

//EXTERN QStringList  m_coLinCVSProfile;



// geometry
EXTERN int          GEOM_X;
EXTERN int          GEOM_Y;
EXTERN int          GEOM_WIDTH;
EXTERN int          GEOM_HEIGHT;
EXTERN int          SPLITTER_POS_H;
EXTERN int          SPLITTER_POS_V;
EXTERN int          WORKBENCH_COLUMN_WIDTH;
EXTERN int          CVSLISTVIEW_TABWIDTH_NAME;
EXTERN int          CVSLISTVIEW_TABWIDTH_REV;
EXTERN int          CVSLISTVIEW_TABWIDTH_STICKY;
EXTERN int          CVSLISTVIEW_TABWIDTH_STATE;
EXTERN int          CVSLISTVIEW_TABWIDTH_COMMIT;
EXTERN int          CVSLISTVIEW_TABWIDTH_MODLOCAL;
EXTERN int          CVSLISTVIEW_TABWIDTH_MODUTC;
EXTERN int          NONCVSLISTVIEW_TABWIDTH_NAME;
EXTERN int          NONCVSLISTVIEW_TABWIDTH_MODLOCAL;
EXTERN int          NONCVSLISTVIEW_TABWIDTH_MODUTC;

//compression
EXTERN int          COMPRESSION;

//--- var --------------------------------------------------------------------

EXTERN bool     globalListViewsEnabled;

EXTERN bool     globalStopAction;
EXTERN QLabel   *globalStatusBar;
EXTERN int      timeZoneDiffInSecs;

EXTERN QString  cvsRsh;

EXTERN bool     StatTimerEnable; 

EXTERN bool     sshAgentIsRunning;
EXTERN int      sshPid;

EXTERN QString  terminal;
EXTERN QString  browser;

EXTERN QColor   SELECTION_COLOR_OF_LOGDLG[2];

EXTERN bool     bUseExternalDiffForSideBySide;
EXTERN QString  externalDiffProgram;

EXTERN bool     bAskForQuit;
EXTERN bool     bUseSmallIcons;

EXTERN QString  tmpDir;

//--- functions --------------------------------------------------------------

EXTERN void    determineTimeZoneDiff();

EXTERN bool    isInCvsPass(QString cvsRoot);
EXTERN void    login(QString cvsRoot);

EXTERN int     analyzeCVSROOT(QString& connectMethod, QString& userName, 
                             QString& host, QString& rootDir);

EXTERN void    removeDoubleSlashes(QString& s);

EXTERN void    startSshAgent();

//returns the filename of temp file or "" if the file could not created
EXTERN QString writeTmpFile(QString text);

//creates the temporarly directory
EXTERN void createTmpDir();

//returns the filename of created temp file or "" if the file could not created
EXTERN QString createTempFile();

//--- end of file ------------------------------------------------------------

#endif   //GLOBALS_H_20010626






