/****************************************************************************
**
** $Id: controls.h,v 1.4 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef CONTROLS_H_20010626
#define CONTROLS_H_20010626

//----------------------------------------------------------------------------

#include "config.h"
#include "ac_system_defs.h"


#include <qlineedit.h> 
#include <qvalidator.h>
#include <qcombobox.h>
#include <qstringlist.h> 
#include <qcheckbox.h> 
#include <qlabel.h>
#include <qradiobutton.h> 

//------------------------------------------------------------------------------

class IntValueLineEdit : public QLineEdit
{
   Q_OBJECT
public:
   IntValueLineEdit(QWidget * parent, const char * name=0);
   IntValueLineEdit(const QString &, QWidget * parent, const char * name=0);
   IntValueLineEdit(const int bottom, const int top, 
                    QWidget * parent, const char * name=0);
   IntValueLineEdit(const int bottom, const int top, 
                    const QString &, QWidget * parent, const char * name=0);
   
   void setRange(const int bottom, const int top);
   int bottom() const;
   int top() const;
   
public slots:
   void setText(const QString &);
   void validate();
   
protected:   
   void focusOutEvent(QFocusEvent *); 
   
   QIntValidator *m_pIntValidator;
};

//------------------------------------------------------------------------------

class TagOperationControl: public QWidget
{
   Q_OBJECT
public:
   TagOperationControl(QStringList *tagList, const QString& checkBoxLabel, 
                       QWidget *parent=0, bool tagEnabled = true, 
                       bool useSticky = true, const char *name=0);

   QString cvsParameter();
   
public slots:
   void enableControls(bool on);

protected:
   QStringList *m_pTagList;
   QComboBox * m_pTagChoice;

   QCheckBox  *m_pCheckBox;

   QRadioButton *m_pLabelRev;
   QRadioButton *m_pLabelTag;
   QRadioButton *m_pLabelDate;
   QRadioButton *m_pLabelSticky;
   
   QLineEdit *m_pRevision;
   QLabel *m_pDateLabel;
   QLabel *m_pTimeLabel;
   IntValueLineEdit *m_pYear;
   IntValueLineEdit *m_pMonth;
   IntValueLineEdit *m_pDay;
   IntValueLineEdit *m_pHour;
   IntValueLineEdit *m_pMinute;
};

//----------------------------------------------------------------------------


#endif	//CONTROLS_H_20010626
