/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/AboutDialogImpl.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/10/09 22:50:34 $
 *!!	$Revision: 1.11 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/

#include "config.h"
#include "ac_system_defs.h"

#include <unistd.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include "globals.h"             // for declaration of 'browser' 
#include "AboutDialogImpl.h"
#include "PixmapCache.h"

/* 
 *  Constructs a AboutDialogImpl which is a child of 'parent', with the 
 *  name 'About Dialog'.
 *
 *  The dialog will be 'modal'.
 */
AboutDialogImpl::AboutDialogImpl (QWidget* parent,  const char* version)
    : AboutDialog (parent, "About Dialog", true)
{
    if (bUseSmallIcons) setIcon( findEmbeddedPixmap( "lincvs-16" ) );
    else setIcon( findEmbeddedPixmap( "lincvs-32" ) );

    // Disable sorting
    AuthorList->setSorting (-1);

    VersionString->setText (tr ((version) ? version : "UNSPECIFIED VERSION STRING"));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
AboutDialogImpl::~AboutDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}


// Open browser slot.
void AboutDialogImpl::openBrowser()
{
    if (fork() == 0)
	execlp (browser, browser, "http://www.creaphys.de", 0);
}


// Open browser slot.
void AboutDialogImpl::openBrowserSunSite()
{
    if (fork() == 0)
	execlp (browser, browser, "http://www.sunsite.dk", 0);
}


// Local Variables:
// c-basic-offset: 4
// End:
