// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: Janusz SP9UMX <sp9umx@sr9zaa.ampr.org>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <stdlib.h>

#include <qfile.h>
#include <qapplication.h>
#include <qmessagebox.h>
#include <qlabel.h> 
#include <qfile.h>
#include <qdir.h>
#include <qprogressbar.h> 
//#include <qcstring.h>
#include <qmemarray.h> 

#include "AxGetMsg.h"
#include "utils.h"
//#include "shellex.h"
#include "event.h"
#include "AxUnit.h"
#include "statusw.h"
#include "llista.h"

#include "lzhuf.h"


#define MAXLENGTH 64000
#define NUL 0
#define SOH 1
#define STX 2
#define _EOT 4

extern TAxUnit AxU;
extern TUtils Util;
extern TList_window *List_window;
extern TStatus *StatusW;

// external variagles
extern FILE *FileDescriptor;
extern bool IsTelnet;
extern QString  Version;
extern int StatusByte;
extern int MsgIndex;         //{## amount of Msgs to 'axgetmsg' ##}
extern int MsgsToRead[200];  //{## Msgs marked to 'axgetmsg' ##}
extern idx_record idx_tmp;
extern QString  PrgPath;
extern QString  mycall;
extern int   lastnum;
extern bool  Killmymsg;


// lzhuf
//extern void lzhuf_init(short clu); /* normal clu=1 */
//extern void lzhuf_decode(unsigned long len, void *data, unsigned long plen);	// decompression
//extern unsigned short lzhuf_crc();
//extern void* lzhuf_data();
//extern long lzhuf_length();
//extern unsigned char *dataOut;

//TLZHuf lzhuf;

// Internal variables
//  QLabel *L_Status = StatusW->L_Status;
//  QLabel *L_Msg_Nr = StatusW->L_Msg_Nr;
//  QLabel *L_Msg_Title = StatusW->L_Msg_Title;
//  QProgressBar *progressBar1 = StatusW->progressBar1;

QMemArray<unsigned char> buf(MAXLENGTH);

//unsigned char **buf;
int bsize;


// go_7+.
//char header_7pl[7] = {' ', 'g', 'o', '_', '7', '+', '.'};
QString header_7pl = " go_7+.";


TAxGetMsg::TAxGetMsg()
{
   stopped = FALSE;
}


void TAxGetMsg::run()
{
   if (!stopped)  GetMsgEvent();
   stopped = FALSE;
}

void TAxGetMsg::stop()
{
  stopped = TRUE;
}

void  TAxGetMsg::UpdateStatus( int progress, int progressMax, QString L_Stat, QString L_MNr, QString L_MT, bool reset )
{
  StatusUpdateClass stt;
     
     stt.progress = progress;
     stt.progressMax = progressMax;
     stt.L_Stat = L_Stat;
     stt.L_MNr = L_MNr;
     stt.L_MT = L_MT;
     stt.reset = reset;
     
     StatUpdateEvent* stupd = new StatUpdateEvent( stt );
     QApplication::postEvent( StatusW, stupd );  // Qt will delete it when done
  
}



int TAxGetMsg::GetOneMessage()
{

  QString ofset;
  QString tmp;
  QString title;
  int eot;
  int ch;
  signed char sum,chksum;
  unsigned char flen;
  int i;
  int bpoz;
  int size;
  
  
//  L_Status->setText("Status : Downloading message" );
//  progressBar1->reset();
     UpdateStatus( 0,0,"Status : Downloading message","","",TRUE );


  size = 1;
  bpoz = 0;

//  *buf = (unsigned char *) malloc(sizeof(unsigned char) * size);

  ch = AxU.GetChar();
  if ( ch != SOH ) 
  {
//    L_Status->setText("Status : Cannot download this message");
    UpdateStatus( 0,0,"Status : Cannot download this message","","",FALSE );
    QMessageBox::information( List_window, "Title", "Cannot download this message" );
    return 3;
  }
  
  ch = AxU.GetChar();  // hd_length

//  L_Status->setText("Status : Transfer started");
    UpdateStatus( 0,0,"Status : Transfer started","","",FALSE );
  
  // read title 
  title = "";
  do
  {
    ch = AxU.GetChar();
    if ((ch != NUL) && (ch != 0x0A )) title += ch;
  } while ( ch != NUL );
//  L_Msg_Title->setText("Message Title : " + title);
    UpdateStatus( 0,0,"","","Message Title : " + title,FALSE );
  
  // read ofset
  ofset = "";
  do
  {
    ch = AxU.GetChar();
    if ((ch != NUL ) && (ch != 0x0A)) ofset += ch;
  } while (ch != NUL );


  // read data frames
  sum = 0;
  eot = 0;
  
  while (eot == 0)
  {
    //DataStream >> ch;
    ch = AxU.GetChar();

    if ( ch==STX ) 
    {
     flen = AxU.GetChar();
      if (flen == 0) flen=256;
      
      if (bpoz+flen >= size)
      {
        size += flen;
//	*buf=(unsigned char *) realloc(*buf, sizeof(unsigned char) * size);
      }
      
//      progressBar1->setTotalSteps( size );
//      progressBar1->setProgress( bpoz );
      UpdateStatus( bpoz,size,"","","",FALSE );
      
      i = 0;
      do
      {
        ch = AxU.GetChar();

	if (IsTelnet && ((ch == 0x0D) || (ch == 0xFF))) AxU.GetChar(); //Skip char - read next;
	buf[bpoz] = ch;
	bpoz++;
	sum += ch;
	i++;
      } while (i<flen);
    } // if (ch==STX)
    else
    {
      if ( ch== _EOT)
      {
	chksum = AxU.GetChar();

	if ((chksum + sum != 0) && ( ! ((chksum == -128) && (sum == -128))))
	{
//	   L_Status->setText("Status : Checksum error !");
           UpdateStatus( 0,0,"Status : Checksum error !","","",FALSE );
	   return 1;
	}
	eot = 1;
      }
      else
      {
//         L_Status->setText("Status : Unexpected character !");
         UpdateStatus( 0,0,"Status : Unexpected character !","","",FALSE );
	 return 2;
      }
    }
  } // while (eot == 0)
  AxU.WaitFor(">");
  
  bsize = bpoz;
  return 0;
}

void  TAxGetMsg::SendTag( )
{
   QString tmp;
   
   tmp = "[UMX-"+Version+"$]";
   AxU.SendCommands( tmp );
}

void  TAxGetMsg::SendRequest( int num)
{
  AxU.SendCommands( "F< " + QString::number( num ));
}

void  TAxGetMsg::DeleteMessage( int num )
{
  AxU.SendCommands( "K " + QString::number( num ));
}


void TAxGetMsg::GetMsgEvent()
{
   int i,j;
   unsigned long k;
   int msgnum;
   int test;
   QString subj;
   QString tmp;
   unsigned long clen,dlen;
   bool mymsg;
   int indx;
   QFile fl;
 
   
   StatusW->show();
     
   UpdateStatus( 0,0,"","Message nr : ","Message Title : ",FALSE );
   
   lzhuf_init(1);
   dlen = 0;
   
   UpdateStatus( 0,0,"Status : Connecting ...","","",FALSE );
   
   if (AxU.ConnectBBS())
   {
     
     if (StatusByte == 6)
     {
       AxU.DiscBBS();
       return;
     }
   
     SendTag();

     UpdateStatus( 0,0,"Status : Sending command ...","","",FALSE );

     if (StatusByte == 6)
     {
       AxU.DiscBBS();
       return;
     }

     AxU.WaitFor(">");
     
     if (StatusByte == 6)
     {
       AxU.DiscBBS();
       return;
     }
     
     j=1;
     while (j<= MsgIndex)
     {
       msgnum = MsgsToRead[j];
       
       UpdateStatus( 0,0,"","Message nr : " + QString::number( msgnum ),"",FALSE );

       
       SendRequest(msgnum);
       tmp = PrgPath + "control/" + QString::number( msgnum ) + ".id_";
       
       if (StatusByte == 6)
       {
         AxU.DiscBBS();
         return;
       }

       fl.setName( tmp );
       if (fl.exists() )
       {
         if (fl.open(IO_ReadOnly))
	 {
	   QTextStream stream (&fl);
	   tmp = stream.readLine();

           UpdateStatus( 0,Util.substring('i','S',tmp).toInt(),"","","",FALSE );

	   if (Util.substring('i','T',tmp).stripWhiteSpace().lower() == mycall.lower()) mymsg = TRUE; else mymsg = FALSE;
	   fl.close();
	 }
       }
         
       i = GetOneMessage();
       if (i==0)
       {
         clen = ((buf[3]*256 + buf[2])*256 + buf[1])*256 + buf[0];

         UpdateStatus( 0,0,"Status : Decompressing message ...","","",FALSE );
	 
	 lzhuf_decode( clen, &buf.at(4), bsize-4);
	   
	 dlen = lzhuf_length();
	 const QString data((char *)(lzhuf_data()));
	 
	 indx = data.find(header_7pl,0,FALSE);
  
	 if (indx > 0)  // !=
	 {
	   tmp  = data[indx+8];
	   tmp += data[indx+9];
	   tmp += data[indx+10];
	   test = tmp.toInt();
	   tmp = PrgPath + "7plus/";
	   k = indx + 19;
	   do
	   {
	     tmp += data[k];
	     k++;
	   } while ((data[k]!='.') && (k<(unsigned long)(indx+27)));
	   tmp += ".p";
	   tmp += test<16 ? "0":"";
	   tmp += QString("%1").arg(test,0,16).lower();
	     
	   fl.setName(PrgPath+"mail/"+QString::number(lastnum));
	   if (fl.open(IO_WriteOnly))
	   {
	     QTextStream stream (&fl);
	     stream << "7plus file : " << tmp << " has been stored";
	     fl.close();
	   }
	 }
	 else  // if (indx != 0)
	 {
	   tmp = PrgPath + "mail/" + QString::number(lastnum);
	 }
       
       fl.setName(tmp);
       if (fl.open(IO_WriteOnly))
       {
         QTextStream stream (&fl);
	 stream.writeRawBytes(data,dlen);
         fl.close();
       }
       
       QDir d (PrgPath+"control/");
       d.rename(QString::number(msgnum)+".id_",QString::number(lastnum)+".idx");     
       Util.IncLastNum();
       
       if (Killmymsg && mymsg)
       {
         DeleteMessage(msgnum);
	 AxU.WaitFor(">");
       }
     }   // if (i==0)
     else
     {
        AxU.WaitFor(">");
	if (StatusByte == 6)
	{
	   AxU.DiscBBS();
	   return;
	}  
       QDir d (PrgPath+"control/");	 
       d.rename(QString::number(msgnum)+".id_",QString::number(msgnum)+".err");     
     }  // if (i==0) else
    
    j ++;
   } //while (j<=MsgIndex)
   
   AxU.DiscBBS();
   lzhuf_free();
  } //if (AxU.ConnectBBS())
  else
  {
     QMessageBox::critical( List_window, "Connection error",  "Cannot connect to BBS" );
  } //if (AxU.ConnectBBS()) else
  
  StatusW->hide();
  stopped = TRUE;
}


