#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "lightlab.h"


void
on_exit_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  gtk_main_quit ();
}

void
on_about_activate (GtkMenuItem *menuitem, gpointer user_data)
{
  about_dialog (TRUE);
}

void
on_light_check1_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  enable_light (0, gtk_toggle_button_get_active (togglebutton));
}


void
on_light_check2_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  enable_light (1, gtk_toggle_button_get_active (togglebutton));
}


void
on_light_check3_toggled (GtkToggleButton *togglebutton, gpointer user_data)
{
  enable_light (2, gtk_toggle_button_get_active (togglebutton));
}

void
on_reset1_clicked (GtkButton *button, gpointer user_data)
{
  reset_light (0);
}

void
on_reset2_clicked (GtkButton *button, gpointer user_data)
{
  reset_light (1);
}

void
on_reset3_clicked (GtkButton *button, gpointer user_data)
{
  reset_light (2);
}

void
on_reset4_clicked (GtkButton *button, gpointer user_data)
{
  reset_light (3);
}

void
on_about_ok_clicked (GtkButton *button, gpointer user_data)
{
  about_dialog (FALSE);
}
