/* OS/2 REXX */
/* 
   ble.cmd
   $Id: ble.cmd,v 1.5 2001/11/12 20:13:46 amai Exp $

   Tool to build Xbae, Xlt, Xm test examples from within the
   LessTif source tree with OS/2 EMX.
*/

TRUE=1
FALSE=0

DoDebug=FALSE

Parse Arg param

if param="" then
   do
   say "ble.cmd: No argument"
   exit 0
   end
else
   param=Strip(param)

/* configuration */
CC="gcc"
CXX="gcc"
DEBUG="-g"
CFLAGS="-Zmt -O0 -Wall -W"
CXXFLAGS="-Zmt -O0 -Wall -W"
LDFLAGS="-Zmt -Zcrtdll -Zbsd-signals"


if right(param,2)=".c" then
   do
   base = Left(param, lastpos(".c", param)-1)
   end
else
   do
   base = param
   end

srcfile    = base".c"
objectfile = base".o"
exefile    = base".exe"

curdir = directory()

if Pos("Xlt", curdir)>0 then
   tree = "Xlt"
else if Pos("Xbae", curdir)>0 then
   tree = "Xbae"
else if Pos("Xm-2.1", curdir)>0 then
   tree = "Xm-2.1"
else if Pos("Xm-2.0", curdir)>0 then
   tree = "Xm-2.0"
else if Pos("Xm", curdir)>0 then
   tree = "Xm"
else if Pos("Mrm-2.1", curdir)>0 then
   tree = "Mrm-2.1"
else if Pos("Mrm-2.0", curdir)>0 then
   tree = "Mrm-2.0"
else if Pos("Mrm", curdir)>0 then
   tree = "Mrm"
else if Pos("Uil-2.1", curdir)>0 then
   tree = "Uil-2.1"
else if Pos("Uil-2.0", curdir)>0 then
   tree = "Uil-2.0"
else if Pos("Uil", curdir)>0 then
   tree = "Uil"
else
   do
   say "Unknown source tree. Exiting."
   exit 1
   end
 


if DoDebug then
   do
   say "param:"param
   say "base:"base
   say "tree:"tree
   end
   
x11root = Value("X11ROOT",,"OS2ENVIRONMENT")
if DoDebug then
   say "X11ROOT="x11root

if tree="Xbae" then
   do
   includes = "-I. -I../../include -I../../../../include/Motif-2.0  -I../../../../include/Motif-1.2"  
   libs     = "-L../../src -lXbae -L../../../lib/Xm-2.0 -lXm"
   end
else if tree="Xlt" then
   do
   includes = "-I. -I../../lib  -I../../../../include/Motif-2.0  -I../../../../include/Motif-1.2"  
   libs     = "-L../../lib -lXlt -L../../../lib/Mrm-2.0 -lMrm -L../../../lib/Xm-2.0 -lXm"  
   end
else if tree="Xm-2.1" then
   do
   includes = "-I. -I../../../include/Motif-2.1 -I../../../include/Motif-2.0  -I../../../include/Motif-1.2 -I../../../lib"
   libs     = "-L../../common -lLtTest -L../../../lib/Xm-2.0 -lDtPrint -L../../../lib/Xm-2.1 -lXm_21"
   end
else if tree="Xm-2.0" then
   do
   includes = "-I. -I../../../include/Motif-2.0  -I../../../include/Motif-1.2 -I../../../lib"
   libs     = "-L../../common -lLtTest -L../../../lib/Xm-2.0 -lXm_20"
   end
else if tree="Xm" then
   do
   includes = "-I. -I../../../include/Motif-1.2 -I../../../lib"
   libs     = "-L../../common -lLtTest -L../../../lib/Xm -lXm_12"  
   end
else
   do
   includes = "-I. -I../../../include/Motif-1.2 -I../../../lib"
   libs     = "-L../../common -lLtTest -L../../../lib/Xm -lXm_12"  
   end

/* Add non-LessTif libs */
libs = libs" -L"x11root"/Xfree86/lib -lXp -lXext -lXt -lX11"

/* execute the commands */
CC CFLAGS   DEBUG "-c -o "objectfile  includes  srcfile
CC LDFLAGS  DEBUG "   -o "exefile               objectfile  libs

exit 0



/* FileExists 
   returns 1 if a given File exists
*/

FileExists: Procedure
Parse Arg is_file
rs = Stream(is_file, 'C', 'QUERY EXISTS')
if rs == "" then
  return 0
else
  return 1
