#include "mg_rr.h"

namespace ADNS {

	MG_RR::MG_RR()
	{
		rr_type = RR_TYPE::MG;
		mgmname = gcnew DOMAIN_NAME();
		UpdateRdata();
	}

	Void MG_RR::SetMgmname(DOMAIN_NAME^ newname)
	{
		mgmname = gcnew DOMAIN_NAME(newname->GetName());
		UpdateRdata();
		return;
	}

	DOMAIN_NAME^ MG_RR::GetMgmname()
	{
		return mgmname->Clone();
	}

	String^ MG_RR::Print()
	{
		return mgmname->Print();
	}

	Void MG_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(mgmname->GetName()->Length);
		else
			rdata->Resize(rdata,mgmname->GetName()->Length);

		mgmname->GetName()->CopyTo(rdata,0);

		return;
	}

	Void MG_RR::ToCanonical()
	{
		mgmname->MakeCanonical();
		owner->MakeCanonical();
		UpdateRdata();
		return;
	}

	MG_RR^ MG_RR::Clone()
	{
		MG_RR^ newrr = gcnew MG_RR();
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->mgmname = mgmname->Clone();
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ MG_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		MG_RR^ mgout;
		array<Byte>^ tmparray;
		int reallen;

		mgout = gcnew MG_RR();
		mgout->owner = gcnew DOMAIN_NAME(domainname);
		mgout->rr_class = (RR_CLASS) rr_class;
		mgout->ttl = ttl;
		tmparray = ReadDomainFromPacket(packet, rdata_start, reallen);
		mgout->SetMgmname(gcnew DOMAIN_NAME(tmparray));
		return mgout;
	}

	String^ MG_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<MG_RR^>(rec)->Print();
	}

	ResourceRecord^ MG_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<MG_RR^>(rec)->Clone();
	}
}