<?php 

/*
                    Generic  LDAP  Client  Tool
  _    ____   ___  ____    ____ _   _ ____  _     ___  ____   ____ ____
 | |  |  _ \ / _ \   _ \  |  __\ \/ /   _ \  |   / _ \   _ \ |  __   _ \
 | |  | | \ | |_| | |_) ) | |_  \/ / | |_) ) |  | | | | |_) )| |_ | |_) )
 | |__| |_/ |  _  |  __/  | |__ / /\ |  __/  |__| |_| |  _ / | |__|  _ /
 |_________/ _| |_ _|     |____/_/\_\ _|   |____ \___/ _| \_\ ____ _| \_\


 File:          submit.php
 LDAPExplorer:  Copyright (c) 1999, 2000, 2001 Terrence Miao
 Version:       1.17
 Author:        Terrence Miao <terrence_miao@email.com>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU Public License along 
 with this package; if not, write to the Free Software Foundation, 
 Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 Change Log:

    2001.03.23  - fix a bug that certain characters have special significance 
                  in HTML, e.g. '&', '"', '<', '>' can not be displayed correctly 
                  in "detail" window
                  reported by Thierry Cornilleau <Thierry.Cornilleau@France.Sun.COM>

    2001.01.11  - split right frame into right top and right bottom
                  frames. Display entry details in the top; displaying
                  action buttons in the bottom.

	2000.11.16	- fix a bug that in latest version of PHP 4.0.3p1 
				  can get correct binary value from $attrs[$attribute]
                - rename files from *.php3 to *.php

    2000.03.17  - fix a minor bug that Netscape Directory Server will 
                  return "Unable to bind to server" if $bindpw is empty

    2000.03.13  - cascading Style Sheet support added
                - rename DN feature added

    2000.03.03  - fix a bug caused by value of attribute can be NULL
                  in Netscape Directory Server while delete a 
                  attribute (multi valued)

    2000.02.29  - fix bug that caused by new attribute called "info"
                  reported by Ilkka Torvinen <ilkka.torvinen@nettipaja.fi>

    1999.10.20  - .png image file format support

 */


require ("template/header.inc");

require ('default.php');

/* row number count on attribute to be modified, added and deleted */
$rownumber = 0;

/* return value of ldap add/delete/modify/rename */
$r = 0;

/* PHP version 4.0.4pl1 add character "\n" at the beginning of $ActionType
   cause LDAP Explorer can not find right action.
 */
$ActionType = trim ($ActionType);
// echo "actiontype = ...$ActionType...<BR>";

if (strcmp ($ActionType, "Add") == 0)
	$Add = "Add";
elseif (strcmp ($ActionType, "Rename") == 0)
	$Rename = "Rename";
elseif (strcmp ($ActionType, "Modify") == 0)
	$Modify = "Modify";
elseif (strcmp ($ActionType, "Delete") == 0)
	$Delete = "Delete";

// echo "Add = $Add<BR>";
// echo "Rename = $Rename<BR>";
// echo "Modify = $Modify<BR>";
// echo "Delete = $Delete<BR>";


$ds = ldap_connect ($host, $port);

if ($ds) {

    /* Netscape Directory Server will return "Unable to bind to server" if $bindpw is empty */
    if ((strcmp ($binddn, "") == 0) or (strcmp ($bindpw, "") == 0))
        $r = ldap_bind ($ds);
    else
        $r = ldap_bind ($ds, $binddn, $bindpw); 

    $sr = ldap_read ($ds, $dn, $filter);

    $entry = ldap_first_entry ($ds, $sr);

    $attrs = ldap_get_attributes ($ds, $entry);

    echo "<BR><BR>\n";

    echo "<CENTER>\n";

    echo "<TABLE width=98% cellspacing=0 cellpadding=0 border=0>\n";

    echo "<TR>";
    echo "<TD align=right valign=center nowrap><B><I>";
    echo "Distinguished Name" . " = &nbsp;&nbsp;</B></I></TD>";
    echo "<TD align=left valign=center><B>";

    if (isset ($Add) or isset ($Rename))
        echo $newdn;
    else
        echo $dn;

    echo "</B></TD></TR>\n";
    
    echo "<TR><TD><BR></TD></TR>\n";

    /* if an entry has been changed */
    $entry_changed = 0;

    unset ($info);

    for ($i = 0; $i < $attrs["count"]; $i++) {

        $attribute = $attrs[$i];

        /* skip these attributes, Directory Server will modify them */
        /* They are the stadard attributs */
        if (strstr ($attribute, "creatorsname")) 
            continue;
        if (strstr ($attribute, "createtimestamp"))
            continue;
        if (strstr ($attribute, "modifiersname"))
            continue;
        if (strstr ($attribute, "modifytimestamp"))
            continue;

        /* if a multi-valued attribute has been changed */
        $mval_changed = 0;

        unset ($tmpinfo);

		// echo "attribute = $attribute<BR>";
		// $countee = $attrs[$attribute]["count"];
		// echo "attribute count = $countee<BR>";

		/* latest version of PHP found in 4.0.3p1 */
		/* can NOT get correct binary value from $attrs[$attribute] */
		// $attributevalue = $attrs[$attribute];
		$attributevalue = ldap_get_values_len ($ds, $entry, $attribute);

        for ($j = 0; $j < $attrs[$attribute]["count"]; $j++) {

            /* if an attribute value has been changed */
            $thisval_changed = 0;

            if ($j != 0) 
                $name = $attribute . ";" . $j;
            else
                $name = $attribute;

            $name =$default->prefix_submit . $name;
            // echo "name = $name<BR>";

			/* latest version of PHP found in 4.0.3p1 */
			/* can NOT get correct binary value from $attrs[$attribute] */
            // $value = $attrs[$attribute][$j];
			$value = $attributevalue[$j];
            $inputvalue = $$name;
            // echo "value = $value<BR>";
            // echo "inputvalue = $inputvalue<BR>";

            if (strstr ($attribute, ";jpeg") or strstr ($attribute, ";jpg") or strstr ($attribute, ";jpe") or strstr ($attribute, ";gif") or strstr ($attribute, ";png")) {
                if (isset ($Modify) or isset ($Add) or isset ($Rename)) {

                    $defaultname = "default-" . $name;

                    /* user wants to delete this attribute */
                    if (strlen ($$defaultname) == 0) {

                        $value = "";
                        $inputvalue = "";

                        $thisval_changed = 1;

                        if ($attrs[$attribute]["count"] != 1)
                            $mval_changed = 1;
                    }
                    elseif (strcmp ($$name, "none") != 0) {

                        /* user wants to upload new graphic files */
                        $filetype = $name . "_type";

                        if (strstr ($attribute, ";jpeg") or strstr ($attribute, ";jpg") or strstr ($attribute, ";jpe"))
                            $mimetype = "image/jpeg";
                        elseif (strstr ($attribute, ";gif"))
                            $mimetype = "image/gif";
                        elseif (strstr ($attribute, ";png"))
                            $mimetype = "image/png";
            
                        /* if it's a valid format graphic file */
                        if (strcmp ($$filetype, $mimetype) != 0) {

                            echo "</TABLE>\n";
                            echo "<FONT size=4 face=\"Verdana,Geneva,Arial,Helvetica,Sans-serif\"><B>";
                            echo "<FONT color=FF0000>Wrong type of the upload file!<br>"; 
                            echo "Are you sure ";
                            echo "\"" . $name . "\" is " . $mimetype;
                            echo "?</FONT>";
                            echo "</B></FONT>";

                            require ("template/footer.inc");

                            return;
                        }

                        /* get the upload filename */
                        $filename = $name . "_name";
                        $inputvalue = $$filename;

                        $fp = fopen ($$name, "r");
                        $value = fread ($fp, filesize ($$name));
                        fclose ($fp);

                        $thisval_changed = 1;

                        if ($attrs[$attribute]["count"] != 1)
                            $mval_changed = 1;
                    }
                    else {
                        /* temporary filename still in inputting field, no upload file */
                        if (isset ($Modify)) {
                            /* single-valued attribute, no change in Modify next loop */
                            if ($attrs[$attribute]["count"] == 1)
                                continue;
                        }
                        elseif (isset ($Add) or isset ($Rename)) {
                            $inputvalue = "Picture is too large to display";
                            $thisval_changed = 1;

                            if ($attrs[$attribute]["count"] != 1)
                                $mval_changed = 1;
                        }
                    }
                } /* end of if (isset ($Modify) or isset ($Add) or isset ($Rename)) */
                else {
                    /* action is Delete */
                    $inputvalue = "Picture is too large to display";
                    $thisval_changed = 1;
                }
            }
            else {
                /* NOT MIME type data */
                /* if attribute value is ascii */
                $isascii = 1;

                for ($k = 0; $k < strlen ($value); $k++) {
                    $chstr = substr ($value, $k, 1);
                    if ((ord ($chstr) < 20) or (ord ($chstr) > 126)) {
                        $isascii = 0;
                        break;
                    }
                }

                if (isset ($Add) or isset ($Rename) or isset ($Delete))
                    $thisval_changed = 1;
                elseif (isset ($Modify)) {
                    if ($isascii == 0) {
                        if (strcmp (base64_encode ($value), $inputvalue) != 0)
                            $thisval_changed = 1;
                    }
                    else {
                        if (strcmp ($value, $inputvalue) != 0)
                            $thisval_changed = 1;
                    }

                    /* single-valued attribute, no change in Modify next loop */
                    if ($thisval_changed == 0) {
                        if ($attrs[$attribute]["count"] == 1)
                            continue;
                    }
                }

                if (($attrs[$attribute]["count"] != 1) and ($thisval_changed == 1))
                    $mval_changed = 1;
                
                /* set value to inputting value */
                $value = $$name;

                /* change user's password, default encode type is crypt() */
                if (strstr ($attribute, "userpassword")) {
                    if (!strstr ($value, "{crypt}")) {
                        if (strlen ($value) != 0)
                            $value = "{crypt}" . crypt ($value);
                    }

                    $inputvalue = "";
                    for ($k = 0; $k < strlen ($value); $k++)
                        $inputvalue = $inputvalue . "*";
 
                    /* Wrong with MD5 algorithm at present */
                    // $value = "{md5}" . md5 ($value);
                }

            } /* end of non-mime type data */
 
            if (($thisval_changed == 1) or ($mval_changed == 1))
                $entry_changed = 1;

            /* following code will delete attribute which inputting value set to null. To Netscape Directory Server, attribute can be set to NULL; OpenLDAP dosen't */ 

            /* multi-valued attribute */
            if ($attrs[$attribute]["count"] != 1) {

                if (isset ($Add) or isset ($Rename)) {
                    if ($j == 0)
                        $counter = 0;

                    if (strcmp ($value, "") != 0)
                        $info[$attribute][$counter++] = $value;
                }
                elseif (isset ($Modify)) {
                    if ($j == 0)
                        $counter = 0;

                    if (strcmp ($value, "") != 0) {
                        $tmpinfo[$attribute][$counter++] = $value;
                    }

                    /* until all the values of a multi-valued attribute has been assigned to $tmpinfo */
                    if (($j == ($attrs[$attribute]["count"] - 1)) and ($mval_changed == 1)) {
                        if ($counter == 0) {
                            for ($k = 0; $k <= $j; $k++) 
                                $attrs_del["$attribute"][$k] = $attrs["$attribute"][$k];
                            $ret = ldap_mod_del ($ds, $dn, $attrs_del);

                            if ($ret == 1)
                                $r = 1;
                        }
                        elseif ($counter == 1) {
                            $info[$attribute] = $tmpinfo[$attribute][0];
                        }
                        else {
                            for ($k = 0; $k < $counter; $k++) 
                                $info[$attribute][$k] = $tmpinfo[$attribute][$k];
                        }
                    } /* end of if ($j == ($attrs[$attribute]["count"] - 1) */
                } /* end of action is Modify */
            } /* end of if ($attrs[$attribute]["count"] != 1) */
            else {
                /* single-valued attribute */

                if (strcmp ($value, "") == 0) {
                    if (isset ($Modify) or isset ($Add) or isset ($Rename)) {
                        $attrs_del["$attribute"] = $attrs["$attribute"][0];
                        $ret = ldap_mod_del ($ds, $dn, $attrs_del);

                        if ($ret == 1)
                            $r = 1;
                    }
                }
                else {
                    if ($thisval_changed == 1)
                        $info[$attribute] = $value;
                }
            } /* end of single-valued attribute */

            /* no value changed no display changed info */
            if ($thisval_changed == 0) 
                continue;

            /* if an attribute is changed, display new value */
            echo "<TR><TD align=right valign=center nowrap><B><I>";
            echo $attribute . " = &nbsp;&nbsp;</I></B></TD>";   
            echo "<TD align=left valign=center bgcolor=";
        
            $rownumber++;

            if (($rownumber % 2) == 0)
                echo "#EEEEFF";
            else
                echo "#DCDCDC";

            $wrapit = 0;
            if ($isascii == 0) {
                $wrapit = 1;
            }
            elseif (strlen ($inputvalue) > $default->maxdisplaylen) {
                if (!strstr ($inputvalue, " "))
                    $wrapit = 1;
            }

            if ($wrapit == 1) {
                echo "><PRE>";
            
                for ($k = 0; $k < strlen ($inputvalue) / $default->maxdisplaylen; $k++) {
                    if ($k != 0)
                        echo "<BR>";

                    $reststr = substr ($inputvalue, $k * $default->maxdisplaylen, $default->maxdisplaylen);
                    echo $reststr;
                }

                $reststr = substr ($inputvalue, $k * $default->maxdisplaylen, strlen ($inputvalue) % $default->maxdisplaylen);
                echo ($reststr);

                echo "</PRE>";
            }
            else {
                echo " wrap>";

                if (strlen ($inputvalue) == 0)
                    echo "&nbsp;";
                else
                    echo $inputvalue;
            }

            echo "</TD></TR>\n";
        }
    }


    unset ($errormsg);
    unset ($returnmsg);

    if ($entry_changed == 0) {
        $r = 1;
        $returnmsg = "No change in LDAP Server!";
    }
    elseif (isset ($Add)) {

        if (strcmp ($dn, $newdn) != 0) {

            $r = ldap_add ($ds, $newdn, $info);

            if ($r != 1) 
                $errormsg = "Add new entry failed! Check your Bind DN/Password, inputting and try again.";
            else
                $returnmsg = "Entry has been added to LDAP Server successfully!";
        }
        else 
            $errormsg = "Same Distinguished Name. Add entry failed!";
    }
    elseif (isset ($Modify)) {

        if (count ($info) != 0)
            $r = ldap_modify ($ds, $dn, $info);

        if (($r != 1) and ($entry_changed == 1))
            $errormsg = "Modify entry failed! Check your Bind DN/Password, inputting and try again.";
        else {
            $r = 1;
            $returnmsg = "Entry has been modified successfully!";
        }
    }
    elseif (isset ($Delete)) {
        $r = ldap_delete ($ds, $dn);

        if ($r == 1)
            $returnmsg = "Entry has been deleted successfully!";
        else
            $errormsg = "Delete entry failed! Check your Bind DN/Password, inputting and try again.";
    }
    elseif (isset ($Rename)) {
        if (strcmp ($dn, $newdn) != 0) {

            $r = ldap_delete ($ds, $dn);

            if ($r != 1)
                $errormsg = "Delete entry failed while renaming! Check your Bind DN/Password, inputting and try again.";
            else {
                $r = ldap_add ($ds, $newdn, $info);

                if ($r != 1) 
                    $errormsg = "Add entry failed while renaming! Check your Bind DN/Password, inputting and try again.";
                else
                    $returnmsg = "Entry has been renamed successfully!";
            }
        }
        else 
            $errormsg = "Same Distinguished Name. Rename an entry failed!";
    }

    if (isset ($errormsg)) {

        echo "</TABLE>\n";
        echo "</CENTER>\n";
    
        echo "<BR><BR>\n";
        echo "<CENTER>\n";
        echo "<font size=4 face=\"Verdana,Geneva,Arial,Helvetica,Sans-serif\"><B>";

        if (isset ($returnmsg)) 
            echo $returnmsg;
        if (isset ($errormsg))
            echo "<FONT color=#FF0000>" . $errormsg . "</FONT>"; 

        echo "</B></FONT>\n";
        echo "</CENTER>\n";
        echo "<BR><BR><BR>\n";
    }

    // echo "r = $r<BR>";
    // echo "Modify = $Modify<BR>";
    // echo "Add = $Add<BR>";
    // echo "Rename = $Rename<BR>";

    if ($r == 1) {

        if (isset ($Modify) or isset ($Add) or isset ($Rename)) {

            unset ($r);

            /* Add new attributes and values */
            for ($n = 0; $n < $default->newattrnum; $n++) {
                $attrname = "newattr" . $n;
                $attrvalue = "attrvalue" . $n;
                $attrbinvalue = "attrbinvalue" . $n;
                // echo "attrname = $attrname<BR>";
                // echo "attrvalue = $attrvalue<BR>";
                // echo "attrbinvalue = $attrbinvalue<BR>";
				$content = trim ($$attrname);
                // echo "attrname content = ...$content...<BR>";
				$length = strlen (trim ($$attrname));
                // echo "attrname length = ...$length...<BR>";
				$content = trim ($$attrvalue);
                // echo "attrvalue content = ...$content...<BR>";
				$length = strlen (trim ($$attrvalue));
                // echo "attrvalue length = ...$length...<BR>";
				$content = trim ($$attrbinvalue);
                // echo "attrbinvalue content = ...$content...<BR>";
				$length = strlen (trim ($$attrbinvalue));
                // echo "attrbinvalue length = ...$length...<BR>";

                if ((strlen (trim ($$attrname)) != 0) and ((strlen (trim ($$attrvalue)) != 0) or (strlen (trim ($$attrbinvalue)) != 0))) {

                    $attribute = trim ($$attrname);
                    $value = trim ($$attrvalue);
                    $binvalue = trim ($$attrbinvalue);

                    if (strlen (trim ($$attrvalue)) != 0) {
                    
                        $inputvalue = trim ($$attrvalue);

                        if (strcmp (strtolower ($attribute), "userpassword") == 0) {
                            $value = "{crypt}" . crypt ($value);

                            $inputvalue = "";
                            for ($i = 0; $i < strlen ($value); $i++)
                                $inputvalue = $inputvalue . "*";
                        }
                    }
                    elseif (strlen (trim ($$attrbinvalue)) != 0) {
                        
                        $filename = $attrbinvalue . "_name";
                        $inputvalue = $$filename;

                        if (strstr ($attribute, ";jpeg") or strstr ($attribute, ";jpg") or strstr ($attribute, ";jpe") or strstr ($attribute, ";gif") or strstr ($attribute, ";png")) {

                            $filetype = $attrbinvalue . "_type";

                            if (strstr ($attribute, ";jpeg") or strstr ($attribute, ";jpg") or strstr ($attribute, ";jpe"))
                                $mimetype = "image/jpeg";
                            elseif (strstr ($attribute, ";gif"))
                                $mimetype = "image/gif";
                            elseif (strstr ($attribute, ";png"))
                                $mimetype = "image/png";

                            if (strcmp ($$filetype, $mimetype) != 0) {

                                echo "</TABLE>\n";
                                echo "<BR><BR>\n";
                                echo "<FONT size=4 face=\"Verdana,Geneva,Arial,Helvetica,Sans-serif\"><B>";
                                echo "<FONT color=#FF0000>Wrong type of the upload file!<BR>"; 
                                echo "Are you sure ";
                                echo "\"" . $$filename . "\" is " . $mimetype;
                                echo "?</FONT>";
                                echo "</B></FONT>";

                                require ("template/footer.inc");

                                return;
                            }
                        }

                        $fp = fopen ($$attrbinvalue, "r");
                        $value = fread ($fp, filesize ($$attrbinvalue));
                        fclose ($fp);
                    }

                    if (isset ($Add) or isset ($Rename))
                        $sr = ldap_read ($ds, $newdn, $filter);
                    else
                        $sr = ldap_read ($ds, $dn, $filter);

                    $entry = ldap_first_entry ($ds, $sr);
                    $attrs = ldap_get_attributes ($ds, $entry);


                    /* latest version of PHP found in 4.0.3p1 */
                    /* can NOT get correct binary value from $attrs[$attribute] */
                    // echo "attrs = $attrs<BR>";
                    // echo "attribute = $attribute<BR>";
                    $attributevalue = $attrs[$attribute];
					// if attribute is empty, PHP returns error while call ldap_get_values_len ()
					if (strlen ($attributevalue) != 0) {
                    	$attributevalue = ldap_get_values_len ($ds, $entry, $attribute);
					}

                    unset ($info);

                    for ($i = 0; $i < $attrs[$attribute]["count"]; $i++) 
                        /* latest version of PHP found in 4.0.3p1 */
                        /* can NOT get correct binary value from $attrs[$attribute] */
                        // $info[$attribute][$i] = $attrs[$attribute][$i];
                        $info[$attribute][$i] = $attributevalue[$i];

                    if ($i == 0)
                        $info[$attribute] = $value;
                    else
                        $info[$attribute][$i] = $value;

                    echo "<TR><TD align=right valign=center nowrap><B><I>";
                    echo $attribute . " = &nbsp;&nbsp;</I></B></TD>";    
                    echo "<TD align=left valign=center bgcolor=";
        
                    $rownumber++;

                    if (($rownumber % 2) == 0)
                        echo "#EEEEFF";
                    else
                        echo "#DCDCDC";

                    echo ">";

                    $wrapit = 0;
                    if (strlen ($inputvalue) > $default->maxdisplaylen) {
                        if (!strstr ($inputvalue, " "))
                            $wrapit = 1;
                    }

                    if ($wrapit == 1) {
                        echo "<PRE>";
            
                        for ($i = 0; $i < strlen ($inputvalue) / $default->maxdisplaylen; $i++) {
                            if ($i != 0)
                                echo "<BR>";

                            $reststr = substr ($inputvalue, $i * $default->maxdisplaylen, $default->maxdisplaylen);
                            echo $reststr;
                        }

                        $reststr = substr ($inputvalue, $k * $default->maxdisplaylen, strlen ($inputvalue) % $default->maxdisplaylen);
                        echo ($reststr);

                        echo "</PRE>";
                    }
                    else
                        echo $inputvalue;
        
                    echo "</TD></TR>\n";

                    $r = 0;

                    if (isset ($Add) or isset ($Rename)) {
                        $r = ldap_modify ($ds, $newdn, $info);

                        if ($r != 1) {
                            $errormsg = "Add New Attribute failed! Check your Bind DN/Password, inputting and try again.";
                            break;
                        }
                        else
                            $returnmsg = "Entry has been added to LDAP Server successfully!";
                    }
                    else {
                        $r = ldap_modify ($ds, $dn, $info);

                        if ($r != 1) {
                            $errormsg = "Add New Attribute failed! Check your Bind DN/Password, inputting and try again.";
                            break;
                        }
                        else
                            $returnmsg = "Entry has been modified successfully!";
                    }
                }
            }
        }

        echo "</TABLE>\n";
        echo "</CENTER>\n";

        echo "<BR><BR>\n";
        echo "<CENTER>\n";
        echo "<font size=4 face=\"Verdana,Geneva,Arial,Helvetica,Sans-serif\"><B>";

        if (!isset ($r))
            echo $returnmsg;
        else {
            if ($r != 1)
                echo "<FONT color=#FF0000>" . $errormsg . "</FONT>";
            else 
                echo $returnmsg;
        }

        echo "</B></FONT>\n";
        echo "</CENTER>\n";
        echo "<BR><BR><BR>\n";
    }

    ldap_unbind ($ds);
}

require ("template/footer.inc");

?> 
