/*
 * Copyright 2003 Silicon Graphics, Inc. All rights reserved.
 */
#include <kl_lib.h>
#include <kl_list.h>

/* This module provides support for doubly linked lists that can be
 * located any place in a structure. The list prev and next pointers 
 * are relative to the location of the list struct and not to the
 * start of the structure the list is part of. In addition to allowing
 * lists to be located anywhere in a structure, multiple lists within
 * the same structure is also possible.  Maros provide a means for 
 * adjusting the list pointer to the start of the actual structure.
 */

/*
 * list_add()
 */
void
list_add(list_type_t *list, list_type_t *new)
{
	if (!list->next || (list->next == list)) {
		list->next = list->prev = new;
		new->next = new->prev = list;
	} else {
		list->prev->next = new;
		new->next = list;
		new->prev = list->prev;
		list->prev = new;
	}
}

/*
 * list_remove()
 */
void
list_remove(list_type_t *item)
{
	if ((item->next == item) && (item->prev == item)) {
		/* This is the list head and there aren't any
		 * other elements on the list.
		 */
	}
}
