/*
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 *
 * Added support for X86_64 architecture Mar 2004
 *      Prashanth Tamraparni (prasht@in.ibm.com)
 *      Sachin Sant (sachinp@in.ibm.com)
 */

#ifndef __KL_MEM_X86_64_H
#define __KL_MEM_X86_64_H

#define KL_KSTACK_SIZE_X86_64        0x2000ULL
#define KL_VMALLOC_START_X86_64      0xffffff0000000000
#define KL_MODULE_START_X86_64	     0xffffffffa0000000

#define KL_PAGE_SHIFT_X86_64         12ULL
#define KL_PAGE_SIZE_X86_64          (1ULL << KL_PAGE_SHIFT_X86_64)
#define KL_PAGE_MASK_X86_64          (~(KL_PAGE_SIZE_X86_64-1))
#define KL_PAGE_OFFSET_X86_64        0x0000010000000000  /* 1 << 40 */
#define KL_START_KERNEL_map_X86_64   0xffffffff80000000

#define _PHYSICAL_MASK_X86_64        ((1UL << 40)-1)
#define KL_PHYSICAL_MASK_X86_64      ((KL_PAGE_MASK_X86_64) & \
                                      (_PHYSICAL_MASK_X86_64 << KL_PAGE_SHIFT_X86_64))

#define KL_PMD_BASE_MASK_X86_64      (~((1ULL<<12)-1))
#define KL_PT_BASE_MASK_X86_64       KL_PMD_BASE_MASK_X86_64
#define KL_PAGE_BASE_MASK_X86_64     KL_PMD_BASE_MASK_X86_64

/* Definitions for PAE ("36 bit addresses") In fact entries in page
 * dirs and page tables are 64 bit.
 */
#define KL_PML4_SHIFT_X86_64_PAE     39
#define KL_PML4_SIZE_X86_64_PAE      (1UL<<KL_PML4_SHIFT_X86_64)
#define KL_PML4_MASK_X86_64_PAE      (~(KL_PML4_SIZE_X86_64-1))

#define KL_PGDIR_SHIFT_X86_64_PAE    30
#define KL_PGDIR_SIZE_X86_64_PAE     (1ULL<<KL_PGDIR_SHIFT_X86_64_PAE)
#define KL_PGDIR_MASK_X86_64_PAE     (~(KL_PGDIR_SIZE_X86_64_PAE-1))

#define KL_PMD_SHIFT_X86_64_PAE      21
#define KL_PMD_SIZE_X86_64_PAE       (1ULL<<KL_PMD_SHIFT_X86_64_PAE)
#define KL_PMD_MASK_X86_64_PAE       (~(KL_PMD_SIZE_X86_64_PAE-1))

#define KL_PTRS_PER_PML4_X86_64_PAE  512
#define KL_PTRS_PER_PGD_X86_64_PAE   512
#define KL_PTRS_PER_PMD_X86_64_PAE   512
#define KL_PTRS_PER_PTE_X86_64_PAE   512

/* 2MByte Page translation */
#define KL_PSE_OFFSET_MASK_X86_64_PAE    ((1ULL << 21) - 1)
#define KL_PSE_PAGE_MASK_X86_64_PAE      (~KL_PSE_OFFSET_MASK_X86_64_PAE)

#define KL_PAGE_PRESENT_X86_64  0x001 
#define KL_PAGE_RW_X86_64	0x002 
#define KL_PAGE_USER_X86_64	0x004 
#define KL_PAGE_ACCESSED_X86_64	0x020 
#define KL_PAGE_DIRTY_X86_64	0x040 
#define KL_PAGE_PROTNONE_X86_64 0x080
#define KL_PAGE_PML4E_X86_64	0x080 

#define KL_KERNEL_PAGE_X86_64 (KL_PAGE_PRESENT_X86_64 | KL_PAGE_RW_X86_64 | \
			       KL_PAGE_ACCESSED_X86_64 | KL_PAGE_DIRTY_X86_64)

/* pgd/pmd/pte query functions */
#define kl_pml4_none_x86_64(x) (!x)
#define kl_pgd_none_x86_64(x) (!x)
#define kl_pgd_bad_x86_64(x) (x == 0)

#define kl_pmd_none_x86_64(x) (!x)
#define kl_pmd_bad_x86_64(x) ( ((x) & (~KL_PHYSICAL_MASK_X86_64 & ~KL_PAGE_USER_X86_64))\
			        != KL_KERNEL_PAGE_X86_64 )

#define kl_pte_present_x86_64(x) (x & \
		(KL_PAGE_PRESENT_X86_64 | KL_PAGE_PROTNONE_X86_64))
#define kl_pte_none_x86_64(x) (!x)

#define KL_KADDR_IS_PHYSICAL_X86_64(x) \
	( ((x < KL_MODULE_START_X86_64) && (x >= KL_START_KERNEL_map_X86_64) && \
           ((x-KL_START_KERNEL_map_X86_64) < (KL_HIGH_MEMORY - KL_PAGE_OFFSET))) || \
	  ((x < KL_VMALLOC_START_X86_64) && (x >= KL_PAGE_OFFSET) && \
	   ((x) < KL_HIGH_MEMORY)) \
	)

#define KL_DIRECT_MAPPING_X86_64(x) (x)>KL_START_KERNEL_map_X86_64? \
		((x)-KL_START_KERNEL_map_X86_64):((x)-KL_PAGE_OFFSET_X86_64)

#endif /* __KL_MEM_X86_64_H */
