/*
 * $Id: kl_types.h,v 1.1 2004/12/21 23:26:22 tjm Exp $
 *
 * This file is part of libklib.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 * Contributions by IBM, NEC, and others
 *
 * Copyright (C) 1999 - 2002 Silicon Graphics, Inc. All rights reserved.
 * Copyright (C) 2001, 2002 IBM Deutschland Entwicklung GmbH, IBM Corporation
 * Copyright 2000 Junichi Nomura, NEC Solutions <j-nomura@ce.jp.nec.com>
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */

#ifndef __ASMARM_KL_TYPES_H
#define __ASMARM_KL_TYPES_H

typedef signed char s8;
typedef unsigned char u8;

typedef signed short s16;
typedef unsigned short u16;

typedef signed int s32;
typedef unsigned int u32;

typedef signed long long s64;
typedef unsigned long long u64;

#include <kl_dump_arm.h>

//#define HOST_ARCH_ARM	/* host machine to execute lcrash is i386 */
#define HOST_ARCH_I386	/* host machine to execute lcrash is i386 */

/* Format string that allows a single fprintf() call to work for both
 * 32-bit and 64-bit pointer values (architecture specific).
 */
#define FMTPTR  "ll"
#define FMT64  "ll"

/* for usage in common code where host architecture
 * specific type/macro is needed
 */
typedef kl_dump_header_arm_t kl_dump_header_asm_t;
#define KL_DUMP_ASM_MAGIC_NUMBER KL_DUMP_MAGIC_NUMBER_ARM

#endif /* __ASMARM_KL_TYPES_H */
