/*
 * $Id: kl_pci.h,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libhwconfig.
 * A library which provides access to Linux system kernel dumps.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2003-2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_PCI_H
#define __KL_PCI_H

#include <kl_list.h>

typedef struct pciinfo_progif {
        struct pciinfo_progif	*next;
        struct pciinfo_progif	*prev;
        uint8_t                  progif_id;
        char                    *name;
        struct pciinfo_subclass *subclass; /* back pointer to subclass */
} pciinfo_progif_t;

typedef struct pciinfo_subclass {
        struct pciinfo_subclass	*next;
        struct pciinfo_subclass	*prev;
        uint8_t                  subclass_id;
        char                    *name;
	pciinfo_progif_t	*progifs; /* pointer to prog-if's */
        struct pciinfo_class    *class;   /* back pointer to class */
} pciinfo_subclass_t;

typedef struct pciinfo_class {
        struct pciinfo_class	*next;
        struct pciinfo_class	*prev;
        uint8_t                  class_id;
        char                    *name;
        pciinfo_subclass_t      *sub_classes;
} pciinfo_class_t;

typedef struct pciinfo_subsys {
        struct pciinfo_subsys   *next;
        struct pciinfo_subsys   *prev;
        short                    ven_id;
        short                    dev_id;
        char                    *name;
        struct pciinfo_dev      *device; /* back pointer to device */
} pciinfo_subsys_t;

typedef struct pciinfo_dev {
        struct pciinfo_dev      *next;
        struct pciinfo_dev      *prev;
        short                    dev_id;
        char                    *name;
        pciinfo_subsys_t        *subsystems;
        struct pciinfo_vendor   *vendor; /* back pointer to vendor */
} pciinfo_dev_t;

typedef struct pciinfo_vendor {
        struct pciinfo_vendor   *next;
        struct pciinfo_vendor   *prev;
        short                    ven_id;
        char                    *name;
        pciinfo_dev_t           *devices;
} pciinfo_vendor_t;

typedef struct pci_vendor_s {
	unsigned short   VenId;
	char 		*VenShortName;
	char 		*VenFullName;
} pci_vendor_t;

typedef struct pci_device_s {
	unsigned short   VenId;
	unsigned short   DevId;
	char 		*DevName;
	char 		*DevDesc;
} pci_device_t;

extern pci_vendor_t pci_vendor_list[];
extern int pci_vendor_count;
extern pci_device_t pci_device_list[];
extern int pci_device_count;

typedef struct pci_dev_s {
	list_type_t		 global_list;
	list_type_t		 bus_list;
	kaddr_t			 addr;   /* addr of pci_dev struct           */
	void			*ptr;    /* buffer containing pci_dev struct */
	unsigned int		 class;  /* (CLASS | SUBCLASS | program-if)  */
	unsigned short		 vendor;
	unsigned short		 device;
	unsigned char		 bus_num;
	unsigned char		 slot_num;
	unsigned char		 fun_num;
	struct pci_bus_s	*bus;
} pci_dev_t;
#define g_next global_list.next
#define g_prev global_list.prev
#define b_next bus_list.next
#define b_prev bus_list.prev

#define PCI_DEV_BASE_CLASS(c) (((c) >> 16)) & 0xff)
#define PCI_DEV_CLASS(c) (((c) >> 8)) & 0xffff)

typedef struct pci_bus_s {
	list_type_t		 bus_list;
	list_type_t		 bus_devices;
	int			 number; /* pci bus number */
	kaddr_t			 addr; /* addr of pci_bus struct */
	void			*ptr;  /* buffer containing pci_bus struct */
} pci_bus_t;

extern int pci_bus_count;
extern int pci_dev_count;
extern pci_bus_t *pci_buses;
extern pci_dev_t *pci_devices;

#define UNK_PCI_DEVNAME "UNKNOWN PCI DEVICE"

/* Function prototypes
 */
int kl_get_pci_info(void);
int kl_pci_init(void);


/*
 * find_pci_vendor()
 */
pci_vendor_t *find_pci_vendor(int);
pci_device_t *find_pci_device(int, int );
pci_dev_t *find_pci_dev(kaddr_t);

#endif /* __KL_PCI_H */
