/*
 * $Id: kl_swconfig.h,v 1.1 2004/12/21 23:26:20 tjm Exp $
 *
 * This file is part of libconfig.
 * A library which provides a framework for managing system hardware
 * and software configuration information.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef __KL_SWCONFIG_H
#define __KL_SWCONFIG_H

#define AFLG(f) (((f) & K_PERM) ? K_PERM : K_TEMP)

typedef struct sw_component_s {
	struct sw_component_s  *sw_next;
	struct sw_component_s  *sw_prev;
	int			sw_seq;
	char                   *sw_name;
	uint64_t                sw_sys_id;
	char                   *sw_description;
	char                   *sw_verstr;
	uint32_t                sw_version;
	int                     sw_key;
	time_t                  sw_install_time;
	time_t                  sw_deinstall_time;
	int                     sw_flags;
	int                     sw_state;
	int                     sw_level;
        int                     sw_open;
        struct swconfig_s      *sw_config;
} sw_component_t;

typedef struct swconfig_s {
        int                     s_flags;      /* K_PERM/K_TEMP, etc. */
        uint64_t                s_sys_id;     /* system ID */
        int                     s_sys_type;   /* IP type of system */
        time_t                  s_date;       /* if 0 then hwconfig current */
        sw_component_t         *s_swcmp_head; /* Head of sw_component list */
        int                     s_swcmp_cnt;  /* Number of items on list */
	int			s_level;      /* Depth level */
        string_table_t         *s_st;
} swconfig_t;

/**
 ** Function prototypes
 **/

void free_swcomponent(
	sw_component_t *	/* pointer to swcomponent to free */);

void free_swcomponents(
	sw_component_t *	/* head of swcomponent list */);

int add_swcomponent(
	swconfig_t * 		/* pointer to software control struct */,
	sw_component_t *        /* sw_component to add */);

sw_component_t *first_swcomponent(
	sw_component_t * 	/* pointer to sw_component */);

sw_component_t *next_swcomponent(
	sw_component_t *	/* pointer to sw_component */);

sw_component_t *prev_swcomponent(
	sw_component_t *	/* pointer to sw_component */);

sw_component_t *find_swcomponent(
	swconfig_t * 		/* pointer to software control struct */,
	char 	       *	/* key (name) */);

void unlink_swcomponent(
	sw_component_t *	/* pointer to sw_component to unlink */);

swconfig_t *alloc_swconfig(
	int			/* flag values */,
	int			/* depth level */);

void free_swconfig(
	swconfig_t *		/* pointer to swconfig_s struct */);

void update_swconfig(
	swconfig_t *		/* pointer to swconfig_s struct */);

#endif /* __KL_SWCONFIG_H */
