/*
 * $Id: alloc.h,v 1.1 2004/12/21 23:26:19 tjm Exp $
 *
 * This file is part of liballoc.
 * A library which provides memory allocation facilities.
 *
 * Created by Silicon Graphics, Inc.
 *
 * Copyright (C) 2004 Silicon Graphics, Inc. All rights reserved.
 *
 * This code is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef _ALLOC_H
#define _ALLOC_H

/* External function prototype
 */
int set_alloc_debug(int);

/* Flags that determine if a block is temp or perm. Note that these values
 * are the same as the KLIB flags K_TEMP and K_PERM. These defines are 
 * here so that applicatons using only the liballoc library need not 
 * include klib.h.
 */
#define B_FREE 0
#define B_TEMP 1
#define B_PERM 2

#define ALLOCFLG(flags) ((flags & B_PERM) ? B_PERM : B_TEMP)

/**
 ** block allocation operation function prototypes
 **/
void * alloc_block(
	int		/* size of block to allocate */, 
	int		/* flag (K_TEMP/K_PERM) */, 
	void *		/* return address */);


void * realloc_block(
	void *	    	/* pointer to block to reallocate */,
	int 		/* size of new block */,
	int         	/* flag (K_TEMP/K_PERM) */,
	void *		/* return address */);

void * dup_block(
	void *	    	/* pointer to block to dup */, 
	int		/* flag (K_TEMP/K_PERM) */,
	void *		/* return address */);

void * str_to_block(
	char *		/* pointer to string to copy */,
	int         	/* flag (K_TEMP/K_PERM) */,
	void *		/* return address */);

void free_block(
	void *	    /* address of block to free */);

void free_temp_blocks(void);

int is_temp_block(
	void *		/* address of block to check */);

#endif /* _ALLOC_H */
