/*
 * Copyright 2004 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>
#include "lc_unwind.h"
#include "unwind_i.h"

/* Function prototypes
 */
void unwind_usage(command_t *);
int unwind_ip(FILE *ofp, uint64_t ip);

/*
 * unwind_cmd() -- Run the 'unwind' command.
 */
int
unwind_cmd(command_t *cmd)
{
	int i, mode;
	uint64_t ip;

	if (cmd->nargs == 0) {
		fprintf(KL_ERRORFP, "No IP specified!\n");
		unwind_usage(cmd);
		return(1);
	}
	for (i = 0; i < cmd->nargs; i++) {
		kl_get_value(cmd->args[i], &mode, 0, &ip);
		unwind_ip(cmd->ofp, ip);
	}
	return(0);
}

#define _UNWIND_USAGE "[-a] [-f] [-n] [-w outfile] [ip_list]"

/*
 * unwind_usage() -- Print the usage string for the 'unwind' command.
 */
void
unwind_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _UNWIND_USAGE);
}

/*
 * unwind_help() -- Print the help information for the 'unwind' command.
 */
void
unwind_help(command_t *cmd)
{
	CMD_HELP(cmd, _UNWIND_USAGE,
        	"Help information for the unwind command.");
}

/*
 * unwind_parse() -- Parse the command line arguments for 'unwind'.
 */
int
unwind_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FULL|C_WRITE), 0)) {
		return(1);
	}
	return(0);
}

/*
 * unwind_complete() -- Complete arguments of 'unwind' command.
 */
char *
unwind_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	unwind_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
