/***************************************************************************
                          manager.c  -  description
                             -------------------
    begin                : Thu Sep 20 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include "manager.h"
#include "chart.h"
#include "event.h"
#include "config.h"
#ifdef SOUND
#include "audio.h"
#endif
#include "levels.h"
#include "theme.h"

extern Sdl sdl;
extern Config config;
extern List *menus; /* list of menus */
int menu_x = 54, menu_y = 220, menu_w = 256, menu_h = 256, menu_border = 16; /* default region where menu is displayed centered */
int cx = 384, cy = 220, cw = 256, ch = 200; /* center charts here */
Menu *cur_menu; /* current menu */
SDL_Surface *mbkgnd = 0; /* menu background */
Font *mfont = 0, *mhfont = 0, *mcfont = 0; /* font, highlight font, caption font */
int gap_height = 2;
extern char **levelset_names;
extern int levelset_count;
extern char **levelset_home_names;
extern int levelset_home_count;
extern int term_game;
#ifdef SOUND
Sound_Chunk *wav_menu_click = 0;
Sound_Chunk *wav_menu_motion = 0;
#endif
/* some items we need to know to assign name lists later */
Item *item_levelset, *item_set;
extern List *charts;
int chart_id = 0; /* current chart displayed */
/* theme name list */
extern char **theme_names;
extern int theme_count;

/* hints */
#define HINT_ 0
#define HINT_QUIT "There's nasty work out there waiting for you... better stay here!"
#define HINT_ANIM "If you turn animations low there'll be less details which will speed up the game a great deal."
#define HINT_TRP "Enable/disable transparency of bonuses and animations."
#define HINT_SHADOW "If you disable shadows it will speed up the game but won't look that good. ;-)"
#define HINT_DISPLAY "You may run LBreakout2 either fullscreen or windowed. This switch may be done anywhere by pressing 'f'."
#define HINT_FPS "You you don't want LBreakout2 to consume all of your CPU (best performance) limit the frame rate."
#define HINT_CONVEX "As long as this option is enabled the paddle is treated as convex allowing easy aiming. If you "\
                    "disable this option the real physics will show up and you'll have to influence the ball by paddle movement "\
                    "and the hemispherical ends. Just for cracks."
#define HINT_BALLLEVEL "If you can't see the ball because of thousands of bonuses coming down set this option to 'Above Bonuses'"
#define HINT_USEHINTS "Enable/disable these quick hints. See the manual for more information about how to use LBreakout2!"
#define HINT_KEYSPEED "If you use the keyboard as input you may here adjust the paddle speed to your needs."
#define HINT_PLAYERS "These are the number of players and their names. If one player looses a ball or restarts the level it's the next player's turn."
#define HINT_LEVELSET "This is the levelset you actually want to play. Note, that each levelset got it's own highscore chart (left/right-click on the chart on the right)." \
                      " A levelset is either load from ~/.lgames/lbreakout2-levels or the installation directory."
#define HINT_DIFF "EASY:#Lives: 6 (max. 10)#Paddle Size: 72 (max. 180)#Continue Cost: 20,000 points##"\
                  "MEDIUM:#Lives: 5 (max. 7)#Paddle Size: 72 (max. 144)#Continue Cost: 20,000 points#Bonus: 20%##"\
                  "HARD:#Lives: 4 (max. 5)#Paddle Size: 54 (max. 108)#Continue Cost: 30,000 points#Bonus: 40%##"\
                  "The bonus is added at the very end of the game."
#define HINT_STARTGAME "Let's get it on!"
#define HINT_EDITOR_SET "This is the list of the levelsets found in ~/.lgames/lbreakout2-levels which you may edit. If you "\
                        "choose <CREATE SET> and click on 'Edit Set' below you'll be asked to enter a levelsetname and the new levelset " \
                        "will be saved in a file by this name."
#define HINT_EDITOR_EDIT "Click here to edit the levelset chosen above."
#define HINT_EDITOR_DELETE "Click here to delete the chosen levelset (after confirmation)."
#define HINT_KEYS "If you use the keyboard for input these are the keys for moving the paddle, firing balls/shots and returning the ball to paddle after a timeout of ten seconds."
#define HINT_GRAB "Keeps the mouse in window. This option is only needed when running in windowed mode with relative mouse motion disabled."
#define HINT_RELMOTION "Turning this on allows you to invert the mouse motion, modify the mouse speed and use keyboard for fine-tuning."
#define HINT_MOD "This is the percentual motion modifier. The higher the faster the mouse moves."
#define HINT_INVERT "If for some reason you need an inversion. You may turn this on here."
#define HINT_INPUT "Here you may specify which input devices are allowed for input handling."
#define HINT_RETURN "If a ball does not damage a brick within ten seconds it is allowed to return to the paddle. If this option is set "\
                    "to 'Auto' it will automatically return and if this option is set to 'By Click' you'll have to press the middle mouse"\
                    "button or the 'back'-key (default is Backspace)."
#define HINT_THEME "This is the list of available themes. Choose any theme and click 'Apply' to select it. The menu is not themeable "\
                   "so you'll see the change when you run a game. Please check the manual at www.lgames.org for information on how to "\
                   "create a theme."

/*
====================================================================
Callbacks of menu items.
====================================================================
*/
/* Disable/enable sound */
void cb_sound() {
#ifdef SOUND
    sound_enable( config.sound );
#endif
}
/* set volume */
void cb_volume() {
#ifdef SOUND
    sound_volume( config.volume * 16 );
#endif
}
/* toggle fullscreen */
void cb_fullscreen() {
    manager_show();
}
/* delete set */
void cb_delete_set()
{
    char fname[512];
    /* do not delete <CREATE SET> file */
    if ( strequal( "<CREATE SET>", levelset_home_names[config.levelset_home_id] ) ) {
        printf( "You cannot delete '<CREATE SET>'!\n" );
        return;
    }
    /* get file name + path */
    sprintf( fname, "%s/%s/lbreakout2-levels/%s", getenv( "HOME" ), CONFIG_DIR_NAME, levelset_home_names[config.levelset_home_id] );
    remove( fname );
    levelsets_load_names(); /* reinit name lists and configs indices */
    /* reassign these name lists as position in memory has changed */
    value_set_new_names( item_levelset->value, levelset_names, levelset_count );
    value_set_new_names( item_set->value, levelset_home_names, levelset_home_count );
}
/* adjust set list */
void cb_adjust_set_list()
{
    /* reinit name lists and configs indices */
    levelsets_load_names();
    /* reassign these name lists as position in memory has changed */
    value_set_new_names( item_levelset->value, levelset_names, levelset_count );
    value_set_new_names( item_set->value, levelset_home_names, levelset_home_count );
}
/* set key speed from i_key_speed */
void cb_set_keyspeed()
{
    config.key_speed = (float)config.i_key_speed / 100;
}
/* if hints where disabled hide actual hint */
void cb_hints()
{
    if ( !config.use_hints )
        hint_set( 0 );
}
/* change theme */
void cb_change_theme()
{
    theme_load( theme_names[config.theme_id] );
}

/*
====================================================================
Load/delete background and create and link all menus
====================================================================
*/
void manager_create()
{
    Item *key1, *key2, *key3, *key4;
    Item *item;
    int filter[SDLK_LAST]; /* key filter */
    /* constant contence of switches */
    char *str_fps[] = { "No Limit", "50 FPS", "100 FPS", "200 FPS" };
    char *str_anim[] = { "Off", "Low", "Medium", "High" };
    char *str_diff[] = { "Easy", "Medium", "Hard" };
    char *str_ctrl[] = { "Keyboard Only", "Mouse Only", "Keyboard&Mouse" };
    char aux[128];
    /*
    main:
        new game:
            start game
			quick help
            ---
            levelset
            difficulty
            ---
            active players
            ---
            player1
            player2
            player3
            player4
        controls
        graphics
            animations
            transparency
            shadow
            ---
            display
            constant frame rate
        audio:
            sound
            volume
        advanced options:
            convex paddle
			ball level
            key speed
        editor:
            set: (list)
            edit
            delete
                yes
                no
            ---
            create empty set
                set name: (string)
                create set
                    yes
                    no
        ---
        quit
    */
    Menu *_main = 0;
#ifdef _1
    Menu *options = 0;
#endif
#ifdef SOUND
    Menu *audio = 0;
#endif
    Menu *gfx = 0;
    Menu *game = 0;
    Menu *cont = 0;
    Menu *adv = 0;
    Menu *editor = 0;
    Menu *confirm_delete = 0;
    Menu *theme = 0;

    /* load graphics and sounds */
    mbkgnd = load_surf( "menuback.bmp", SDL_SWSURFACE );
    SDL_SetColorKey( mbkgnd, 0, 0 );
    mfont = load_fixed_font( "f_small_yellow.bmp", 32, 96, 8, SDL_SWSURFACE );
    mhfont = load_fixed_font( "f_white.bmp", 32, 96, 10, SDL_SWSURFACE );
    mcfont = load_fixed_font( "f_yellow.bmp", 32, 96, 10, SDL_SWSURFACE );
#ifdef SOUND
    wav_menu_click = sound_chunk_load( "menu_click.wav" );
    wav_menu_motion = sound_chunk_load( "menu_motion.wav" );
#endif
    /* add version to background */
    mfont->align = ALIGN_X_RIGHT | ALIGN_Y_BOTTOM;
    sprintf( aux, "v%s", VERSION );
    write_text( mfont, mbkgnd, mbkgnd->w - 2, mbkgnd->h - 2 - mfont->height, aux, OPAQUE );
    write_text( mfont, mbkgnd, mbkgnd->w - 2, mbkgnd->h - 2, "http://www.lgames.org", OPAQUE );

    /* hints will be displayed on menu background */
    hint_set_bkgnd( mbkgnd );
    
    /* setup filter */
    filter_clear( filter );
    filter_set( filter, SDLK_a, SDLK_z, 1 );
    filter[SDLK_BACKSPACE] = 1;
    filter[SDLK_SPACE] = 1;
    filter[SDLK_RSHIFT] = 1;
    filter[SDLK_LSHIFT] = 1;
    filter[SDLK_LALT] = 1;
    filter[SDLK_RALT] = 1;
    filter[SDLK_LCTRL] = 1;
    filter[SDLK_RCTRL] = 1;
    filter[SDLK_UP] = 1;
    filter[SDLK_DOWN] = 1;
    filter[SDLK_LEFT] = 1;
    filter[SDLK_RIGHT] = 1;
    filter[SDLK_q] = 0;
    filter[SDLK_p] = 0;
    filter[SDLK_f] = 0;
    filter[SDLK_s] = 0;
    filter[SDLK_a] = 0;
    filter[SDLK_r] = 0;

    /* menus are added to this list for deleting later */
    menus = list_create( LIST_AUTO_DELETE, menu_delete );
    /* create menus */
    _main   = menu_create( "Menu", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
#ifdef _1
    options = menu_create( "Options", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
#endif
    gfx     = menu_create( "Graphics", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
    game    = menu_create( "New Game", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
    cont    = menu_create( "Controls", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
    adv     = menu_create( "Advanced Options", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
#ifdef SOUND
    audio = menu_create( "Audio", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
#endif
    editor  = menu_create( "Editor", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
    confirm_delete = menu_create( "Delete Set", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
    theme = menu_create( "Select Theme", MENU_LAYOUT_CENTERED, menu_x, menu_y, menu_w, menu_h, menu_border );
    /* create items */
    /* main menu */
    menu_add( _main, item_create_link    ( "New Game", HINT_, game ) );
    menu_add( _main, item_create_action  ( "Quick Help", HINT_, ACTION_QUICK_HELP ) );
    menu_add( _main, item_create_separator  ( "" ) );
#ifdef _1
    menu_add( _main, item_create_link       ( "Options", options ) );
#endif
    menu_add( _main, item_create_link       ( "Controls", HINT_, cont ) );
    menu_add( _main, item_create_link       ( "Graphics", HINT_, gfx ) );
#ifdef SOUND
    menu_add( _main, item_create_link       ( "Audio",  HINT_,audio ) );
#else
    menu_add( _main, item_create_separator  ( "Audio" ) );
#endif
    menu_add( _main, item_create_link       ( "Advanced Options", HINT_, adv ) );
    menu_add( _main, item_create_separator  ( "" ) );
    menu_add( _main, item_create_link       ( "Editor", HINT_, editor ) );
    menu_add( _main, item_create_separator  ( "" ) );
    menu_add( _main, item_create_action     ( "Quit", HINT_QUIT, ACTION_QUIT ) );
#ifdef _1
    /* options */
    menu_add( options, item_create_link( "Controls", HINT_, cont ) );
    menu_add( options, item_create_link( "Graphics", HINT_, gfx ) );
    menu_add( options, item_create_link( "Audio", HINT_, audio ) );
    menu_add( options, item_create_separator( "Audio" ) );
    menu_add( options, item_create_separator( "" ) );
    menu_add( options, item_create_link( "Back", _main ) );
#endif
    /* audio */
#ifdef SOUND
    item = item_create_switch( "Sound:", HINT_, &config.sound, "Off", "On" );
    item->callback = cb_sound;
    menu_add( audio, item );
    menu_add( audio, item_create_switch( "Speech:", HINT_, &config.speech, "Off", "On" ) );
    item = item_create_range( "Volume:", HINT_, &config.volume, 1, 8, 1 );
    item->callback = cb_volume;
    menu_add( audio, item );
    menu_add( audio, item_create_separator( "" ) );
    menu_add( audio, item_create_link( "Back", HINT_, _main ) );
#endif
    /* gfx */
    menu_add( gfx, item_create_switch_x( "Animations:", HINT_ANIM, &config.anim, str_anim, 4 ) );
    menu_add( gfx, item_create_switch( "Transparency:", HINT_TRP, &config.trp, "Off", "On" ) );
    menu_add( gfx, item_create_switch( "Shadow:", HINT_SHADOW, &config.shadow, "Off", "On" ) );
    menu_add( gfx, item_create_separator( "" ) );
    item = item_create_switch( "Display:", HINT_DISPLAY, &config.fullscreen, "Window", "Fullscreen" );
    item->callback = cb_fullscreen;
    menu_add( gfx, item );
    menu_add( gfx, item_create_switch_x( "Frame Rate:", HINT_FPS, &config.fps, str_fps, 4 ) );
    menu_add( gfx, item_create_separator( "" ) );
    menu_add( gfx, item_create_link( "Back", HINT_, _main ) );
    /* game */
    menu_add( game, item_create_action( "Start Game", HINT_STARTGAME, ACTION_PLAY ) );
    menu_add( game, item_create_separator( "" ) );
    item_levelset = item_create_switch_x( "Levelset:", HINT_LEVELSET, &config.levelset_id, levelset_names, levelset_count );
    menu_add( game, item_levelset );
    menu_add( game, item_create_switch_x( "Difficulty:", HINT_DIFF, &config.diff, str_diff, 3 ) );
    menu_add( game, item_create_separator( "" ) );
    menu_add( game, item_create_range( "Players:", HINT_PLAYERS, &config.player_count, 1, 4, 1 ) );
    menu_add( game, item_create_edit( "1st:", HINT_PLAYERS, config.player_names[0], 12 ) );
    menu_add( game, item_create_edit( "2nd:", HINT_PLAYERS, config.player_names[1], 12 ) );
    menu_add( game, item_create_edit( "3rd:", HINT_PLAYERS, config.player_names[2], 12 ) );
    menu_add( game, item_create_edit( "4th:", HINT_PLAYERS, config.player_names[3], 12 ) );
    menu_add( game, item_create_separator( "" ) );
    menu_add( game, item_create_link( "Back", HINT_, _main ) );
    /* controls */
    key1 = item_create_key( "Left:", HINT_KEYS, &config.k_left, filter );
    key2 = item_create_key( "Right:", HINT_KEYS, &config.k_right, filter );
    key3 = item_create_key( "Fire:", HINT_KEYS, &config.k_fire, filter );
    key4 = item_create_key( "Return:", HINT_KEYS, &config.k_return, filter );
    menu_add( cont, key1 );
    menu_add( cont, key2 );
    menu_add( cont, key3 );
    menu_add( cont, key4 );
    /* dynamic restriction */
    value_add_other_key( key1->value, key2->value );
    value_add_other_key( key1->value, key3->value );
    value_add_other_key( key1->value, key4->value );
    value_add_other_key( key2->value, key1->value );
    value_add_other_key( key2->value, key3->value );
    value_add_other_key( key2->value, key4->value );
    value_add_other_key( key3->value, key1->value );
    value_add_other_key( key3->value, key2->value );
    value_add_other_key( key3->value, key4->value );
    value_add_other_key( key4->value, key1->value );
    value_add_other_key( key4->value, key2->value );
    value_add_other_key( key4->value, key3->value );
    /* other control stuff */
    menu_add( cont, item_create_separator( "" ) );
    menu_add( cont, item_create_switch( "Grab Mouse:", HINT_GRAB, &config.grab, "Off", "On" ) );
    menu_add( cont, item_create_switch( "Relative Motion:", HINT_RELMOTION, &config.rel_motion, "Off", "On" ) );
    menu_add( cont, item_create_range( "Motion Modifier:", HINT_MOD, &config.motion_mod, 40, 160, 10 ) );
    menu_add( cont, item_create_switch( "Invert Motion:", HINT_INVERT, &config.invert, "Off", "On" ) );
    menu_add( cont, item_create_switch_x( "Input:", HINT_INPUT, &config.control, str_ctrl, 3 ) );
    menu_add( cont, item_create_separator( "" ) );
    menu_add( cont, item_create_link( "Back", HINT_, _main ) );
    /* advanced options */
    menu_add( adv, item_create_switch( "Convex Paddle:", HINT_CONVEX, &config.convex, "Off", "On" ) );
    menu_add( adv, item_create_switch( "Balls:", HINT_BALLLEVEL, &config.ball_level, "Below Bonuses", "Above Bonuses" ) );
    item = item_create_range( "Key Speed:", HINT_KEYSPEED, &config.i_key_speed, 40, 100, 5 );
    item->callback = cb_set_keyspeed;
    menu_add( adv, item );
    menu_add( adv, item_create_switch( "Return Balls:", HINT_RETURN, &config.return_on_click, "Auto", "By Click" ) );
    item = item_create_switch( "Use Hints:", HINT_USEHINTS, &config.use_hints, "Off", "On" );
    item->callback = cb_hints;
    menu_add( adv, item );
    menu_add( adv, item_create_separator( "" ) );
    menu_add( adv, item_create_link( "Select Theme", HINT_, theme ) );
    menu_add( adv, item_create_separator( "" ) );
    menu_add( adv, item_create_link( "Back", HINT_, _main ) );
    /* editor */
    item_set = item_create_switch_x( "Set:", HINT_EDITOR_SET, &config.levelset_home_id, levelset_home_names, levelset_home_count );
    menu_add( editor, item_set );
    menu_add( editor, item_create_action( "Edit Set", HINT_EDITOR_EDIT, ACTION_EDIT ) );
    menu_add( editor, item_create_link( "Delete Set", HINT_EDITOR_DELETE, confirm_delete ) );
    menu_add( editor, item_create_separator( "" ) );
    menu_add( editor, item_create_link( "Back", HINT_, _main ) );
    /* confirm_delete set */
    item = item_create_link( "Yes", HINT_ ,editor );
    item->callback = cb_delete_set;
    menu_add( confirm_delete, item );
    menu_add( confirm_delete, item_create_link( "No", HINT_, editor ) );
    /* theme */
    menu_add( theme, item_create_switch_x( "Theme:", HINT_THEME, &config.theme_id, theme_names, theme_count ) );
    menu_add( theme, item_create_separator( "" ) );
    item = item_create_link( "Apply", HINT_, adv );
    item->callback = cb_change_theme;
    menu_add( theme, item );
    menu_add( theme, item_create_link( "Cancel", HINT_, adv ) );

    /* adjust all menus */
    menu_adjust( _main );
#ifdef _1
    menu_adjust( options );
#endif
#ifdef SOUND
    menu_adjust( audio );
#endif
    menu_adjust( gfx );
    menu_adjust( game );
    menu_adjust( cont );
    menu_adjust( adv );
    menu_adjust( editor );
    menu_adjust( confirm_delete );
    menu_adjust( theme );
    /* set main menu as current */
    menu_select( _main );
}
void manager_delete()
{
    list_delete( menus );
    if ( mbkgnd ) SDL_FreeSurface( mbkgnd ); mbkgnd = 0;
    free_font( &mfont );
    free_font( &mhfont );
    free_font( &mcfont );
#ifdef SOUND
    sound_chunk_free( &wav_menu_click );
    sound_chunk_free( &wav_menu_motion );
#endif
}
/*
====================================================================
Run menu until request sent
====================================================================
*/
int manager_run()
{
    SDL_Event event;
    int event_polled = 0; /* event occured? */
    int result = ACTION_NONE;
    int ms;
    /* draw highscores */
    chart_show( chart_set_query_id( chart_id ), cx, cy, cw, ch );
    /* loop */
    reset_timer();
    while ( result == ACTION_NONE && !term_game ) {
        if ( event_poll( &event ) ) event_polled = 1;
        if ( event_polled && event.type == SDL_QUIT ) {
            result = ACTION_QUIT;
            term_game = 1;
        }
		/* fullscreen if no item selected */
		if ( event_polled ) {
			if ( cur_menu->cur_item == 0 || ( cur_menu->cur_item->type != ITEM_EDIT && cur_menu->cur_item->type != ITEM_KEY ) )
				if ( event.type == SDL_KEYUP )
					if ( event.key.keysym.sym == SDLK_f ) {
						config.fullscreen = !config.fullscreen;
						set_video_mode( std_video_mode( config.fullscreen ) );
						FULL_DEST( sdl.screen ); FULL_SOURCE( mbkgnd ); blit_surf();
					    chart_show( chart_set_query_id( chart_id ), cx, cy, cw, ch );
						refresh_screen( 0, 0 ,0, 0 );
					}
			/* check if clicked on highscore */
			if ( event.type == SDL_MOUSEBUTTONUP ) 
				if ( event.button.x >= cx && event.button.y >= cy )
					if ( event.button.x < cx + cw && event.button.y < cy + ch ) {
#ifdef SOUND
						sound_play( wav_menu_click );
#endif
						/* set chart id */
						if ( event.button.button == LEFT_BUTTON ) {
							chart_id++;
							if ( chart_id == charts->count ) chart_id = 0;
						}
						else {
							chart_id--;
							if ( chart_id == -1 ) chart_id = charts->count - 1;
						}
						/* redraw */
						FULL_DEST( sdl.screen ); FULL_SOURCE( mbkgnd ); blit_surf();
					    chart_show( chart_set_query_id( chart_id ), cx, cy, cw, ch );
						refresh_screen( cx, cy, cw, ch );
					}
		}			
        ms = get_time();
        menu_hide( cur_menu );
        hint_hide();
        if ( event_polled )
            result = menu_update( cur_menu, &event, ms );
        else
            result = menu_update( cur_menu, 0, ms );
        hint_update( ms );
        menu_show( cur_menu );
        chart_show( chart_set_query_id( chart_id ), cx, cy, cw, ch );
        hint_show();
        refresh_rects();
        event_polled = 0;
        SDL_Delay( 5 );
    }
    return result;
}
/*
====================================================================
Fade in/out background of menu
====================================================================
*/
void manager_fade( int type )
{
    if ( type == FADE_IN ) {
        FULL_DEST( sdl.screen ); FULL_SOURCE( mbkgnd ); blit_surf();
    }
    fade_screen( type, FADE_DEF_TIME );
}
/*
====================================================================
Update screen without menu itself as this is shown next frame.
====================================================================
*/
void manager_show()
{
    set_video_mode( std_video_mode( config.fullscreen ) );
    FULL_DEST( sdl.screen ); FULL_SOURCE( mbkgnd ); blit_surf();
    chart_show( chart_set_query_id( chart_id ), cx, cy, cw, ch );
    add_refresh_rect( 0, 0, sdl.screen->w, sdl.screen->h );
}

/*
====================================================================
Update set list when creating a new file for editor.
====================================================================
*/
void manager_update_set_list()
{
    cb_adjust_set_list(); /* hacky but shiiiit how cares? */
}
